/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.suggestions;

import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.Parameters;
import com.google.android.apps.common.testing.accessibility.framework.ResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.suggestions.FixSuggestionProducer;
import com.google.android.apps.common.testing.accessibility.framework.suggestions.SetViewAttributeFixSuggestion;
import com.google.android.apps.common.testing.accessibility.framework.suggestions.ViewAttribute;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityHierarchy;
import com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;

class RedundantDescriptionFixSuggestionProducer
implements FixSuggestionProducer<SetViewAttributeFixSuggestion> {
    private static final ViewAttribute VIEW_ATTRIBUTE_CONTENT_DESCRIPTION = new ViewAttribute("contentDescription");

    RedundantDescriptionFixSuggestionProducer() {
    }

    @Override
    public @Nullable SetViewAttributeFixSuggestion produceFixSuggestion(AccessibilityHierarchyCheckResult checkResult, AccessibilityHierarchy hierarchy, @Nullable Parameters parameters) {
        if (checkResult.getResultId() != 5) {
            return null;
        }
        ResultMetadata resultMetadata = (ResultMetadata)Preconditions.checkNotNull((Object)checkResult.getMetadata());
        String contentDescription = resultMetadata.getString("KEY_CONTENT_DESCRIPTION");
        String redundantWord = resultMetadata.getString("KEY_REDUNDANT_WORD");
        String suggestedContentDescription = contentDescription.replaceAll("\\b(?i)" + redundantWord + "\\b", " ").replaceAll(" +", " ").trim();
        if (suggestedContentDescription.length() == contentDescription.length()) {
            return null;
        }
        return new SetViewAttributeFixSuggestion(VIEW_ATTRIBUTE_CONTENT_DESCRIPTION, suggestedContentDescription);
    }
}

