/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.checks;

import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.HashMapResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.Parameters;
import com.google.android.apps.common.testing.accessibility.framework.ResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.ViewHierarchyElementUtils;
import com.google.android.apps.common.testing.accessibility.framework.ocr.OcrResult;
import com.google.android.apps.common.testing.accessibility.framework.ocr.TextComponent;
import com.google.android.apps.common.testing.accessibility.framework.replacements.Rect;
import com.google.android.apps.common.testing.accessibility.framework.replacements.SpannableString;
import com.google.android.apps.common.testing.accessibility.framework.replacements.TextUtils;
import com.google.android.apps.common.testing.accessibility.framework.strings.StringManager;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityHierarchy;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElement;
import com.google.android.apps.common.testing.accessibility.framework.uielement.WindowHierarchyElement;
import com.google.common.annotations.Beta;
import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

@Beta
public class UnexposedTextCheck
extends AccessibilityHierarchyCheck {
    public static final int RESULT_ID_NOT_VISIBLE = 1;
    public static final int RESULT_ID_NOT_IMPORTANT_FOR_ACCESSIBILITY = 2;
    public static final int RESULT_ID_OCR_RESULT_NOT_AVAILABLE = 3;
    public static final int RESULT_ID_SHOULD_NOT_FOCUS = 4;
    public static final int RESULT_ID_WEB_CONTENT = 5;
    public static final int RESULT_ID_TEXT_DETECTED_IN_IMAGE_VIEW = 6;
    public static final int RESULT_ID_NO_MATCHING_OCR_TEXT = 7;
    public static final int RESULT_ID_UNEXPOSED_TEXT = 8;
    public static final int RESULT_ID_MULTIPLE_BEST_MATCH_VIEWS = 9;
    public static final int RESULT_ID_UNEXPOSED_TEXT_IN_SURFACE_VIEW = 10;
    public static final int RESULT_ID_MULTIPLE_UNEXPOSED_TEXTS = 11;
    public static final int RESULT_ID_SINGLE_OCR_CHARACTER_WITHOUT_TEXT = 12;
    public static final String SURFACE_VIEW_CLASS_NAME = "android.view.SurfaceView";
    public static final String KEY_UNEXPOSED_TEXT = "KEY_UNEXPOSED_TEXT";
    public static final String KEY_UNEXPOSED_TEXTS = "KEY_UNEXPOSED_TEXTS";
    public static final String KEY_OCR_BOUNDS = "KEY_OCR_BOUNDS";
    public static final String KEY_TEXT_DETECTED_IN_IMAGE_VIEW = "KEY_TEXT_DETECTED_IN_IMAGE_VIEW";
    private static final float CONFIDENCE_FILTER_THRESHOLD = 0.5f;
    private static final int OCR_EDIT_DISTANCE_THRESHOLD = 2;
    private static final int MERGE_MULTIPLE_UNEXPOSED_OCR_RESULTS_IN_ONE_VIEW_THRESHOLD = 2;
    private static final ImmutableMap<Integer, String> MESSAGE_IDS = ImmutableMap.of((Object)1, (Object)"result_message_not_visible", (Object)2, (Object)"result_message_not_important_for_accessibility", (Object)5, (Object)"result_message_web_content", (Object)4, (Object)"result_message_should_not_focus", (Object)3, (Object)"result_message_ocr_result_not_available", (Object)7, (Object)"result_message_no_matching_ocr_results", (Object)9, (Object)"result_message_multiple_best_match_views", (Object)10, (Object)"result_message_text_detected_in_surface_view", (Object)12, (Object)"result_message_single_ocr_character_without_text");

    @Override
    protected @Nullable String getHelpTopic() {
        return null;
    }

    @Override
    public AccessibilityCheck.Category getCategory() {
        return AccessibilityCheck.Category.CONTENT_LABELING;
    }

    @Override
    public String getTitleMessage(Locale locale) {
        return StringManager.getString(locale, "check_title_unexposed_text");
    }

    @Override
    public String getMessageForResultData(Locale locale, int resultId, @Nullable ResultMetadata metadata) {
        String generated = UnexposedTextCheck.generateMessageForResultId(locale, resultId);
        if (generated != null) {
            return generated;
        }
        switch (resultId) {
            case 8: {
                return StringManager.getString(locale, "result_message_unexposed_text");
            }
            case 6: {
                return StringManager.getString(locale, "result_message_text_detected_in_image_view");
            }
            case 11: {
                return StringManager.getString(locale, "result_message_multiple_unexposed_texts");
            }
        }
        throw new IllegalStateException("Unsupported result id");
    }

    @Override
    public String getShortMessageForResultData(Locale locale, int resultId, @Nullable ResultMetadata metadata) {
        String generated = UnexposedTextCheck.generateMessageForResultId(locale, resultId);
        if (generated != null) {
            return generated;
        }
        switch (resultId) {
            case 8: {
                return String.format(locale, StringManager.getString(locale, "result_message_brief_unexposed_text"), ((ResultMetadata)Preconditions.checkNotNull((Object)metadata)).getString(KEY_UNEXPOSED_TEXT));
            }
            case 6: {
                return String.format(locale, StringManager.getString(locale, "result_message_brief_text_detected_in_image_view"), ((ResultMetadata)Preconditions.checkNotNull((Object)metadata)).getString(KEY_TEXT_DETECTED_IN_IMAGE_VIEW));
            }
            case 11: {
                return String.format(locale, StringManager.getString(locale, "result_message_brief_multiple_unexposed_texts"), ((ResultMetadata)Preconditions.checkNotNull((Object)metadata)).getStringList(KEY_UNEXPOSED_TEXTS).get(0));
            }
        }
        throw new IllegalStateException("Unsupported result id");
    }

    @Override
    public List<AccessibilityHierarchyCheckResult> runCheckOnHierarchy(AccessibilityHierarchy hierarchy, @Nullable ViewHierarchyElement fromRoot, @Nullable Parameters parameters) {
        ArrayList<AccessibilityHierarchyCheckResult> results = new ArrayList<AccessibilityHierarchyCheckResult>();
        Map<ViewHierarchyElement, List<TextComponent>> elementToTextListMap = UnexposedTextCheck.preprocessOcrResults(hierarchy, fromRoot, parameters);
        List<? extends ViewHierarchyElement> viewsToEval = UnexposedTextCheck.getElementsToEvaluate(fromRoot, hierarchy);
        Locale locale = hierarchy.getDeviceState().getLocale();
        for (ViewHierarchyElement viewHierarchyElement : viewsToEval) {
            results.addAll((Collection<AccessibilityHierarchyCheckResult>)this.generateCheckResults(viewHierarchyElement, elementToTextListMap, parameters, locale, viewsToEval, this.anyViewHasTextCharacterLocations(viewsToEval)));
        }
        return results;
    }

    private boolean anyViewHasTextCharacterLocations(List<? extends ViewHierarchyElement> views) {
        for (ViewHierarchyElement viewHierarchyElement : views) {
            if (viewHierarchyElement.getTextCharacterLocations().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static Map<ViewHierarchyElement, List<TextComponent>> preprocessOcrResults(AccessibilityHierarchy hierarchy, @Nullable ViewHierarchyElement fromRoot, @Nullable Parameters parameters) {
        HashMap<ViewHierarchyElement, List<TextComponent>> elementToTextListMap = new HashMap<ViewHierarchyElement, List<TextComponent>>();
        if (parameters == null || parameters.getOcrResult() == null) {
            return elementToTextListMap;
        }
        List<Rect> systemWindowBounds = UnexposedTextCheck.getSystemWindowBounds(hierarchy);
        Rect activeWindowBounds = hierarchy.getActiveWindow().getBoundsInScreen();
        List<? extends ViewHierarchyElement> allViews = hierarchy.getActiveWindow().getAllViews();
        ImmutableList<TextComponent> texts = ((OcrResult)Preconditions.checkNotNull((Object)parameters.getOcrResult())).getTexts();
        for (TextComponent textComponent : texts) {
            if (!activeWindowBounds.contains(textComponent.getBoundsInScreen()) || UnexposedTextCheck.isTextInsideSystemWindows(textComponent, systemWindowBounds) || fromRoot != null && !Rect.intersects(textComponent.getBoundsInScreen(), fromRoot.getBoundsInScreen())) continue;
            Map<TextComponent, ViewHierarchyElement> map = UnexposedTextCheck.buildBestMatchMap(textComponent, allViews);
            for (Map.Entry<TextComponent, ViewHierarchyElement> entry : map.entrySet()) {
                TextComponent text = entry.getKey();
                ViewHierarchyElement bestMatchElement = entry.getValue();
                ArrayList<TextComponent> textComponentList = (ArrayList<TextComponent>)elementToTextListMap.get(bestMatchElement);
                if (textComponentList == null) {
                    textComponentList = new ArrayList<TextComponent>();
                    elementToTextListMap.put(bestMatchElement, textComponentList);
                }
                textComponentList.add(text);
            }
        }
        return elementToTextListMap;
    }

    private ImmutableList<AccessibilityHierarchyCheckResult> generateCheckResults(ViewHierarchyElement view, Map<ViewHierarchyElement, List<TextComponent>> elementToTextListMap, @Nullable Parameters parameters, Locale locale, List<? extends ViewHierarchyElement> viewsToEval, boolean containsCharacterLocations) {
        boolean isTextListEmpty;
        if (parameters == null || parameters.getOcrResult() == null) {
            return ImmutableList.of((Object)this.createNotRunCheckResult(view, 3));
        }
        if (!Boolean.TRUE.equals(view.isVisibleToUser())) {
            return ImmutableList.of((Object)this.createNotRunCheckResult(view, 1));
        }
        List<TextComponent> textList = elementToTextListMap.get(view);
        boolean bl = isTextListEmpty = textList == null || textList.isEmpty();
        if (!isTextListEmpty && view.checkInstanceOf("android.widget.ImageView")) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (TextComponent text : (List)Preconditions.checkNotNull(textList)) {
                builder.add((Object)this.createNotRunCheckResultForTextInImageView(view, text.getValue()));
            }
            return builder.build();
        }
        if (!view.isImportantForAccessibility()) {
            return ImmutableList.of((Object)this.createNotRunCheckResult(view, 2));
        }
        if (view.checkInstanceOf("android.webkit.WebView") && view.getChildViewCount() == 0) {
            return ImmutableList.of((Object)this.createNotRunCheckResult(view, 5));
        }
        if (!ViewHierarchyElementUtils.shouldFocusView(view)) {
            return ImmutableList.of((Object)this.createNotRunCheckResult(view, 4));
        }
        SpannableString speakableText = ViewHierarchyElementUtils.getSpeakableTextForElement(view, locale);
        if (isTextListEmpty) {
            return ImmutableList.of((Object)this.createNotRunCheckResult(view, 7));
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (TextComponent text : (List)Preconditions.checkNotNull(textList)) {
            Rect intersection;
            ImmutableList bestMatchTextViews;
            String ocrText = text.getValue();
            Object object = bestMatchTextViews = containsCharacterLocations ? UnexposedTextCheck.filterViewsByOverlappingCharacterLocations(text, viewsToEval) : ImmutableList.of();
            if (bestMatchTextViews.size() == 1) {
                ViewHierarchyElement bestMatchView = (ViewHierarchyElement)bestMatchTextViews.get(0);
                String renderedText = UnexposedTextCheck.matchTextToCharacterLocations(text, bestMatchView);
                if (!UnexposedTextCheck.ocrResultMatchesRenderedText(text.getValue(), renderedText)) continue;
                ocrText = renderedText;
            } else {
                if (bestMatchTextViews.size() > 1) {
                    builder.add((Object)this.createNotRunCheckResult(view, 9));
                    continue;
                }
                if (bestMatchTextViews.isEmpty() && ocrText.length() == 1) {
                    builder.add((Object)this.createNotRunCheckResultForSingleCharOcr(view, ocrText));
                    continue;
                }
            }
            if (UnexposedTextCheck.isTextMatching(ocrText, speakableText.toString())) continue;
            ViewHierarchyElement bestMatchViewIncludeNotImportantViews = UnexposedTextCheck.findBestMatchView(text, view.getSelfAndAllDescendants(), true);
            if (bestMatchViewIncludeNotImportantViews != null && bestMatchViewIncludeNotImportantViews.checkInstanceOf("android.widget.ImageView")) {
                builder.add((Object)this.createNotRunCheckResultForTextInImageView(bestMatchViewIncludeNotImportantViews, text.getValue()));
                continue;
            }
            if (view.checkInstanceOf(SURFACE_VIEW_CLASS_NAME)) {
                builder.add((Object)new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.WARNING, view, 10, null));
                return builder.build();
            }
            if (!view.getBoundsInScreen().contains(text.getBoundsInScreen()) && (double)(intersection = view.getBoundsInScreen().intersect(text.getBoundsInScreen())).area() < 0.3 * (double)text.getBoundsInScreen().area()) continue;
            HashMapResultMetadata resultMetadata = new HashMapResultMetadata();
            resultMetadata.putString(KEY_UNEXPOSED_TEXT, ocrText);
            resultMetadata.putString(KEY_OCR_BOUNDS, text.getBoundsInScreen().flattenToString());
            AccessibilityCheckResult.AccessibilityCheckResultType resultType = bestMatchTextViews.isEmpty() ? AccessibilityCheckResult.AccessibilityCheckResultType.INFO : AccessibilityCheckResult.AccessibilityCheckResultType.WARNING;
            builder.add((Object)new AccessibilityHierarchyCheckResult(this.getClass(), resultType, view, 8, resultMetadata));
        }
        return this.mergeCheckResultsForOneViewIfPossible((ImmutableList<AccessibilityHierarchyCheckResult>)builder.build(), view);
    }

    private static @Nullable String generateMessageForResultId(Locale locale, int resultId) {
        String messageId = (String)MESSAGE_IDS.get((Object)resultId);
        return messageId == null ? null : StringManager.getString(locale, messageId);
    }

    private ImmutableList<AccessibilityHierarchyCheckResult> mergeCheckResultsForOneViewIfPossible(ImmutableList<AccessibilityHierarchyCheckResult> results, ViewHierarchyElement view) {
        ArrayList<AccessibilityHierarchyCheckResult> unexposedTextWarnings = new ArrayList<AccessibilityHierarchyCheckResult>();
        ArrayList<AccessibilityHierarchyCheckResult> unexposedTextInfos = new ArrayList<AccessibilityHierarchyCheckResult>();
        ArrayList<AccessibilityHierarchyCheckResult> otherResults = new ArrayList<AccessibilityHierarchyCheckResult>();
        for (AccessibilityHierarchyCheckResult result : results) {
            if (result.getResultId() == 8) {
                if (result.getType() == AccessibilityCheckResult.AccessibilityCheckResultType.WARNING) {
                    unexposedTextWarnings.add(result);
                    continue;
                }
                if (result.getType() != AccessibilityCheckResult.AccessibilityCheckResultType.INFO) continue;
                unexposedTextInfos.add(result);
                continue;
            }
            otherResults.add(result);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        return builder.addAll(this.mergeUnexposedTextCheckResults(unexposedTextWarnings, AccessibilityCheckResult.AccessibilityCheckResultType.WARNING, view)).addAll(this.mergeUnexposedTextCheckResults(unexposedTextInfos, AccessibilityCheckResult.AccessibilityCheckResultType.INFO, view)).addAll(otherResults).build();
    }

    private List<AccessibilityHierarchyCheckResult> mergeUnexposedTextCheckResults(List<AccessibilityHierarchyCheckResult> results, AccessibilityCheckResult.AccessibilityCheckResultType resultType, ViewHierarchyElement view) {
        if (results.size() > 2) {
            HashMapResultMetadata resultMetadata = new HashMapResultMetadata();
            ArrayList<String> unexposedTexts = new ArrayList<String>();
            for (AccessibilityHierarchyCheckResult result : results) {
                ResultMetadata metadata = (ResultMetadata)Preconditions.checkNotNull((Object)result.getMetadata());
                unexposedTexts.add((String)Preconditions.checkNotNull((Object)metadata.getString(KEY_UNEXPOSED_TEXT)));
            }
            resultMetadata.putStringList(KEY_UNEXPOSED_TEXTS, unexposedTexts);
            return ImmutableList.of((Object)new AccessibilityHierarchyCheckResult(this.getClass(), resultType, view, 11, resultMetadata));
        }
        return results;
    }

    private AccessibilityHierarchyCheckResult createNotRunCheckResult(ViewHierarchyElement element, int resultId) {
        return new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, element, resultId, null);
    }

    private AccessibilityHierarchyCheckResult createNotRunCheckResultForTextInImageView(ViewHierarchyElement view, String text) {
        HashMapResultMetadata resultMetadata = new HashMapResultMetadata();
        resultMetadata.putString(KEY_TEXT_DETECTED_IN_IMAGE_VIEW, text);
        return new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, view, 6, resultMetadata);
    }

    private AccessibilityHierarchyCheckResult createNotRunCheckResultForSingleCharOcr(ViewHierarchyElement view, String ocrText) {
        HashMapResultMetadata resultMetadata = new HashMapResultMetadata();
        resultMetadata.putString(KEY_UNEXPOSED_TEXT, ocrText);
        return new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, view, 12, resultMetadata);
    }

    private static List<Rect> getSystemWindowBounds(AccessibilityHierarchy hierarchy) {
        ArrayList<Rect> systemWindowBounds = new ArrayList<Rect>();
        Collection<? extends WindowHierarchyElement> windows = hierarchy.getAllWindows();
        for (WindowHierarchyElement windowHierarchyElement : windows) {
            Integer windowType = windowHierarchyElement.getType();
            if (windowType == null || windowType != 3 && windowType != 2) continue;
            systemWindowBounds.add(windowHierarchyElement.getBoundsInScreen());
        }
        return systemWindowBounds;
    }

    private static boolean isTextInsideSystemWindows(TextComponent textComponent, List<Rect> systemWindowBounds) {
        for (Rect windowBoundsInScreen : systemWindowBounds) {
            if (!windowBoundsInScreen.contains(textComponent.getBoundsInScreen())) continue;
            return true;
        }
        return false;
    }

    private static boolean ocrResultMatchesRenderedText(String ocrText, String renderedText) {
        return UnexposedTextCheck.editDistance(ocrText, renderedText) <= 2;
    }

    private static boolean isTextMatching(String text, String targetText) {
        if (TextUtils.isEmpty(targetText)) {
            return false;
        }
        if (targetText.contains(text)) {
            return true;
        }
        String asciiOcrText = Ascii.toLowerCase((String)text.replaceAll("[^a-zA-Z0-9]", ""));
        String asciiSpeakableText = Ascii.toLowerCase((String)targetText.replaceAll("[^a-zA-Z0-9]", ""));
        if (asciiSpeakableText.contains(asciiOcrText)) {
            return true;
        }
        return Math.abs(asciiOcrText.length() - asciiSpeakableText.length()) <= 1 && UnexposedTextCheck.editDistance(asciiOcrText, asciiSpeakableText) <= 1;
    }

    private static List<TextComponent> flattenTextComponent(TextComponent textComponent) {
        ArrayList<TextComponent> components = new ArrayList<TextComponent>();
        if (textComponent.getComponents().isEmpty()) {
            if (textComponent.getConfidence() == null || ((Float)Preconditions.checkNotNull((Object)textComponent.getConfidence())).floatValue() > 0.5f) {
                components.add(textComponent);
            }
        } else {
            for (TextComponent subText : textComponent.getComponents()) {
                components.addAll(UnexposedTextCheck.flattenTextComponent(subText));
            }
        }
        return components;
    }

    private static Map<TextComponent, ViewHierarchyElement> buildBestMatchMap(TextComponent textComponent, List<? extends ViewHierarchyElement> allViews) {
        HashMap<TextComponent, ViewHierarchyElement> map = new HashMap<TextComponent, ViewHierarchyElement>();
        List<TextComponent> wordList = UnexposedTextCheck.flattenTextComponent(textComponent);
        Map<TextComponent, Integer> wordStartIndexMap = UnexposedTextCheck.createWordStartIndices(wordList, textComponent);
        ArrayList<TextComponent> consecutiveWordList = new ArrayList<TextComponent>();
        ViewHierarchyElement lastBestMatchA11yImportantOnly = null;
        ViewHierarchyElement lastBestMatchIncludingA11yNotImportant = null;
        TextComponent lastSubText = null;
        for (TextComponent word : wordList) {
            ViewHierarchyElement bestMatchViewA11yImportantOnly = UnexposedTextCheck.findBestMatchView(word, allViews, false);
            ViewHierarchyElement bestMatchViewIncludingA11yNotImportant = UnexposedTextCheck.findBestMatchView(word, allViews, true);
            if (bestMatchViewA11yImportantOnly == null || bestMatchViewIncludingA11yNotImportant == null) continue;
            if (lastBestMatchA11yImportantOnly == null || UnexposedTextCheck.isSameLine(word, (TextComponent)Preconditions.checkNotNull(lastSubText)) && bestMatchViewIncludingA11yNotImportant == lastBestMatchIncludingA11yNotImportant && bestMatchViewA11yImportantOnly == lastBestMatchA11yImportantOnly) {
                consecutiveWordList.add(word);
            } else {
                String substring = UnexposedTextCheck.getSubString(textComponent.getValue(), consecutiveWordList, wordStartIndexMap);
                map.put(TextComponent.newBuilder(substring, UnexposedTextCheck.getSubStringBoundsInScreen(consecutiveWordList)).build(), lastBestMatchA11yImportantOnly);
                consecutiveWordList = new ArrayList();
                consecutiveWordList.add(word);
            }
            lastSubText = word;
            lastBestMatchA11yImportantOnly = bestMatchViewA11yImportantOnly;
            lastBestMatchIncludingA11yNotImportant = bestMatchViewIncludingA11yNotImportant;
        }
        if (lastBestMatchA11yImportantOnly != null && !consecutiveWordList.isEmpty()) {
            String substring = UnexposedTextCheck.getSubString(textComponent.getValue(), consecutiveWordList, wordStartIndexMap);
            map.put(TextComponent.newBuilder(substring, UnexposedTextCheck.getSubStringBoundsInScreen(consecutiveWordList)).build(), lastBestMatchA11yImportantOnly);
        }
        return map;
    }

    private static Map<TextComponent, Integer> createWordStartIndices(List<TextComponent> wordList, TextComponent textComponent) {
        HashMap<TextComponent, Integer> wordStartIndexMap = new HashMap<TextComponent, Integer>();
        int startIndex = 0;
        for (TextComponent subText : wordList) {
            startIndex = textComponent.getValue().indexOf(subText.getValue(), startIndex);
            wordStartIndexMap.put(subText, startIndex);
            startIndex += subText.getValue().length();
        }
        return wordStartIndexMap;
    }

    private static boolean isSameLine(TextComponent firstWord, TextComponent secondWord) {
        return secondWord.getBoundsInScreen().getTop() < firstWord.getBoundsInScreen().getBottom() && firstWord.getBoundsInScreen().getTop() < secondWord.getBoundsInScreen().getBottom();
    }

    private static String getSubString(String paragraph, List<TextComponent> consecutiveWordList, Map<TextComponent, Integer> wordStartIndexMap) {
        if (consecutiveWordList.size() == 1) {
            return consecutiveWordList.get(0).getValue();
        }
        TextComponent lastTextComponent = (TextComponent)Iterables.getLast(consecutiveWordList);
        return paragraph.substring((Integer)Preconditions.checkNotNull((Object)wordStartIndexMap.get(consecutiveWordList.get(0))), (Integer)Preconditions.checkNotNull((Object)wordStartIndexMap.get(lastTextComponent)) + lastTextComponent.getValue().length());
    }

    private static Rect getSubStringBoundsInScreen(List<TextComponent> wordList) {
        if (wordList.isEmpty()) {
            return Rect.EMPTY;
        }
        Rect subRect = wordList.get(0).getBoundsInScreen();
        for (int i = 1; i < wordList.size(); ++i) {
            subRect = subRect.union(wordList.get(i).getBoundsInScreen());
        }
        return subRect;
    }

    private static @Nullable ViewHierarchyElement findBestMatchView(TextComponent textComponent, List<? extends ViewHierarchyElement> allViews, boolean includeNotImportantViews) {
        ViewHierarchyElement focusableForAccessibilityAncestor;
        List<ViewHierarchyElement> viewsWithOverlappingCharacters = UnexposedTextCheck.filterViewsByOverlappingCharacterLocations(textComponent, allViews);
        if (includeNotImportantViews && !viewsWithOverlappingCharacters.isEmpty()) {
            allViews = viewsWithOverlappingCharacters;
        } else if (!includeNotImportantViews && viewsWithOverlappingCharacters.size() == 1 && (focusableForAccessibilityAncestor = ViewHierarchyElementUtils.getFocusableForAccessibilityAncestor(viewsWithOverlappingCharacters.get(0))) != null) {
            return focusableForAccessibilityAncestor;
        }
        ViewHierarchyElement bestMatch = null;
        float highestIOU = 0.0f;
        for (ViewHierarchyElement viewHierarchyElement : allViews) {
            float iou;
            if (!includeNotImportantViews && (!viewHierarchyElement.isImportantForAccessibility() || !ViewHierarchyElementUtils.shouldFocusView(viewHierarchyElement)) || !((iou = UnexposedTextCheck.calculateIntersectionOverUnion(viewHierarchyElement.getBoundsInScreen(), textComponent.getBoundsInScreen())) > 0.0f) || !(iou >= highestIOU)) continue;
            bestMatch = viewHierarchyElement;
            highestIOU = iou;
        }
        return bestMatch;
    }

    private static List<ViewHierarchyElement> filterViewsByOverlappingCharacterLocations(TextComponent textComponent, List<? extends ViewHierarchyElement> allViews) {
        ArrayList<ViewHierarchyElement> results = new ArrayList<ViewHierarchyElement>();
        block0: for (ViewHierarchyElement viewHierarchyElement : allViews) {
            for (Rect charBounds : viewHierarchyElement.getTextCharacterLocations()) {
                if (!Rect.intersects(textComponent.getBoundsInScreen(), charBounds)) continue;
                results.add(viewHierarchyElement);
                continue block0;
            }
        }
        return results;
    }

    private static String matchTextToCharacterLocations(TextComponent ocrText, ViewHierarchyElement view) {
        SpannableString viewText = (SpannableString)Preconditions.checkNotNull((Object)view.getText());
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < view.getTextCharacterLocations().size() && i < viewText.length(); ++i) {
            if (!Rect.intersects(view.getTextCharacterLocations().get(i), ocrText.getBoundsInScreen())) continue;
            stringBuilder.append(viewText.charAt(i));
        }
        return stringBuilder.toString();
    }

    private static float calculateIntersectionOverUnion(Rect r1, Rect r2) {
        if (!Rect.intersects(r1, r2)) {
            return 0.0f;
        }
        Rect union = r1.union(r2);
        Rect intersect = r1.intersect(r2);
        return (float)intersect.area() / (float)union.area();
    }

    private static int editDistance(String s1, String s2) {
        if (s1.length() < s2.length()) {
            String temp = s2;
            s2 = s1;
            s1 = temp;
        }
        int[] costs = new int[s2.length() + 1];
        for (int i = 0; i <= s1.length(); ++i) {
            int lastValue = i;
            for (int j = 0; j <= s2.length(); ++j) {
                if (i == 0) {
                    costs[j] = j;
                    continue;
                }
                if (j <= 0) continue;
                int newValue = costs[j - 1];
                if (s1.charAt(i - 1) != s2.charAt(j - 1)) {
                    newValue = Ints.min((int[])new int[]{newValue, lastValue, costs[j]}) + 1;
                }
                costs[j - 1] = lastValue;
                lastValue = newValue;
            }
            if (i <= 0) continue;
            costs[s2.length()] = lastValue;
        }
        return costs[s2.length()];
    }
}

