/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.Answer;
import com.google.android.apps.common.testing.accessibility.framework.Question;
import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;

@Beta
public abstract class QuestionHandler {
    public boolean hasQuestion(AccessibilityHierarchyCheckResult result) {
        return this.getNextQuestion(result) != null;
    }

    public abstract @Nullable Question getNextQuestion(AccessibilityHierarchyCheckResult var1);

    public abstract String getQuestionMessage(Question var1, Locale var2);

    public abstract ImmutableList<AccessibilityHierarchyCheckResult> updateResult(Answer var1);

    protected static ImmutableList<AccessibilityHierarchyCheckResult> updateResultByAppendingAnswer(Answer answer) {
        AccessibilityHierarchyCheckResult originalResult = answer.getQuestion().getOriginalResult();
        ImmutableList answers = ImmutableList.builder().addAll(originalResult.getAnswers()).add((Object)answer).build();
        return ImmutableList.of((Object)new AccessibilityHierarchyCheckResult(originalResult.getSourceCheckClass(), originalResult.getType(), originalResult.getElement(), originalResult.getResultId(), originalResult.getMetadata(), (ImmutableList<Answer>)answers));
    }

    protected static @Nullable Answer getFirstAnswerForQuestionId(AccessibilityHierarchyCheckResult result, int questionId) {
        for (Answer answer : result.getAnswers()) {
            if (answer.getQuestion().getQuestionId() != questionId) continue;
            return answer;
        }
        return null;
    }

    protected static ImmutableList<Answer> getAnswersForQuestionId(AccessibilityHierarchyCheckResult result, int questionId) {
        ImmutableList.Builder answersBuilder = ImmutableList.builder();
        for (Answer answer : result.getAnswers()) {
            if (answer.getQuestion().getQuestionId() != questionId) continue;
            answersBuilder.add((Object)answer);
        }
        return answersBuilder.build();
    }

    protected static boolean haveAskedQuestion(AccessibilityHierarchyCheckResult result, int questionId) {
        return QuestionHandler.getFirstAnswerForQuestionId(result, questionId) != null;
    }
}

