/*
 * Decompiled with CFR 0.152.
 */
package com.android.systemui.monet;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TonalPalette {
    private final com.google.ux.material.libmonet.palettes.TonalPalette mMaterialTonalPalette;
    @Deprecated
    public final List<Integer> allShades;
    public final Map<Integer, Integer> allShadesMapped;
    public static final List<Integer> SHADE_KEYS = Arrays.asList(0, 10, 50, 100, 200, 300, 400, 500, 600, 700, 800, 900, 1000);

    TonalPalette(com.google.ux.material.libmonet.palettes.TonalPalette materialTonalPalette) {
        this.mMaterialTonalPalette = materialTonalPalette;
        this.allShades = SHADE_KEYS.stream().map(key -> this.getAtTone(key.floatValue())).collect(Collectors.toList());
        this.allShadesMapped = SHADE_KEYS.stream().collect(Collectors.toMap(key -> key, key -> this.getAtTone(key.floatValue())));
    }

    public int getAtTone(float shade) {
        return this.mMaterialTonalPalette.tone((int)((1000.0f - shade) / 10.0f));
    }

    public int getS0() {
        return this.allShades.get(0);
    }

    public int getS10() {
        return this.allShades.get(1);
    }

    public int getS50() {
        return this.allShades.get(2);
    }

    public int getS100() {
        return this.allShades.get(3);
    }

    public int getS200() {
        return this.allShades.get(4);
    }

    public int getS300() {
        return this.allShades.get(5);
    }

    public int getS400() {
        return this.allShades.get(6);
    }

    public int getS500() {
        return this.allShades.get(7);
    }

    public int getS600() {
        return this.allShades.get(8);
    }

    public int getS700() {
        return this.allShades.get(9);
    }

    public int getS800() {
        return this.allShades.get(10);
    }

    public int getS900() {
        return this.allShades.get(11);
    }

    public int getS1000() {
        return this.allShades.get(12);
    }
}

