/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.annotation.NonNull;
import android.graphics.Rect;
import android.view.DisplayCutout;
import android.view.DisplayInfo;
import android.view.DisplayShape;
import android.view.InsetsSource;
import android.view.InsetsState;
import android.view.PrivacyIndicatorBounds;
import android.view.RoundedCorners;
import android.view.WindowInsets;

public class DisplayFrames {
    private static final int ID_DISPLAY_CUTOUT_LEFT = InsetsSource.createId(null, 0, WindowInsets.Type.displayCutout());
    private static final int ID_DISPLAY_CUTOUT_TOP = InsetsSource.createId(null, 1, WindowInsets.Type.displayCutout());
    private static final int ID_DISPLAY_CUTOUT_RIGHT = InsetsSource.createId(null, 2, WindowInsets.Type.displayCutout());
    private static final int ID_DISPLAY_CUTOUT_BOTTOM = InsetsSource.createId(null, 3, WindowInsets.Type.displayCutout());
    private final InsetsState mInsetsState;
    private final Rect mUnrestricted = new Rect();
    private final Rect mDisplayCutoutSafe = new Rect();
    private int mWidth;
    private int mHeight;
    private int mRotation;

    public DisplayFrames(InsetsState insetsState, DisplayInfo info, DisplayCutout cutout, RoundedCorners roundedCorners, PrivacyIndicatorBounds indicatorBounds, DisplayShape displayShape) {
        this.mInsetsState = insetsState;
        this.update(info.rotation, info.logicalWidth, info.logicalHeight, cutout, roundedCorners, indicatorBounds, displayShape);
    }

    public boolean update(int rotation, int w, int h, @NonNull DisplayCutout displayCutout, @NonNull RoundedCorners roundedCorners, @NonNull PrivacyIndicatorBounds indicatorBounds, @NonNull DisplayShape displayShape) {
        InsetsState state = this.mInsetsState;
        Rect safe = this.mDisplayCutoutSafe;
        if (this.mRotation == rotation && this.mWidth == w && this.mHeight == h && this.mInsetsState.getDisplayCutout().equals(displayCutout) && state.getRoundedCorners().equals(roundedCorners) && state.getPrivacyIndicatorBounds().equals(indicatorBounds)) {
            return false;
        }
        this.mRotation = rotation;
        this.mWidth = w;
        this.mHeight = h;
        Rect u = this.mUnrestricted;
        u.set(0, 0, w, h);
        state.setDisplayFrame(u);
        state.setDisplayCutout(displayCutout);
        state.setRoundedCorners(roundedCorners);
        state.setPrivacyIndicatorBounds(indicatorBounds);
        state.setDisplayShape(displayShape);
        state.getDisplayCutoutSafe(safe);
        if (safe.left > u.left) {
            state.getOrCreateSource(ID_DISPLAY_CUTOUT_LEFT, WindowInsets.Type.displayCutout()).setFrame(u.left, u.top, safe.left, u.bottom).updateSideHint(u);
        } else {
            state.removeSource(ID_DISPLAY_CUTOUT_LEFT);
        }
        if (safe.top > u.top) {
            state.getOrCreateSource(ID_DISPLAY_CUTOUT_TOP, WindowInsets.Type.displayCutout()).setFrame(u.left, u.top, u.right, safe.top).updateSideHint(u);
        } else {
            state.removeSource(ID_DISPLAY_CUTOUT_TOP);
        }
        if (safe.right < u.right) {
            state.getOrCreateSource(ID_DISPLAY_CUTOUT_RIGHT, WindowInsets.Type.displayCutout()).setFrame(safe.right, u.top, u.right, u.bottom).updateSideHint(u);
        } else {
            state.removeSource(ID_DISPLAY_CUTOUT_RIGHT);
        }
        if (safe.bottom < u.bottom) {
            state.getOrCreateSource(ID_DISPLAY_CUTOUT_BOTTOM, WindowInsets.Type.displayCutout()).setFrame(u.left, safe.bottom, u.right, u.bottom).updateSideHint(u);
        } else {
            state.removeSource(ID_DISPLAY_CUTOUT_BOTTOM);
        }
        return true;
    }
}

