/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.ide.common.rendering.api.XmlParserFactory;
import com.android.layoutlib.bridge.impl.LayoutParserWrapper;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ParserFactory {
    public static final boolean LOG_PARSER = false;
    @Nullable
    private static XmlParserFactory sParserFactory;

    public static void setParserFactory(@Nullable XmlParserFactory parserFactory) {
        sParserFactory = parserFactory;
    }

    @Nullable
    public static XmlPullParser create(@NonNull String filePath) throws XmlPullParserException {
        return ParserFactory.create(filePath, false);
    }

    @Nullable
    public static XmlPullParser create(@NonNull String filePath, boolean isLayout) throws XmlPullParserException {
        XmlPullParser parser = sParserFactory.createXmlParserForFile(filePath);
        if (parser != null && isLayout) {
            try {
                return new LayoutParserWrapper(parser).peekTillLayoutStart();
            }
            catch (IOException e) {
                throw new XmlPullParserException(null, parser, (Throwable)e);
            }
        }
        return parser;
    }

    @NonNull
    public static XmlPullParser create(@NonNull InputStream stream, @Nullable String name) throws XmlPullParserException {
        XmlPullParser parser = ParserFactory.create();
        stream = ParserFactory.readAndClose(stream, name);
        parser.setInput(stream, null);
        return parser;
    }

    @NonNull
    public static XmlPullParser create() throws XmlPullParserException {
        if (sParserFactory == null) {
            throw new XmlPullParserException("ParserFactory not initialized.");
        }
        XmlPullParser parser = sParserFactory.createXmlParser();
        parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        return parser;
    }

    @NonNull
    private static InputStream readAndClose(@NonNull InputStream stream, @Nullable String name) throws XmlPullParserException {
        ByteArrayInputStream byteArrayInputStream;
        BufferedInputStream bufferedStream = new BufferedInputStream(stream);
        try {
            int avail = bufferedStream.available();
            byte[] buffer = new byte[avail];
            int read = stream.read(buffer);
            while ((avail = bufferedStream.available()) > 0) {
                if (read + avail > buffer.length) {
                    byte[] moreBuffer = new byte[read + avail];
                    System.arraycopy(buffer, 0, moreBuffer, 0, read);
                    buffer = moreBuffer;
                }
                read += stream.read(buffer, read, avail);
            }
            byteArrayInputStream = new ByteArrayInputStream(buffer);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bufferedStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new XmlPullParserException("Failed to read " + name, null, (Throwable)e);
            }
        }
        bufferedStream.close();
        return byteArrayInputStream;
    }
}

