/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.android.support;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.Context;
import android.view.View;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.common.util.ReflectionUtils;

public class RecyclerViewUtil {
    public static final String[] CN_RECYCLER_VIEW = new String[]{"android.support.v7.widget.RecyclerView", "androidx.recyclerview.widget.RecyclerView"};
    private static final Class<?>[] LLM_CONSTRUCTOR_SIGNATURE = new Class[]{Context.class};

    public static void setAdapter(@NonNull View recyclerView, @NonNull BridgeContext context, @NonNull LayoutlibCallback layoutlibCallback, int adapterLayout, int itemCount) {
        Class<?> recyclerViewClass = ReflectionUtils.getParentClass(recyclerView, CN_RECYCLER_VIEW);
        if (recyclerViewClass == null) {
            Bridge.getLog().error("broken", "Unable to setup RecyclerView. No parent found.", null, null, null);
            return;
        }
        String recyclerViewClassName = recyclerViewClass.getName();
        String recyclerViewPackageName = recyclerViewClass.getPackage().getName();
        String adapterClassName = recyclerViewClassName + "$Adapter";
        String layoutMgrClassName = recyclerViewClassName + "$LayoutManager";
        try {
            RecyclerViewUtil.setLayoutManager(recyclerView, recyclerViewPackageName, layoutMgrClassName, context, layoutlibCallback);
            Object adapter = RecyclerViewUtil.createAdapter(layoutlibCallback, adapterClassName);
            if (adapter != null) {
                RecyclerViewUtil.setProperty((Object)recyclerView, adapterClassName, adapter, "setAdapter");
                RecyclerViewUtil.setProperty(adapter, Integer.TYPE, (Object)adapterLayout, "setLayoutId");
                if (itemCount != -1) {
                    RecyclerViewUtil.setProperty(adapter, Integer.TYPE, (Object)itemCount, "setItemCount");
                }
            }
        }
        catch (ReflectionUtils.ReflectionException e) {
            Throwable cause = ReflectionUtils.getCause(e);
            Bridge.getLog().error("broken", "Error occurred while trying to setup RecyclerView.", cause, null, null);
        }
    }

    private static void setLayoutManager(@NonNull View recyclerView, @NonNull String recyclerViewPackageName, @NonNull String layoutMgrClassName, @NonNull BridgeContext context, @NonNull LayoutlibCallback callback) throws ReflectionUtils.ReflectionException {
        String linearLayoutMgrClassManager;
        Object layoutManager;
        if (RecyclerViewUtil.getLayoutManager(recyclerView) == null && (layoutManager = RecyclerViewUtil.createLayoutManager(context, linearLayoutMgrClassManager = recyclerViewPackageName + ".LinearLayoutManager", callback)) != null) {
            RecyclerViewUtil.setProperty((Object)recyclerView, layoutMgrClassName, layoutManager, "setLayoutManager");
        }
    }

    @Nullable
    private static Object createLayoutManager(@NonNull Context context, @NonNull String linearLayoutMgrClassName, @NonNull LayoutlibCallback callback) throws ReflectionUtils.ReflectionException {
        try {
            return callback.loadClass(linearLayoutMgrClassName, (Class[])LLM_CONSTRUCTOR_SIGNATURE, new Object[]{context});
        }
        catch (Exception e) {
            throw new ReflectionUtils.ReflectionException(e);
        }
    }

    @Nullable
    private static Object getLayoutManager(View recyclerView) throws ReflectionUtils.ReflectionException {
        return ReflectionUtils.invoke(ReflectionUtils.getMethod(recyclerView.getClass(), "getLayoutManager", new Class[0]), recyclerView, new Object[0]);
    }

    @Nullable
    private static Object createAdapter(@NonNull LayoutlibCallback layoutlibCallback, @NonNull String adapterClassName) throws ReflectionUtils.ReflectionException {
        try {
            return layoutlibCallback.loadClass(adapterClassName, new Class[0], new Object[0]);
        }
        catch (Exception e) {
            throw new ReflectionUtils.ReflectionException(e);
        }
    }

    private static void setProperty(@NonNull Object object, @NonNull String propertyClassName, @NonNull Object propertyValue, @NonNull String propertySetter) throws ReflectionUtils.ReflectionException {
        Class<?> propertyClass = ReflectionUtils.getClassInstance(propertyValue, propertyClassName);
        RecyclerViewUtil.setProperty(object, propertyClass, propertyValue, propertySetter);
    }

    private static void setProperty(@NonNull Object object, @NonNull Class<?> propertyClass, @Nullable Object propertyValue, @NonNull String propertySetter) throws ReflectionUtils.ReflectionException {
        ReflectionUtils.invoke(ReflectionUtils.getMethod(object.getClass(), propertySetter, propertyClass), object, propertyValue);
    }
}

