/*
 * Decompiled with CFR 0.152.
 */
package com.android.launcher3.icons;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.BlendMode;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.drawable.AdaptiveIconDrawable;
import android.graphics.drawable.Drawable;
import com.android.launcher3.icons.mono.MonoIconThemeController;
import com.android.layoutlib.androidx.annotation.WorkerThread;
import java.nio.ByteBuffer;

@TargetApi(value=33)
public class MonochromeIconFactory
extends Drawable {
    private final Bitmap mFlatBitmap;
    private final Canvas mFlatCanvas;
    private final Paint mCopyPaint;
    private final Bitmap mAlphaBitmap;
    private final Canvas mAlphaCanvas;
    private final byte[] mPixels;
    private final int mBitmapSize;
    private final int mEdgePixelLength;
    private final Paint mDrawPaint;
    private final Rect mSrcRect;

    public MonochromeIconFactory(int iconBitmapSize) {
        float extraFactor = AdaptiveIconDrawable.getExtraInsetFraction();
        float viewPortScale = 1.0f / (1.0f + 2.0f * extraFactor);
        this.mBitmapSize = Math.round((float)(iconBitmapSize * 2) * viewPortScale);
        this.mPixels = new byte[this.mBitmapSize * this.mBitmapSize];
        this.mEdgePixelLength = this.mBitmapSize * (this.mBitmapSize - iconBitmapSize) / 2;
        this.mFlatBitmap = Bitmap.createBitmap(this.mBitmapSize, this.mBitmapSize, Bitmap.Config.ARGB_8888);
        this.mFlatCanvas = new Canvas(this.mFlatBitmap);
        this.mAlphaBitmap = Bitmap.createBitmap(this.mBitmapSize, this.mBitmapSize, Bitmap.Config.ALPHA_8);
        this.mAlphaCanvas = new Canvas(this.mAlphaBitmap);
        this.mDrawPaint = new Paint(2);
        this.mDrawPaint.setColor(-1);
        this.mSrcRect = new Rect(0, 0, this.mBitmapSize, this.mBitmapSize);
        this.mCopyPaint = new Paint(2);
        this.mCopyPaint.setBlendMode(BlendMode.SRC);
        ColorMatrix satMatrix = new ColorMatrix();
        float[] vals = satMatrix.getArray();
        vals[17] = 0.3333f;
        vals[16] = 0.3333f;
        vals[15] = 0.3333f;
        vals[19] = 0.0f;
        vals[18] = 0.0f;
        this.mCopyPaint.setColorFilter(new ColorMatrixColorFilter(vals));
    }

    private void drawDrawable(Drawable drawable2) {
        if (drawable2 != null) {
            drawable2.setBounds(0, 0, this.mBitmapSize, this.mBitmapSize);
            drawable2.draw(this.mFlatCanvas);
        }
    }

    @WorkerThread
    public Drawable wrap(AdaptiveIconDrawable icon, Path shapePath) {
        this.mFlatCanvas.drawColor(-16777216);
        this.drawDrawable(icon.getBackground());
        this.drawDrawable(icon.getForeground());
        this.generateMono();
        return new MonoIconThemeController.ClippedMonoDrawable((Drawable)this, shapePath);
    }

    @WorkerThread
    private void generateMono() {
        this.mAlphaCanvas.drawBitmap(this.mFlatBitmap, 0.0f, 0.0f, this.mCopyPaint);
        ByteBuffer buffer = ByteBuffer.wrap(this.mPixels);
        buffer.rewind();
        this.mAlphaBitmap.copyPixelsToBuffer(buffer);
        int min = 255;
        int max = 0;
        for (byte b : this.mPixels) {
            min = Math.min(min, b & 0xFF);
            max = Math.max(max, b & 0xFF);
        }
        if (min < max) {
            int p2;
            int p;
            int i;
            float range = max - min;
            int sum = 0;
            for (int i2 = 0; i2 < this.mEdgePixelLength; ++i2) {
                sum += this.mPixels[i2] & 0xFF;
                sum += this.mPixels[this.mPixels.length - 1 - i2] & 0xFF;
            }
            float edgeAverage = (float)sum / ((float)this.mEdgePixelLength * 2.0f);
            float edgeMapped = (edgeAverage - (float)min) / range;
            boolean flipColor = edgeMapped > 0.5f;
            for (i = 0; i < this.mPixels.length; ++i) {
                p = this.mPixels[i] & 0xFF;
                p2 = Math.round((float)((p - min) * 255) / range);
                this.mPixels[i] = flipColor ? (byte)(255 - p2) : (byte)p2;
            }
            for (i = 0; i < this.mPixels.length; ++i) {
                double coefficient;
                p = this.mPixels[i] & 0xFF;
                if (p > 128) {
                    coefficient = 1.0 - (double)(p - 128) / 128.0;
                    p2 = 255 - (int)(coefficient * (double)(255 - p));
                } else {
                    coefficient = 1.0 - (double)(128 - p) / 128.0;
                    p2 = (int)(coefficient * (double)p);
                }
                if (p2 > 255) {
                    p2 = 255;
                } else if (p2 < 0) {
                    p2 = 0;
                }
                this.mPixels[i] = (byte)p2;
            }
            buffer.rewind();
            this.mAlphaBitmap.copyPixelsFromBuffer(buffer);
        }
    }

    @Override
    public void draw(Canvas canvas) {
        canvas.drawBitmap(this.mAlphaBitmap, this.mSrcRect, this.getBounds(), this.mDrawPaint);
    }

    @Override
    public int getOpacity() {
        return -3;
    }

    @Override
    public void setAlpha(int i) {
        this.mDrawPaint.setAlpha(i);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        this.mDrawPaint.setColorFilter(colorFilter);
    }
}

