/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.semantics;

import android.annotation.Nullable;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.operations.layout.Component;
import com.android.internal.widget.remotecompose.core.semantics.AccessibilitySemantics;

public interface ScrollableComponent
extends AccessibilitySemantics {
    public static final int SCROLL_NONE = 0;
    public static final int SCROLL_HORIZONTAL = 1;
    public static final int SCROLL_VERTICAL = 2;

    default public boolean supportsScrollByOffset() {
        return true;
    }

    default public int scrollByOffset(RemoteContext context, int offset) {
        return offset;
    }

    default public boolean scrollDirection(RemoteContext context, ScrollDirection direction) {
        return false;
    }

    default public boolean showOnScreen(RemoteContext context, Component child) {
        return false;
    }

    public int scrollDirection();

    @Nullable
    default public ScrollAxisRange getScrollAxisRange() {
        return null;
    }

    public static enum ScrollDirection {
        FORWARD,
        BACKWARD,
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }

    public static class ScrollAxisRange {
        private float mValue;
        private float mMaxValue;
        private boolean mCanScrollForward;
        private boolean mCanScrollBackwards;

        public ScrollAxisRange(float value, float maxValue, boolean canScrollForward, boolean canScrollBackwards) {
            this.mValue = value;
            this.mMaxValue = maxValue;
            this.mCanScrollForward = canScrollForward;
            this.mCanScrollBackwards = canScrollBackwards;
        }

        public float getmValue() {
            return this.mValue;
        }

        public float getMaxValue() {
            return this.mMaxValue;
        }

        public boolean canScrollForward() {
            return this.mCanScrollForward;
        }

        public boolean canScrollBackwards() {
            return this.mCanScrollBackwards;
        }
    }
}

