/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.utilities.easing;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.operations.utilities.easing.Easing;
import com.android.internal.widget.remotecompose.core.operations.utilities.easing.MonotonicCurveFit;

public class StepCurve
extends Easing {
    @NonNull
    private final MonotonicCurveFit mCurveFit;

    public StepCurve(@NonNull float[] params, int offset, int len) {
        this.mCurveFit = StepCurve.genSpline(params, offset, len);
    }

    @NonNull
    private static MonotonicCurveFit genSpline(@NonNull float[] values, int off, int arrayLen) {
        int length = arrayLen * 3 - 2;
        int len = arrayLen - 1;
        double gap = 1.0 / (double)len;
        double[][] points = new double[length][1];
        double[] time = new double[length];
        for (int i = 0; i < arrayLen; ++i) {
            double v;
            points[i + len][0] = v = (double)values[i + off];
            time[i + len] = (double)i * gap;
            if (i <= 0) continue;
            points[i + len * 2][0] = v + 1.0;
            time[i + len * 2] = (double)i * gap + 1.0;
            points[i - 1][0] = v - 1.0 - gap;
            time[i - 1] = (double)i * gap + -1.0 - gap;
        }
        MonotonicCurveFit ms = new MonotonicCurveFit(time, points);
        return ms;
    }

    @Override
    public float getDiff(float x) {
        if (x < 0.0f) {
            return 0.0f;
        }
        if (x > 1.0f) {
            return 0.0f;
        }
        return (float)this.mCurveFit.getSlope((double)x, 0);
    }

    @Override
    public float get(float x) {
        if (x < 0.0f) {
            return 0.0f;
        }
        if (x > 1.0f) {
            return 1.0f;
        }
        return (float)this.mCurveFit.getPos((double)x, 0);
    }
}

