/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.utilities;

import android.annotation.NonNull;
import android.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;

public class IntMap<T> {
    private static final int DEFAULT_CAPACITY = 16;
    private static final float LOAD_FACTOR = 0.75f;
    private static final int NOT_PRESENT = Integer.MIN_VALUE;
    private int[] mKeys = new int[16];
    private ArrayList<T> mValues;
    int mSize;

    public IntMap() {
        Arrays.fill(this.mKeys, Integer.MIN_VALUE);
        this.mValues = new ArrayList(16);
        for (int i = 0; i < 16; ++i) {
            this.mValues.add(null);
        }
    }

    public void clear() {
        Arrays.fill(this.mKeys, Integer.MIN_VALUE);
        this.mValues.clear();
        this.mSize = 0;
    }

    @Nullable
    public T put(int key, @NonNull T value) {
        if (key == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Key cannot be NOT_PRESENT");
        }
        if ((float)this.mSize > (float)this.mKeys.length * 0.75f) {
            this.resize();
        }
        return this.insert(key, value);
    }

    @Nullable
    public T get(int key) {
        int index = this.findKey(key);
        if (index == -1) {
            return null;
        }
        return this.mValues.get(index);
    }

    public int size() {
        return this.mSize;
    }

    @Nullable
    private T insert(int key, @NonNull T value) {
        int index = this.hash(key) % this.mKeys.length;
        while (this.mKeys[index] != Integer.MIN_VALUE && this.mKeys[index] != key) {
            index = (index + 1) % this.mKeys.length;
        }
        T oldValue = null;
        if (this.mKeys[index] == Integer.MIN_VALUE) {
            ++this.mSize;
        } else {
            oldValue = this.mValues.get(index);
        }
        this.mKeys[index] = key;
        this.mValues.set(index, value);
        return oldValue;
    }

    private int findKey(int key) {
        int index = this.hash(key) % this.mKeys.length;
        while (this.mKeys[index] != Integer.MIN_VALUE) {
            if (this.mKeys[index] == key) {
                return index;
            }
            index = (index + 1) % this.mKeys.length;
        }
        return -1;
    }

    private int hash(int key) {
        return key;
    }

    private void resize() {
        int i;
        int[] oldKeys = this.mKeys;
        ArrayList<T> oldValues = this.mValues;
        this.mKeys = new int[oldKeys.length * 2];
        for (i = 0; i < this.mKeys.length; ++i) {
            this.mKeys[i] = Integer.MIN_VALUE;
        }
        this.mValues = new ArrayList(oldKeys.length * 2);
        for (i = 0; i < oldKeys.length * 2; ++i) {
            this.mValues.add(null);
        }
        this.mSize = 0;
        for (i = 0; i < oldKeys.length; ++i) {
            if (oldKeys[i] == Integer.MIN_VALUE) continue;
            this.put(oldKeys[i], oldValues.get(i));
        }
    }

    @Nullable
    public T remove(int key) {
        int index;
        int initialIndex = index = this.hash(key) % this.mKeys.length;
        while (this.mKeys[index] != Integer.MIN_VALUE) {
            if (this.mKeys[index] == key) {
                T oldValue = this.mValues.get(index);
                this.mKeys[index] = Integer.MIN_VALUE;
                this.mValues.set(index, null);
                --this.mSize;
                this.rehashFrom((index + 1) % this.mKeys.length);
                return oldValue;
            }
            if ((index = (index + 1) % this.mKeys.length) != initialIndex) continue;
            break;
        }
        return null;
    }

    private void rehashFrom(int startIndex) {
        int index = startIndex;
        while (this.mKeys[index] != Integer.MIN_VALUE) {
            int keyToRehash = this.mKeys[index];
            T valueToRehash = this.mValues.get(index);
            this.mKeys[index] = Integer.MIN_VALUE;
            this.mValues.set(index, null);
            --this.mSize;
            this.insert(keyToRehash, valueToRehash);
            index = (index + 1) % this.mKeys.length;
        }
    }
}

