/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.utilities;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.operations.Utils;

public class ImageScaling {
    private static final boolean DEBUG = false;
    public static final int SCALE_NONE = 0;
    public static final int SCALE_INSIDE = 1;
    public static final int SCALE_FILL_WIDTH = 2;
    public static final int SCALE_FILL_HEIGHT = 3;
    public static final int SCALE_FIT = 4;
    public static final int SCALE_CROP = 5;
    public static final int SCALE_FILL_BOUNDS = 6;
    public static final int SCALE_FIXED_SCALE = 7;
    private float mSrcLeft;
    private float mSrcTop;
    private float mSrcRight;
    private float mSrcBottom;
    private float mDstLeft;
    private float mDstTop;
    private float mDstRight;
    private float mDstBottom;
    private float mScaleFactor;
    private int mScaleType;
    public float mFinalDstLeft;
    public float mFinalDstTop;
    public float mFinalDstRight;
    public float mFinalDstBottom;

    public ImageScaling() {
    }

    public ImageScaling(float srcLeft, float srcTop, float srcRight, float srcBottom, float dstLeft, float dstTop, float dstRight, float dstBottom, int type, float scale) {
        this.mSrcLeft = srcLeft;
        this.mSrcTop = srcTop;
        this.mSrcRight = srcRight;
        this.mSrcBottom = srcBottom;
        this.mDstLeft = dstLeft;
        this.mDstTop = dstTop;
        this.mDstRight = dstRight;
        this.mDstBottom = dstBottom;
        this.mScaleType = type;
        this.mScaleFactor = scale;
        this.adjustDrawToType();
    }

    public void setup(float srcLeft, float srcTop, float srcRight, float srcBottom, float dstLeft, float dstTop, float dstRight, float dstBottom, int type, float scale) {
        this.mSrcLeft = srcLeft;
        this.mSrcTop = srcTop;
        this.mSrcRight = srcRight;
        this.mSrcBottom = srcBottom;
        this.mDstLeft = dstLeft;
        this.mDstTop = dstTop;
        this.mDstRight = dstRight;
        this.mDstBottom = dstBottom;
        this.mScaleType = type;
        this.mScaleFactor = scale;
        this.adjustDrawToType();
    }

    @NonNull
    static String str(float v) {
        String s = "  " + (int)v;
        return s.substring(s.length() - 3);
    }

    void print(String str, float left, float top, float right, float bottom) {
        String s = str;
        s = s + ImageScaling.str(left) + ", " + ImageScaling.str(top) + ", " + ImageScaling.str(right) + ", " + ImageScaling.str(bottom) + ", ";
        s = s + " [" + ImageScaling.str(right - left) + " x " + ImageScaling.str(bottom - top) + "]";
        Utils.log(s);
    }

    private void adjustDrawToType() {
        int sw = (int)(this.mSrcRight - this.mSrcLeft);
        int sh = (int)(this.mSrcBottom - this.mSrcTop);
        float width = this.mDstRight - this.mDstLeft;
        float height = this.mDstBottom - this.mDstTop;
        int dw = (int)width;
        int dh = (int)height;
        int dLeft = 0;
        int dRight = dw;
        int dTop = 0;
        int dBottom = dh;
        if (sh == 0 || sw == 0) {
            return;
        }
        switch (this.mScaleType) {
            case 0: {
                dh = sh;
                dw = sw;
                dTop = ((int)height - dh) / 2;
                dBottom = dh + dTop;
                dLeft = ((int)width - dw) / 2;
                dRight = dw + dLeft;
                break;
            }
            case 1: {
                if (dh > sh && dw > sw) {
                    dh = sh;
                    dw = sw;
                } else if ((float)sw * height > width * (float)sh) {
                    dh = dw * sh / sw;
                } else {
                    dw = dh * sw / sh;
                }
                dTop = ((int)height - dh) / 2;
                dBottom = dh + dTop;
                dLeft = ((int)width - dw) / 2;
                dRight = dw + dLeft;
                break;
            }
            case 2: {
                dh = dw * sh / sw;
                dTop = ((int)height - dh) / 2;
                dBottom = dh + dTop;
                dLeft = ((int)width - dw) / 2;
                dRight = dw + dLeft;
                break;
            }
            case 3: {
                dw = dh * sw / sh;
                dTop = ((int)height - dh) / 2;
                dBottom = dh + dTop;
                dLeft = ((int)width - dw) / 2;
                dRight = dw + dLeft;
                break;
            }
            case 4: {
                if ((float)sw * height > width * (float)sh) {
                    dh = dw * sh / sw;
                    dTop = ((int)height - dh) / 2;
                    dBottom = dh + dTop;
                    break;
                }
                dw = dh * sw / sh;
                dLeft = ((int)width - dw) / 2;
                dRight = dw + dLeft;
                break;
            }
            case 5: {
                if ((float)sw * height < width * (float)sh) {
                    dh = dw * sh / sw;
                    dTop = ((int)height - dh) / 2;
                    dBottom = dh + dTop;
                    break;
                }
                dw = dh * sw / sh;
                dLeft = ((int)width - dw) / 2;
                dRight = dw + dLeft;
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                dh = (int)((float)sh * this.mScaleFactor);
                dw = (int)((float)sw * this.mScaleFactor);
                dTop = ((int)height - dh) / 2;
                dBottom = dh + dTop;
                dLeft = ((int)width - dw) / 2;
                dRight = dw + dLeft;
            }
        }
        this.mFinalDstRight = (float)dRight + this.mDstLeft;
        this.mFinalDstLeft = (float)dLeft + this.mDstLeft;
        this.mFinalDstBottom = (float)dBottom + this.mDstTop;
        this.mFinalDstTop = (float)dTop + this.mDstTop;
    }

    @NonNull
    public static String typeToString(int type) {
        String[] typeString = new String[]{"none", "inside", "fill_width", "fill_height", "fit", "crop", "fill_bounds", "fixed_scale"};
        return typeString[type];
    }
}

