/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.layout.modifiers;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.operations.layout.Component;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.DecoratorModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.utilities.StringSerializer;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.SerializeTags;
import java.util.List;

public class ZIndexModifierOperation
extends DecoratorModifierOperation {
    private static final int OP_CODE = 223;
    public static final String CLASS_NAME = "ZIndexModifierOperation";
    float mValue;
    float mCurrentValue;

    public ZIndexModifierOperation(float value) {
        this.mValue = value;
    }

    public float getValue() {
        return this.mCurrentValue;
    }

    public void setValue(float value) {
        this.mValue = value;
    }

    @Override
    public void write(WireBuffer buffer) {
        ZIndexModifierOperation.apply(buffer, this.mValue);
    }

    @Override
    public void serializeToString(int indent, StringSerializer serializer) {
        serializer.append(indent, "ZINDEX = [" + this.mValue + "]");
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return (indent != null ? indent : "") + this.toString();
    }

    @Override
    public void paint(PaintContext context) {
        this.mCurrentValue = this.mValue;
        if (Utils.isVariable(this.mValue)) {
            this.mCurrentValue = context.getContext().mRemoteComposeState.getFloat(Utils.idFromNan(this.mValue));
        }
    }

    public String toString() {
        return "ZIndexModifierOperation(" + this.mValue + ")";
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 223;
    }

    public static void apply(WireBuffer buffer, float value) {
        buffer.start(223);
        buffer.writeFloat(value);
    }

    public static void read(WireBuffer buffer, List<Operation> operations) {
        float value = buffer.readFloat();
        operations.add(new ZIndexModifierOperation(value));
    }

    public static void documentation(DocumentationBuilder doc) {
        doc.operation("Modifier Operations", 223, CLASS_NAME).description("define the Z-Index Modifier").field(1, "value", "");
    }

    @Override
    public void layout(RemoteContext context, Component component, float width, float height) {
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addTags(SerializeTags.MODIFIER).addType(CLASS_NAME).add("value", Float.valueOf(this.mValue));
    }
}

