/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.layout.modifiers;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.ModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.utilities.StringSerializer;

public abstract class DimensionModifierOperation
extends Operation
implements ModifierOperation,
VariableSupport {
    @NonNull
    Type mType = Type.EXACT;
    float mValue = Float.NaN;
    float mOutValue = Float.NaN;

    public DimensionModifierOperation(@NonNull Type type, float value) {
        this.mType = type;
        this.mOutValue = this.mValue = value;
    }

    public DimensionModifierOperation(@NonNull Type type) {
        this(type, Float.NaN);
    }

    public DimensionModifierOperation(float value) {
        this(Type.EXACT, value);
    }

    @Override
    public void updateVariables(@NonNull RemoteContext context) {
        if (this.mType == Type.EXACT) {
            float f = this.mOutValue = Float.isNaN(this.mValue) ? context.getFloat(Utils.idFromNan(this.mValue)) : this.mValue;
        }
        if (this.mType == Type.EXACT_DP) {
            float pre = this.mOutValue;
            this.mOutValue = Float.isNaN(this.mValue) ? context.getFloat(Utils.idFromNan(this.mValue)) : this.mValue;
            this.mOutValue *= context.getDensity();
            if (pre != this.mOutValue) {
                context.getDocument().getRootLayoutComponent().invalidateMeasure();
            }
        }
    }

    @Override
    public void registerListening(@NonNull RemoteContext context) {
        if (this.mType == Type.EXACT && Float.isNaN(this.mValue)) {
            context.listensTo(Utils.idFromNan(this.mValue), this);
        }
        if (this.mType == Type.EXACT_DP && Float.isNaN(this.mValue)) {
            context.listensTo(Utils.idFromNan(this.mValue), this);
        }
    }

    public boolean hasWeight() {
        return this.mType == Type.WEIGHT;
    }

    public boolean isWrap() {
        return this.mType == Type.WRAP;
    }

    public boolean isFill() {
        return this.mType == Type.FILL;
    }

    public boolean isIntrinsicMin() {
        return this.mType == Type.INTRINSIC_MIN;
    }

    public boolean isIntrinsicMax() {
        return this.mType == Type.INTRINSIC_MAX;
    }

    @NonNull
    public Type getType() {
        return this.mType;
    }

    public float getValue() {
        return this.mOutValue;
    }

    public void setValue(float value) {
        this.mOutValue = this.mValue = value;
    }

    @NonNull
    public String serializedName() {
        return "DIMENSION";
    }

    @Override
    public void serializeToString(int indent, @NonNull StringSerializer serializer) {
        if (this.mType == Type.EXACT) {
            serializer.append(indent, this.serializedName() + " = " + this.mValue);
        }
        if (this.mType == Type.EXACT_DP) {
            serializer.append(indent, this.serializedName() + " = " + this.mValue + " dp");
        }
    }

    @Override
    public void apply(@NonNull RemoteContext context) {
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return (indent != null ? indent : "") + this.toString();
    }

    @NonNull
    public String toString() {
        return "DimensionModifierOperation(" + this.mValue + ")";
    }

    public static enum Type {
        EXACT,
        FILL,
        WRAP,
        WEIGHT,
        INTRINSIC_MIN,
        INTRINSIC_MAX,
        EXACT_DP;


        @NonNull
        static Type fromInt(int value) {
            switch (value) {
                case 0: {
                    return EXACT;
                }
                case 1: {
                    return FILL;
                }
                case 2: {
                    return WRAP;
                }
                case 3: {
                    return WEIGHT;
                }
                case 4: {
                    return INTRINSIC_MIN;
                }
                case 5: {
                    return INTRINSIC_MAX;
                }
                case 6: {
                    return EXACT_DP;
                }
            }
            return EXACT;
        }
    }
}

