/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.layout.modifiers;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.ModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.utilities.StringSerializer;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;
import com.android.internal.widget.remotecompose.core.serialize.SerializeTags;
import java.util.List;

public class CollapsiblePriorityModifierOperation
extends Operation
implements ModifierOperation,
Serializable {
    private static final int OP_CODE = 235;
    public static final String CLASS_NAME = "CollapsiblePriorityModifierOperation";
    private float mPriority;
    private int mOrientation;

    public CollapsiblePriorityModifierOperation(int orientation, float priority) {
        this.mOrientation = orientation;
        this.mPriority = priority;
    }

    public float getPriority() {
        return this.mPriority;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        CollapsiblePriorityModifierOperation.apply(buffer, this.mOrientation, this.mPriority);
    }

    @Override
    public void apply(@NonNull RemoteContext context) {
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return "";
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int orientation = buffer.readInt();
        float priority = buffer.readFloat();
        operations.add(new CollapsiblePriorityModifierOperation(orientation, priority));
    }

    public static int id() {
        return 235;
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Layout Operations", 235, "CollapsiblePriorityModifier").description("Add additional priority to children of Collapsible layouts").field(0, "orientation", "Horizontal(0) or Vertical (1)").field(1, "priority", "The associated priority");
    }

    public static void apply(@NonNull WireBuffer buffer, int orientation, float priority) {
        buffer.start(235);
        buffer.writeInt(orientation);
        buffer.writeFloat(priority);
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addTags(SerializeTags.MODIFIER).addType(CollapsiblePriorityModifierOperation.name()).add("orientation", this.mOrientation).add("priority", Float.valueOf(this.mPriority));
    }

    @Override
    public void serializeToString(int indent, @NonNull StringSerializer serializer) {
        serializer.append(indent, "PRIORITY = [" + this.getPriority() + "] (" + this.mOrientation + ")");
    }
}

