/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.layout.managers;

import com.android.internal.widget.remotecompose.core.operations.layout.Component;
import com.android.internal.widget.remotecompose.core.operations.layout.LayoutComponent;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.CollapsiblePriorityModifierOperation;
import java.util.ArrayList;

public class CollapsiblePriority {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;

    static float getPriority(Component c, int orientation) {
        LayoutComponent lc;
        CollapsiblePriorityModifierOperation priority;
        if (c instanceof LayoutComponent && (priority = (lc = (LayoutComponent)c).selfOrModifier(CollapsiblePriorityModifierOperation.class)) != null && priority.getOrientation() == orientation) {
            return priority.getPriority();
        }
        return Float.MAX_VALUE;
    }

    static ArrayList<Component> sortWithPriorities(ArrayList<Component> components, int orientation) {
        ArrayList<Component> sorted = new ArrayList<Component>(components);
        sorted.sort((t1, t2) -> {
            float p1 = CollapsiblePriority.getPriority(t1, orientation);
            float p2 = CollapsiblePriority.getPriority(t2, orientation);
            return (int)(p2 - p1);
        });
        return sorted;
    }
}

