/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.layout.managers;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.operations.layout.Component;
import com.android.internal.widget.remotecompose.core.operations.layout.LayoutComponent;
import com.android.internal.widget.remotecompose.core.operations.layout.managers.CollapsiblePriority;
import com.android.internal.widget.remotecompose.core.operations.layout.managers.ColumnLayout;
import com.android.internal.widget.remotecompose.core.operations.layout.measure.ComponentMeasure;
import com.android.internal.widget.remotecompose.core.operations.layout.measure.MeasurePass;
import com.android.internal.widget.remotecompose.core.operations.layout.measure.Size;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.CollapsiblePriorityModifierOperation;
import java.util.ArrayList;
import java.util.List;

public class CollapsibleColumnLayout
extends ColumnLayout {
    public CollapsibleColumnLayout(@Nullable Component parent, int componentId, int animationId, float x, float y, float width, float height, int horizontalPositioning, int verticalPositioning, float spacedBy) {
        super(parent, componentId, animationId, x, y, width, height, horizontalPositioning, verticalPositioning, spacedBy);
    }

    public CollapsibleColumnLayout(@Nullable Component parent, int componentId, int animationId, int horizontalPositioning, int verticalPositioning, float spacedBy) {
        super(parent, componentId, animationId, horizontalPositioning, verticalPositioning, spacedBy);
    }

    @Override
    @NonNull
    protected String getSerializedName() {
        return "COLLAPSIBLE_COLUMN";
    }

    public static int id() {
        return 233;
    }

    public static void apply(@NonNull WireBuffer buffer, int componentId, int animationId, int horizontalPositioning, int verticalPositioning, float spacedBy) {
        buffer.start(CollapsibleColumnLayout.id());
        buffer.writeInt(componentId);
        buffer.writeInt(animationId);
        buffer.writeInt(horizontalPositioning);
        buffer.writeInt(verticalPositioning);
        buffer.writeFloat(spacedBy);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int componentId = buffer.readInt();
        int animationId = buffer.readInt();
        int horizontalPositioning = buffer.readInt();
        int verticalPositioning = buffer.readInt();
        float spacedBy = buffer.readFloat();
        operations.add(new CollapsibleColumnLayout(null, componentId, animationId, horizontalPositioning, verticalPositioning, spacedBy));
    }

    @Override
    public float minIntrinsicHeight(@NonNull RemoteContext context) {
        float height = this.computeModifierDefinedHeight(context);
        if (!this.mChildrenComponents.isEmpty()) {
            height += ((Component)this.mChildrenComponents.get(0)).minIntrinsicHeight(context);
        }
        return height;
    }

    @Override
    public float minIntrinsicWidth(@NonNull RemoteContext context) {
        float width = this.computeModifierDefinedWidth(context);
        if (!this.mChildrenComponents.isEmpty()) {
            width += ((Component)this.mChildrenComponents.get(0)).minIntrinsicWidth(context);
        }
        return width;
    }

    @Override
    public boolean hasVerticalIntrinsicDimension() {
        return true;
    }

    @Override
    public void computeWrapSize(@NonNull PaintContext context, float maxWidth, float maxHeight, boolean horizontalWrap, boolean verticalWrap, @NonNull MeasurePass measure, @NonNull Size size) {
        this.computeVisibleChildren(context, maxWidth, maxHeight, horizontalWrap, verticalWrap, measure, size);
    }

    @Override
    public void computeSize(@NonNull PaintContext context, float minWidth, float maxWidth, float minHeight, float maxHeight, @NonNull MeasurePass measure) {
        this.computeVisibleChildren(context, maxWidth, maxHeight, false, false, measure, null);
    }

    @Override
    public void internalLayoutMeasure(@NonNull PaintContext context, @NonNull MeasurePass measure) {
        super.internalLayoutMeasure(context, measure);
        ComponentMeasure m = measure.get(this);
        this.computeVisibleChildren(context, m.getW(), m.getH(), false, false, measure, null);
    }

    private void computeVisibleChildren(@NonNull PaintContext context, float maxWidth, float maxHeight, boolean horizontalWrap, boolean verticalWrap, @NonNull MeasurePass measure, @Nullable Size size) {
        int visibleChildren = 0;
        ComponentMeasure self = measure.get(this);
        self.addVisibilityOverride(32);
        float currentMaxHeight = maxHeight;
        boolean hasPriorities = false;
        for (Component c : this.mChildrenComponents) {
            LayoutComponent lc;
            CollapsiblePriorityModifierOperation priority;
            ComponentMeasure m;
            if (!measure.contains(c.getComponentId())) {
                if (c instanceof CollapsibleColumnLayout) {
                    c.measure(context, 0.0f, maxWidth, 0.0f, currentMaxHeight, measure);
                } else {
                    c.measure(context, 0.0f, maxWidth, 0.0f, Float.MAX_VALUE, measure);
                }
            }
            if (!(m = measure.get(c)).isGone()) {
                if (size != null) {
                    size.setWidth(Math.max(size.getWidth(), m.getW()));
                    size.setHeight(size.getHeight() + m.getH());
                }
                ++visibleChildren;
                currentMaxHeight -= m.getH();
            }
            if (!(c instanceof LayoutComponent) || (priority = (lc = (LayoutComponent)c).selfOrModifier(CollapsiblePriorityModifierOperation.class)) == null) continue;
            hasPriorities = true;
        }
        if (!this.mChildrenComponents.isEmpty() && size != null) {
            size.setHeight(size.getHeight() + this.mSpacedBy * (float)(visibleChildren - 1));
        }
        float childrenWidth = 0.0f;
        float childrenHeight = 0.0f;
        boolean overflow = false;
        ArrayList<Component> children = this.mChildrenComponents;
        if (hasPriorities) {
            children = CollapsiblePriority.sortWithPriorities(this.mChildrenComponents, 1);
        }
        for (Component child : children) {
            boolean childDoesNotFits;
            ComponentMeasure childMeasure = measure.get(child);
            if (overflow || childMeasure.isGone()) {
                childMeasure.addVisibilityOverride(16);
                continue;
            }
            float childHeight = childMeasure.getH();
            boolean bl = childDoesNotFits = childrenHeight + childHeight > maxHeight;
            if (childDoesNotFits) {
                childMeasure.addVisibilityOverride(16);
                overflow = true;
                continue;
            }
            childrenHeight += childHeight;
            childrenWidth = Math.max(childrenWidth, childMeasure.getW());
            ++visibleChildren;
        }
        if (verticalWrap && size != null) {
            size.setHeight(Math.min(maxHeight, childrenHeight));
        }
        if (visibleChildren == 0 || size != null && size.getHeight() <= 0.0f) {
            self.addVisibilityOverride(16);
        }
    }
}

