/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.layout;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.lang.System_Delegate;
import com.android.internal.widget.remotecompose.core.CoreDocument;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.PaintOperation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.TextData;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.operations.layout.ActionOperation;
import com.android.internal.widget.remotecompose.core.operations.layout.ClickHandler;
import com.android.internal.widget.remotecompose.core.operations.layout.Component;
import com.android.internal.widget.remotecompose.core.operations.layout.Container;
import com.android.internal.widget.remotecompose.core.operations.layout.DecoratorComponent;
import com.android.internal.widget.remotecompose.core.operations.layout.RootLayoutComponent;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.ModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.paint.PaintBundle;
import com.android.internal.widget.remotecompose.core.operations.utilities.ColorUtils;
import com.android.internal.widget.remotecompose.core.operations.utilities.StringSerializer;
import com.android.internal.widget.remotecompose.core.operations.utilities.easing.FloatAnimation;
import com.android.internal.widget.remotecompose.core.semantics.AccessibleComponent;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.SerializeTags;
import java.util.ArrayList;
import java.util.List;

public class ClickModifierOperation
extends PaintOperation
implements Container,
ModifierOperation,
DecoratorComponent,
ClickHandler,
AccessibleComponent {
    private static final int OP_CODE = 59;
    long mAnimateRippleStart = 0L;
    float mAnimateRippleX = 0.0f;
    float mAnimateRippleY = 0.0f;
    int mAnimateRippleDuration = 1000;
    float mWidth = 0.0f;
    float mHeight = 0.0f;
    @NonNull
    public float[] locationInWindow = new float[2];
    @NonNull
    PaintBundle mPaint = new PaintBundle();
    @NonNull
    public ArrayList<Operation> mList = new ArrayList();

    @Override
    public boolean isClickable() {
        return true;
    }

    @Override
    @Nullable
    public AccessibleComponent.Role getRole() {
        return AccessibleComponent.Role.BUTTON;
    }

    @Override
    public AccessibleComponent.Mode getMode() {
        return AccessibleComponent.Mode.MERGE;
    }

    public void animateRipple(float x, float y) {
        this.mAnimateRippleStart = System_Delegate.currentTimeMillis();
        this.mAnimateRippleX = x;
        this.mAnimateRippleY = y;
    }

    @Override
    @NonNull
    public ArrayList<Operation> getList() {
        return this.mList;
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        ClickModifierOperation.apply(buffer);
    }

    @NonNull
    public String toString() {
        return "ClickModifier";
    }

    @Override
    public void apply(@NonNull RemoteContext context) {
        RootLayoutComponent root = context.getDocument().getRootLayoutComponent();
        if (root != null) {
            root.setHasTouchListeners(true);
        }
        for (Operation op : this.mList) {
            if (!(op instanceof TextData)) continue;
            op.apply(context);
            context.incrementOpCount();
        }
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return (indent != null ? indent : "") + this.toString();
    }

    @Override
    public void paint(@NonNull PaintContext context) {
        if (this.mAnimateRippleStart == 0L) {
            return;
        }
        context.needsRepaint();
        float progress = System_Delegate.currentTimeMillis() - this.mAnimateRippleStart;
        progress /= (float)this.mAnimateRippleDuration;
        if (progress > 1.0f) {
            this.mAnimateRippleStart = 0L;
        }
        progress = Math.min(1.0f, progress);
        context.save();
        context.savePaint();
        this.mPaint.reset();
        FloatAnimation anim1 = new FloatAnimation(1, 1.0f, null, Float.NaN, Float.NaN);
        anim1.setInitialValue(0.0f);
        anim1.setTargetValue(1.0f);
        float tween = anim1.get(progress);
        FloatAnimation anim2 = new FloatAnimation(1, 0.5f, null, Float.NaN, Float.NaN);
        anim2.setInitialValue(0.0f);
        anim2.setTargetValue(1.0f);
        float tweenRadius = anim2.get(progress);
        int startColor = ColorUtils.createColor(250, 250, 250, 180);
        int endColor = ColorUtils.createColor(200, 200, 200, 0);
        int paintedColor = Utils.interpolateColor(startColor, endColor, tween);
        float radius = Math.max(this.mWidth, this.mHeight) * tweenRadius;
        this.mPaint.setColor(paintedColor);
        context.applyPaint(this.mPaint);
        context.clipRect(0.0f, 0.0f, this.mWidth, this.mHeight);
        context.drawCircle(this.mAnimateRippleX, this.mAnimateRippleY, radius);
        context.restorePaint();
        context.restore();
    }

    @Override
    public void layout(@NonNull RemoteContext context, Component component, float width, float height) {
        this.mWidth = width;
        this.mHeight = height;
    }

    @Override
    public void serializeToString(int indent, @NonNull StringSerializer serializer) {
        serializer.append(indent, "CLICK_MODIFIER");
        for (Operation o : this.mList) {
            if (!(o instanceof ActionOperation)) continue;
            ((ActionOperation)((Object)o)).serializeToString(indent + 1, serializer);
        }
    }

    @Override
    public void onClick(@NonNull RemoteContext context, @NonNull CoreDocument document, @NonNull Component component, float x, float y) {
        if (!component.isVisible()) {
            return;
        }
        this.locationInWindow[0] = 0.0f;
        this.locationInWindow[1] = 0.0f;
        component.getLocationInWindow(this.locationInWindow);
        this.animateRipple(x - this.locationInWindow[0], y - this.locationInWindow[1]);
        for (Operation o : this.mList) {
            if (!(o instanceof ActionOperation)) continue;
            ((ActionOperation)((Object)o)).runAction(context, document, component, x, y);
        }
        context.hapticEffect(3);
    }

    @NonNull
    public static String name() {
        return "ClickModifier";
    }

    public static void apply(@NonNull WireBuffer buffer) {
        buffer.start(59);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        operations.add(new ClickModifierOperation());
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Layout Operations", 59, ClickModifierOperation.name()).description("Click modifier. This operation contains a list of action executed on click");
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addTags(SerializeTags.MODIFIER).addType("ClickModifierOperation");
    }
}

