/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;

public class Utils {
    public static float asNan(int v) {
        return Float.intBitsToFloat(v | 0xFF800000);
    }

    public static int idFromNan(float value) {
        int b = Float.floatToRawIntBits(value);
        return b & 0x3FFFFF;
    }

    public static long longIdFromNan(float value) {
        return (long)Utils.idFromNan(value) + 0x100000000L;
    }

    public static long idFromLong(long v) {
        return v - 0x100000000L;
    }

    @NonNull
    public static String idStringFromNan(float value) {
        int b = Float.floatToRawIntBits(value) & 0x3FFFFF;
        return Utils.idString(b);
    }

    @NonNull
    public static String idString(int b) {
        return b > 1048575 ? "A_" + (b & 0xFFFFF) : "" + b;
    }

    @NonNull
    public static String trimString(@NonNull String str, int n) {
        if (str.length() > n) {
            str = str.substring(0, n - 3) + "...";
        }
        return str;
    }

    @NonNull
    public static String floatToString(float idvalue, float value) {
        if (Float.isNaN(idvalue)) {
            if (Utils.idFromNan(value) == 0) {
                return "NaN";
            }
            return "[" + Utils.idFromNan(idvalue) + "]" + Utils.floatToString(value);
        }
        return Utils.floatToString(value);
    }

    @NonNull
    public static String floatToString(float value) {
        if (Float.isNaN(value)) {
            if (Utils.idFromNan(value) == 0) {
                return "NaN";
            }
            return "[" + Utils.idFromNan(value) + "]";
        }
        return Float.toString(value);
    }

    public static void log(@NonNull String str) {
        StackTraceElement s = new Throwable().getStackTrace()[1];
        System.out.println("(" + s.getFileName() + ":" + s.getLineNumber() + "). " + s.getMethodName() + "() " + str);
    }

    public static void logStack(@NonNull String str, int n) {
        StackTraceElement[] st = new Throwable().getStackTrace();
        for (int i = 1; i < n + 1; ++i) {
            StackTraceElement s = st[i];
            String space = new String(new char[i]).replace('\u0000', ' ');
            System.out.println(space + "(" + s.getFileName() + ":" + s.getLineNumber() + ")." + str);
        }
    }

    public static boolean isVariable(float v) {
        if (Float.isNaN(v)) {
            int id2 = Utils.idFromNan(v);
            if (id2 == 0) {
                return false;
            }
            return id2 > 40 || id2 < 10;
        }
        return false;
    }

    @NonNull
    public static String colorInt(int color2) {
        String str = "000000000000" + Integer.toHexString(color2);
        return "0x" + str.substring(str.length() - 8);
    }

    public static int interpolateColor(int c1, int c2, float t) {
        if (Float.isNaN(t) || t == 0.0f) {
            return c1;
        }
        if (t == 1.0f) {
            return c2;
        }
        int a = 0xFF & c1 >> 24;
        int r = 0xFF & c1 >> 16;
        int g = 0xFF & c1 >> 8;
        int b = 0xFF & c1;
        float f_r = (float)Math.pow((float)r / 255.0f, 2.2);
        float f_g = (float)Math.pow((float)g / 255.0f, 2.2);
        float f_b = (float)Math.pow((float)b / 255.0f, 2.2);
        float c1fr = f_r;
        float c1fg = f_g;
        float c1fb = f_b;
        float c1fa = (float)a / 255.0f;
        a = 0xFF & c2 >> 24;
        r = 0xFF & c2 >> 16;
        g = 0xFF & c2 >> 8;
        b = 0xFF & c2;
        f_r = (float)Math.pow((float)r / 255.0f, 2.2);
        f_g = (float)Math.pow((float)g / 255.0f, 2.2);
        f_b = (float)Math.pow((float)b / 255.0f, 2.2);
        float c2fr = f_r;
        float c2fg = f_g;
        float c2fb = f_b;
        float c2fa = (float)a / 255.0f;
        f_r = c1fr + t * (c2fr - c1fr);
        f_g = c1fg + t * (c2fg - c1fg);
        f_b = c1fb + t * (c2fb - c1fb);
        float f_a = c1fa + t * (c2fa - c1fa);
        int outr = Utils.clamp((int)((float)Math.pow(f_r, 0.45454545454545453) * 255.0f));
        int outg = Utils.clamp((int)((float)Math.pow(f_g, 0.45454545454545453) * 255.0f));
        int outb = Utils.clamp((int)((float)Math.pow(f_b, 0.45454545454545453) * 255.0f));
        int outa = Utils.clamp((int)(f_a * 255.0f));
        return outa << 24 | outr << 16 | outg << 8 | outb;
    }

    public static int clamp(int c) {
        int n = 255;
        c &= ~(c >> 31);
        c -= n;
        c &= c >> 31;
        return c += n;
    }

    public static int hsvToRgb(float hue, float saturation, float value) {
        int h = (int)(hue * 6.0f);
        float f = hue * 6.0f - (float)h;
        int p = (int)(0.5f + 255.0f * value * (1.0f - saturation));
        int q = (int)(0.5f + 255.0f * value * (1.0f - f * saturation));
        int t = (int)(0.5f + 255.0f * value * (1.0f - (1.0f - f) * saturation));
        int v = (int)(0.5f + 255.0f * value);
        switch (h) {
            case 0: {
                return 0xFF000000 | (v << 16) + (t << 8) + p;
            }
            case 1: {
                return 0xFF000000 | (q << 16) + (v << 8) + p;
            }
            case 2: {
                return 0xFF000000 | (p << 16) + (v << 8) + t;
            }
            case 3: {
                return 0xFF000000 | (p << 16) + (q << 8) + v;
            }
            case 4: {
                return 0xFF000000 | (t << 16) + (p << 8) + v;
            }
            case 5: {
                return 0xFF000000 | (v << 16) + (p << 8) + q;
            }
        }
        return 0;
    }

    public static int toARGB(float alpha, float red, float green, float blue) {
        int a = (int)(alpha * 255.0f + 0.5f);
        int r = (int)(red * 255.0f + 0.5f);
        int g = (int)(green * 255.0f + 0.5f);
        int b = (int)(blue * 255.0f + 0.5f);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static float getHue(int argb) {
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        float rf = (float)r / 255.0f;
        float gf = (float)g / 255.0f;
        float bf = (float)b / 255.0f;
        float max = Math.max(rf, Math.max(gf, bf));
        float min = Math.min(rf, Math.min(gf, bf));
        float deltaMaxMin = max - min;
        float h = max == min ? 0.0f : (max == rf ? (gf - bf) / deltaMaxMin % 6.0f : (max == gf ? (bf - rf) / deltaMaxMin + 2.0f : (rf - gf) / deltaMaxMin + 4.0f));
        if ((h = h * 60.0f % 360.0f) < 0.0f) {
            h += 360.0f;
        }
        return h / 360.0f;
    }

    public static float getSaturation(int argb) {
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        float rf = (float)r / 255.0f;
        float gf = (float)g / 255.0f;
        float bf = (float)b / 255.0f;
        float max = Math.max(rf, Math.max(gf, bf));
        float min = Math.min(rf, Math.min(gf, bf));
        float deltaMaxMin = max - min;
        float l = (max + min) / 2.0f;
        float s = max == min ? 0.0f : deltaMaxMin / (1.0f - Math.abs(2.0f * l - 1.0f));
        return s;
    }

    public static float getBrightness(int argb) {
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        float rf = (float)r / 255.0f;
        float gf = (float)g / 255.0f;
        float bf = (float)b / 255.0f;
        float max = Math.max(rf, Math.max(gf, bf));
        float min = Math.min(rf, Math.min(gf, bf));
        return (max + min) / 2.0f;
    }
}

