/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.RemoteComposeOperation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import java.util.List;

public class Theme
extends Operation
implements RemoteComposeOperation {
    private static final int OP_CODE = 63;
    private static final String CLASS_NAME = "Theme";
    int mTheme;
    public static final int UNSPECIFIED = -1;
    public static final int DARK = -2;
    public static final int LIGHT = -3;

    public Theme(int theme) {
        this.mTheme = theme;
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        Theme.apply(buffer, this.mTheme);
    }

    @NonNull
    public String toString() {
        return "SET_THEME " + this.mTheme;
    }

    @Override
    public void apply(@NonNull RemoteContext context) {
        context.setTheme(this.mTheme);
        this.markDirty();
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return indent + this.toString();
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 63;
    }

    public static void apply(@NonNull WireBuffer buffer, int theme) {
        buffer.start(63);
        buffer.writeInt(theme);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int theme = buffer.readInt();
        operations.add(new Theme(theme));
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Protocol Operations", 63, CLASS_NAME).description("Set a theme").field(0, "THEME", "theme id").possibleValues("UNSPECIFIED", -1).possibleValues("DARK", -2).possibleValues("LIGHT", -3);
    }
}

