/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;
import java.util.List;

public class TextMerge
extends Operation
implements VariableSupport,
Serializable {
    private static final int OP_CODE = 136;
    private static final String CLASS_NAME = "TextMerge";
    public int mTextId;
    public int mSrcId1;
    public int mSrcId2;

    public TextMerge(int textId, int srcId1, int srcId2) {
        this.mTextId = textId;
        this.mSrcId1 = srcId1;
        this.mSrcId2 = srcId2;
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        TextMerge.apply(buffer, this.mTextId, this.mSrcId1, this.mSrcId2);
    }

    @NonNull
    public String toString() {
        return "TextMerge[" + this.mTextId + "] = [" + this.mSrcId1 + " ] + [ " + this.mSrcId2 + "]";
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 136;
    }

    public static void apply(@NonNull WireBuffer buffer, int textId, int srcId1, int srcId2) {
        buffer.start(136);
        buffer.writeInt(textId);
        buffer.writeInt(srcId1);
        buffer.writeInt(srcId2);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int textId = buffer.readInt();
        int srcId1 = buffer.readInt();
        int srcId2 = buffer.readInt();
        operations.add(new TextMerge(textId, srcId1, srcId2));
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Data Operations", 136, CLASS_NAME).description("Merge two string into one").field(0, "textId", "id of the text").field(0, "srcTextId1", "id of the path").field(0, "srcTextId1", "x Shift of the text");
    }

    @Override
    public void apply(@NonNull RemoteContext context) {
        String str1 = context.getText(this.mSrcId1);
        String str2 = context.getText(this.mSrcId2);
        context.loadText(this.mTextId, str1 + str2);
    }

    @Override
    public void updateVariables(@NonNull RemoteContext context) {
        this.apply(context);
    }

    @Override
    public void registerListening(@NonNull RemoteContext context) {
        context.listensTo(this.mSrcId1, this);
        context.listensTo(this.mSrcId2, this);
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return indent + this;
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("id", this.mTextId).add("leftId", this.mSrcId1).add("rightId", this.mSrcId2);
    }
}

