/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.SerializableToString;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.operations.utilities.StringSerializer;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;
import java.util.List;

public class TextData
extends Operation
implements SerializableToString,
Serializable {
    private static final int OP_CODE = 102;
    private static final String CLASS_NAME = "TextData";
    public final int mTextId;
    @NonNull
    public String mText;
    public static final int MAX_STRING_SIZE = 4000;

    public TextData(int textId, @NonNull String text) {
        this.mTextId = textId;
        this.mText = text;
    }

    public void update(TextData from) {
        this.mText = from.mText;
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        TextData.apply(buffer, this.mTextId, this.mText);
    }

    @NonNull
    public String toString() {
        return "TextData[" + this.mTextId + "] = \"" + Utils.trimString(this.mText, 10) + "\"";
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 102;
    }

    public static void apply(@NonNull WireBuffer buffer, int textId, @NonNull String text) {
        buffer.start(102);
        buffer.writeInt(textId);
        buffer.writeUTF8(text);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int textId = buffer.readInt();
        String text = buffer.readUTF8(4000);
        operations.add(new TextData(textId, text));
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Data Operations", 102, CLASS_NAME).description("Encode a string ").field(0, "id", "id string").field(5, "text", "encode text as a string");
    }

    @Override
    public void apply(@NonNull RemoteContext context) {
        context.loadText(this.mTextId, this.mText);
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return indent + this.toString();
    }

    @Override
    public void serializeToString(int indent, @NonNull StringSerializer serializer) {
        serializer.append(indent, this.getSerializedName() + "<" + this.mTextId + "> = \"" + this.mText + "\"");
    }

    @NonNull
    private String getSerializedName() {
        return "DATA_TEXT";
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("textId", this.mTextId).add("text", this.mText);
    }
}

