/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.PaintOperation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.operations.utilities.AnimatedFloatExpression;
import com.android.internal.widget.remotecompose.core.operations.utilities.NanMap;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import java.util.Arrays;
import java.util.List;

public class ParticlesCreate
extends PaintOperation
implements VariableSupport {
    private static final int OP_CODE = 161;
    private static final String CLASS_NAME = "ParticlesCreate";
    private final int mId;
    private final float[][] mEquations;
    private final float[][] mOutEquations;
    private final float[][] mParticles;
    private final int[] mIndexeVars;
    private final int mParticleCount;
    private final int[] mVarId;
    private static final int MAX_FLOAT_ARRAY = 2000;
    private static final int MAX_EQU_LENGTH = 32;
    @NonNull
    AnimatedFloatExpression mExp = new AnimatedFloatExpression();

    public ParticlesCreate(int id2, int[] varId, float[][] values, int particleCount) {
        this.mId = id2;
        this.mVarId = varId;
        this.mEquations = values;
        this.mParticleCount = particleCount;
        this.mOutEquations = new float[values.length][];
        for (int i = 0; i < values.length; ++i) {
            this.mOutEquations[i] = new float[values[i].length];
            System.arraycopy(values[i], 0, this.mOutEquations[i], 0, values[i].length);
        }
        this.mParticles = new float[particleCount][varId.length];
        int[] index = new int[20];
        int indexes = 0;
        int var1Int = Float.floatToRawIntBits(AnimatedFloatExpression.VAR1);
        for (int j = 0; j < this.mEquations.length; ++j) {
            for (int k = 0; k < this.mEquations[j].length; ++k) {
                if (!Float.isNaN(this.mEquations[j][k]) || Float.floatToRawIntBits(this.mEquations[j][k]) != var1Int) continue;
                index[indexes++] = j * this.mEquations.length + k;
            }
        }
        this.mIndexeVars = Arrays.copyOf(index, indexes);
    }

    @Override
    public void updateVariables(@NonNull RemoteContext context) {
        for (int i = 0; i < this.mEquations.length; ++i) {
            for (int j = 0; j < this.mEquations[i].length; ++j) {
                float v = this.mEquations[i][j];
                this.mOutEquations[i][j] = Float.isNaN(v) && !AnimatedFloatExpression.isMathOperator(v) && !NanMap.isDataVariable(v) ? context.getFloat(Utils.idFromNan(v)) : v;
            }
        }
    }

    @Override
    public void registerListening(@NonNull RemoteContext context) {
        context.putObject(this.mId, this);
        for (int i = 0; i < this.mEquations.length; ++i) {
            float[] mEquation;
            for (float v : mEquation = this.mEquations[i]) {
                if (!Float.isNaN(v) || AnimatedFloatExpression.isMathOperator(v) || NanMap.isDataVariable(v)) continue;
                context.listensTo(Utils.idFromNan(v), this);
            }
        }
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        ParticlesCreate.apply(buffer, this.mId, this.mVarId, this.mEquations, this.mParticleCount);
    }

    @NonNull
    public String toString() {
        String str = "ParticlesCreate[" + Utils.idString(this.mId) + "] ";
        for (int j = 0; j < this.mVarId.length; ++j) {
            str = str + "[" + this.mVarId[j] + "] ";
            float[] equation = this.mEquations[j];
            String[] labels = new String[equation.length];
            for (int i = 0; i < equation.length; ++i) {
                if (!Float.isNaN(equation[i])) continue;
                labels[i] = "[" + Utils.idStringFromNan(equation[i]) + "]";
            }
            str = str + AnimatedFloatExpression.toString(equation, labels) + "\n";
        }
        return str;
    }

    public static void apply(@NonNull WireBuffer buffer, int id2, @NonNull int[] varId, @NonNull float[][] equations, int particleCount) {
        buffer.start(161);
        buffer.writeInt(id2);
        buffer.writeInt(particleCount);
        buffer.writeInt(varId.length);
        for (int i = 0; i < varId.length; ++i) {
            buffer.writeInt(varId[i]);
            buffer.writeInt(equations[i].length);
            for (int j = 0; j < equations[i].length; ++j) {
                buffer.writeFloat(equations[i][j]);
            }
        }
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int id2 = buffer.readInt();
        int particleCount = buffer.readInt();
        int varLen = buffer.readInt();
        if (varLen > 2000) {
            throw new RuntimeException(varLen + " map entries more than max = " + 2000);
        }
        int[] varId = new int[varLen];
        float[][] equations = new float[varLen][];
        for (int i = 0; i < varId.length; ++i) {
            varId[i] = buffer.readInt();
            int equLen = buffer.readInt();
            if (equLen > 32) {
                throw new RuntimeException(equLen + " map entries more than max = " + 2000);
            }
            equations[i] = new float[equLen];
            for (int j = 0; j < equations[i].length; ++j) {
                equations[i][j] = buffer.readFloat();
            }
        }
        ParticlesCreate data = new ParticlesCreate(id2, varId, equations, particleCount);
        operations.add(data);
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Data Operations", 161, CLASS_NAME).description("Creates a particle system").field(0, "id", "The reference of the particle system").field(0, "particleCount", "number of particles to create").field(0, "varLen", "number of variables asociate with the particles").field(10, "id", "varLen", "id followed by equations").field(0, "equLen", "length of the equation").field(10, "equation", "varLen * equLen", "float array equations");
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return indent + this.toString();
    }

    @Override
    public void paint(@NonNull PaintContext context) {
        for (int i = 0; i < this.mParticles.length; ++i) {
            this.initializeParticle(i);
        }
    }

    void initializeParticle(int pNo) {
        for (int j = 0; j < this.mParticles[pNo].length; ++j) {
            for (int k = 0; k < this.mIndexeVars.length; ++k) {
                int pos = this.mIndexeVars[k];
                int jIndex = pos / this.mOutEquations.length;
                int kIndex = pos % this.mOutEquations.length;
                this.mOutEquations[jIndex][kIndex] = pNo;
            }
            this.mParticles[pNo][j] = this.mExp.eval(this.mOutEquations[j], this.mOutEquations[j].length, new float[0]);
        }
    }

    public float[][] getParticles() {
        return this.mParticles;
    }

    public int[] getVariableIds() {
        return this.mVarId;
    }

    public float[][] getEquations() {
        return this.mOutEquations;
    }

    @Override
    public void serialize(MapSerializer serializer) {
    }
}

