/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.DrawBase2;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import java.util.List;

public class MatrixSkew
extends DrawBase2 {
    private static final int OP_CODE = 128;
    private static final String CLASS_NAME = "MatrixSkew";

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        DrawBase2.Maker m = MatrixSkew::new;
        MatrixSkew.read(m, buffer, operations);
    }

    public static int id() {
        return 128;
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    @Override
    protected void write(@NonNull WireBuffer buffer, float v1, float v2) {
        MatrixSkew.apply(buffer, v1, v2);
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Canvas Operations", 128, CLASS_NAME).description("Current matrix with the specified skew.").field(1, "skewX", "The amount to skew in X").field(1, "skewY", "The amount to skew in Y");
    }

    public MatrixSkew(float skewX, float skewY) {
        super(skewX, skewY);
        this.mName = CLASS_NAME;
    }

    @Override
    public void paint(@NonNull PaintContext context) {
        context.matrixSkew(this.mV1, this.mV2);
    }

    public static void apply(@NonNull WireBuffer buffer, float x1, float y1) {
        MatrixSkew.write(buffer, 128, x1, y1);
    }

    @Override
    public void serialize(MapSerializer serializer) {
        this.serialize(serializer, "skewX", "skewY").addType(CLASS_NAME);
    }
}

