/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.operations.layout.Container;
import com.android.internal.widget.remotecompose.core.operations.utilities.AnimatedFloatExpression;
import java.util.ArrayList;
import java.util.List;

public class FloatFunctionDefine
extends Operation
implements VariableSupport,
Container {
    private static final int OP_CODE = 168;
    private static final String CLASS_NAME = "FunctionDefine";
    private final int mId;
    private final int[] mFloatVarId;
    @NonNull
    private ArrayList<Operation> mList = new ArrayList();
    @NonNull
    AnimatedFloatExpression mExp = new AnimatedFloatExpression();

    public FloatFunctionDefine(int id2, int[] floatVarId) {
        this.mId = id2;
        this.mFloatVarId = floatVarId;
    }

    @Override
    @NonNull
    public ArrayList<Operation> getList() {
        return this.mList;
    }

    @Override
    public void updateVariables(@NonNull RemoteContext context) {
    }

    @Override
    public void registerListening(@NonNull RemoteContext context) {
        context.putObject(this.mId, this);
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        FloatFunctionDefine.apply(buffer, this.mId, this.mFloatVarId);
    }

    @NonNull
    public String toString() {
        String str = "FloatFunctionDefine[" + Utils.idString(this.mId) + "] (";
        for (int j = 0; j < this.mFloatVarId.length; ++j) {
            str = str + "[" + this.mFloatVarId[j] + "] ";
        }
        str = str + ")";
        for (Operation operation : this.mList) {
            str = str + " \n  " + operation.toString();
        }
        return str;
    }

    public static void apply(@NonNull WireBuffer buffer, int id2, @NonNull int[] varId) {
        buffer.start(168);
        buffer.writeInt(id2);
        buffer.writeInt(varId.length);
        for (int i = 0; i < varId.length; ++i) {
            buffer.writeInt(varId[i]);
        }
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int id2 = buffer.readInt();
        int varLen = buffer.readInt();
        int[] varId = new int[varLen];
        for (int i = 0; i < varId.length; ++i) {
            varId[i] = buffer.readInt();
        }
        FloatFunctionDefine data = new FloatFunctionDefine(id2, varId);
        operations.add(data);
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Data Operations", 168, CLASS_NAME).description("Define a function").field(0, "id", "The reference of the function").field(0, "varLen", "number of arguments to the function").field(10, "id", "varLen", "id equations");
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return indent + this.toString();
    }

    public int[] getArgs() {
        return this.mFloatVarId;
    }

    @Override
    public void apply(@NonNull RemoteContext context) {
    }

    public void execute(@NonNull RemoteContext context) {
        for (Operation op : this.mList) {
            if (op instanceof VariableSupport) {
                ((VariableSupport)((Object)op)).updateVariables(context);
            }
            context.incrementOpCount();
            op.apply(context);
        }
    }
}

