/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.ComponentData;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.operations.utilities.AnimatedFloatExpression;
import com.android.internal.widget.remotecompose.core.operations.utilities.NanMap;
import com.android.internal.widget.remotecompose.core.operations.utilities.easing.FloatAnimation;
import com.android.internal.widget.remotecompose.core.operations.utilities.easing.SpringStopEngine;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;
import com.android.internal.widget.remotecompose.core.serialize.SerializeTags;
import java.util.List;

public class FloatExpression
extends Operation
implements ComponentData,
VariableSupport,
Serializable {
    private static final int OP_CODE = 81;
    private static final String CLASS_NAME = "FloatExpression";
    public int mId;
    @NonNull
    public float[] mSrcValue;
    @Nullable
    public float[] mSrcAnimation;
    @Nullable
    public FloatAnimation mFloatAnimation;
    @Nullable
    private SpringStopEngine mSpring;
    @Nullable
    public float[] mPreCalcValue;
    private float mLastChange = Float.NaN;
    private float mLastCalculatedValue = Float.NaN;
    @NonNull
    AnimatedFloatExpression mExp = new AnimatedFloatExpression();
    public static final int MAX_EXPRESSION_SIZE = 32;
    float mLastAnimatedValue = Float.NaN;

    public FloatExpression(int id2, @NonNull float[] value, @Nullable float[] animation) {
        this.mId = id2;
        this.mSrcValue = value;
        this.mSrcAnimation = animation;
        if (this.mSrcAnimation != null) {
            if (this.mSrcAnimation.length > 4 && this.mSrcAnimation[0] == 0.0f) {
                this.mSpring = new SpringStopEngine(this.mSrcAnimation);
            } else {
                this.mFloatAnimation = new FloatAnimation(this.mSrcAnimation);
            }
        }
    }

    @Override
    public void updateVariables(@NonNull RemoteContext context) {
        if (this.mPreCalcValue == null || this.mPreCalcValue.length != this.mSrcValue.length) {
            this.mPreCalcValue = new float[this.mSrcValue.length];
        }
        boolean value_changed = false;
        for (int i = 0; i < this.mSrcValue.length; ++i) {
            float v = this.mSrcValue[i];
            if (Float.isNaN(v) && !AnimatedFloatExpression.isMathOperator(v) && !NanMap.isDataVariable(v)) {
                int id2 = Utils.idFromNan(v);
                float newValue = context.getFloat(Utils.idFromNan(v));
                if (id2 == 27 && newValue == 0.0f) {
                    newValue = 1.0f;
                }
                if (this.mFloatAnimation != null) {
                    if (this.mPreCalcValue[i] == newValue) continue;
                    value_changed = true;
                    this.mPreCalcValue[i] = newValue;
                    continue;
                }
                if (this.mSpring != null) {
                    if (this.mPreCalcValue[i] == newValue) continue;
                    value_changed = true;
                    this.mPreCalcValue[i] = newValue;
                    continue;
                }
                this.mPreCalcValue[i] = newValue;
                continue;
            }
            this.mPreCalcValue[i] = this.mSrcValue[i];
        }
        float v = this.mLastCalculatedValue;
        if (value_changed) {
            v = this.mExp.eval(this.mPreCalcValue, this.mPreCalcValue.length, new float[0]);
            if (v != this.mLastCalculatedValue) {
                this.mLastChange = context.getAnimationTime();
                this.mLastCalculatedValue = v;
            } else {
                value_changed = false;
            }
        }
        if (value_changed && this.mFloatAnimation != null) {
            if (Float.isNaN(this.mFloatAnimation.getTargetValue())) {
                this.mFloatAnimation.setInitialValue(v);
            } else {
                this.mFloatAnimation.setInitialValue(this.mFloatAnimation.getTargetValue());
            }
            this.mFloatAnimation.setTargetValue(v);
        } else if (value_changed && this.mSpring != null) {
            this.mSpring.setTargetValue(v);
        }
    }

    @Override
    public void registerListening(@NonNull RemoteContext context) {
        for (float v : this.mSrcValue) {
            if (!Float.isNaN(v) || AnimatedFloatExpression.isMathOperator(v) || NanMap.isDataVariable(v)) continue;
            context.listensTo(Utils.idFromNan(v), this);
        }
    }

    @Override
    public void apply(@NonNull RemoteContext context) {
        float t = context.getAnimationTime();
        if (Float.isNaN(this.mLastChange)) {
            this.mLastChange = t;
        }
        if (this.mFloatAnimation != null) {
            float lastComputedValue;
            if (Float.isNaN(this.mLastCalculatedValue)) {
                try {
                    this.mLastCalculatedValue = this.mExp.eval(context.getCollectionsAccess(), this.mPreCalcValue, this.mPreCalcValue.length);
                    this.mFloatAnimation.setTargetValue(this.mLastCalculatedValue);
                    if (Float.isNaN(this.mFloatAnimation.getInitialValue())) {
                        this.mFloatAnimation.setInitialValue(this.mLastCalculatedValue);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(this.toString() + " len = " + this.mPreCalcValue.length, e);
                }
            }
            if ((lastComputedValue = this.mFloatAnimation.get(t - this.mLastChange)) != this.mLastAnimatedValue) {
                this.mLastAnimatedValue = lastComputedValue;
                context.loadFloat(this.mId, lastComputedValue);
                context.needsRepaint();
                this.markDirty();
            }
        } else if (this.mSpring != null) {
            float lastComputedValue = this.mSpring.get(t - this.mLastChange);
            if (lastComputedValue != this.mLastAnimatedValue) {
                this.mLastAnimatedValue = lastComputedValue;
                context.loadFloat(this.mId, lastComputedValue);
                context.needsRepaint();
            }
        } else {
            float v = 0.0f;
            try {
                v = this.mExp.eval(context.getCollectionsAccess(), this.mPreCalcValue, this.mPreCalcValue.length);
            }
            catch (Exception e) {
                throw new RuntimeException(this.toString() + " len = " + this.mPreCalcValue.length, e);
            }
            context.loadFloat(this.mId, v);
        }
    }

    public float evaluate(@NonNull RemoteContext context) {
        this.updateVariables(context);
        float t = context.getAnimationTime();
        if (Float.isNaN(this.mLastChange)) {
            this.mLastChange = t;
        }
        return this.mExp.eval(context.getCollectionsAccess(), this.mPreCalcValue, this.mPreCalcValue.length);
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        FloatExpression.apply(buffer, this.mId, this.mSrcValue, this.mSrcAnimation);
    }

    @NonNull
    public String toString() {
        String[] labels = new String[this.mSrcValue.length];
        for (int i = 0; i < this.mSrcValue.length; ++i) {
            if (!Float.isNaN(this.mSrcValue[i])) continue;
            labels[i] = "[" + Utils.idStringFromNan(this.mSrcValue[i]) + "]";
        }
        if (this.mPreCalcValue == null) {
            return "FloatExpression[" + this.mId + "] = (" + AnimatedFloatExpression.toString(this.mSrcValue, labels) + ")";
        }
        return "FloatExpression[" + this.mId + "] = (" + AnimatedFloatExpression.toString(this.mPreCalcValue, labels) + ")";
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 81;
    }

    public static void apply(@NonNull WireBuffer buffer, int id2, @NonNull float[] value, @Nullable float[] animation) {
        buffer.start(81);
        buffer.writeInt(id2);
        int len = value.length;
        if (len > 32) {
            throw new RuntimeException(AnimatedFloatExpression.toString(value, null) + " to long");
        }
        if (animation != null) {
            len |= animation.length << 16;
        }
        buffer.writeInt(len);
        for (float v : value) {
            buffer.writeFloat(v);
        }
        if (animation != null) {
            for (float v : animation) {
                buffer.writeFloat(v);
            }
        }
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        float[] animation;
        int id2 = buffer.readInt();
        int len = buffer.readInt();
        int valueLen = len & 0xFFFF;
        if (valueLen > 32) {
            throw new RuntimeException("Float expression too long");
        }
        int animLen = len >> 16 & 0xFFFF;
        float[] values = new float[valueLen];
        for (int i = 0; i < values.length; ++i) {
            values[i] = buffer.readFloat();
        }
        if (animLen != 0) {
            animation = new float[animLen];
            for (int i = 0; i < animation.length; ++i) {
                animation[i] = buffer.readFloat();
            }
        } else {
            animation = null;
        }
        operations.add(new FloatExpression(id2, values, animation));
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Expressions Operations", 81, CLASS_NAME).description("A Float expression").field(0, "id", "The id of the Color").field(9, "expression_length", "expression length").field(9, "animation_length", "animation description length").field(10, "expression", "expression_length", "Sequence of Floats representing and expression").field(10, "AnimationSpec", "animation_length", "Sequence of Floats representing animation curve").field(1, "duration", "> time in sec").field(0, "bits", "> WRAP|INITALVALUE | TYPE ").field(10, "spec", "> [SPEC PARAMETERS] ").field(1, "initialValue", "> [Initial value] ").field(1, "wrapValue", "> [Wrap value] ");
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return indent + this.toString();
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addTags(SerializeTags.EXPRESSION).addType(CLASS_NAME).add("id", this.mId).addFloatExpressionSrc("srcValues", this.mSrcValue).add("animation", this.mFloatAnimation);
    }
}

