/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.PaintOperation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import java.util.List;

public class DrawTweenPath
extends PaintOperation
implements VariableSupport {
    private static final int OP_CODE = 125;
    private static final String CLASS_NAME = "DrawTweenPath";
    float mTween;
    float mStart;
    float mStop;
    float mOutTween;
    float mOutStart;
    float mOutStop;
    int mPath1Id;
    int mPath2Id;

    public DrawTweenPath(int path1Id, int path2Id, float tween, float start, float stop) {
        this.mOutTween = this.mTween = tween;
        this.mOutStart = this.mStart = start;
        this.mOutStop = this.mStop = stop;
        this.mPath1Id = path1Id;
        this.mPath2Id = path2Id;
    }

    @Override
    public void updateVariables(@NonNull RemoteContext context) {
        this.mOutTween = Float.isNaN(this.mTween) ? context.getFloat(Utils.idFromNan(this.mTween)) : this.mTween;
        this.mOutStart = Float.isNaN(this.mStart) ? context.getFloat(Utils.idFromNan(this.mStart)) : this.mStart;
        this.mOutStop = Float.isNaN(this.mStop) ? context.getFloat(Utils.idFromNan(this.mStop)) : this.mStop;
    }

    @Override
    public void registerListening(@NonNull RemoteContext context) {
        if (Float.isNaN(this.mTween)) {
            context.listensTo(Utils.idFromNan(this.mTween), this);
        }
        if (Float.isNaN(this.mStart)) {
            context.listensTo(Utils.idFromNan(this.mStart), this);
        }
        if (Float.isNaN(this.mStop)) {
            context.listensTo(Utils.idFromNan(this.mStop), this);
        }
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        DrawTweenPath.apply(buffer, this.mPath1Id, this.mPath2Id, this.mTween, this.mStart, this.mStop);
    }

    @NonNull
    public String toString() {
        return "DrawTweenPath " + this.mPath1Id + " " + this.mPath2Id + " " + Utils.floatToString(this.mTween, this.mOutTween) + " " + Utils.floatToString(this.mStart, this.mOutStart) + " - " + Utils.floatToString(this.mStop, this.mOutStop);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int path1Id = buffer.readInt();
        int path2Id = buffer.readInt();
        float tween = buffer.readFloat();
        float start = buffer.readFloat();
        float stop = buffer.readFloat();
        DrawTweenPath op = new DrawTweenPath(path1Id, path2Id, tween, start, stop);
        operations.add(op);
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 125;
    }

    public static void apply(@NonNull WireBuffer buffer, int path1Id, int path2Id, float tween, float start, float stop) {
        buffer.start(125);
        buffer.writeInt(path1Id);
        buffer.writeInt(path2Id);
        buffer.writeFloat(tween);
        buffer.writeFloat(start);
        buffer.writeFloat(stop);
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Draw Operations", 125, CLASS_NAME).description("Draw text along path object").field(0, "pathId1", "id of path 1").field(0, "pathId2", "id of path 2").field(1, "tween", "interpolate between the two paths").field(1, "start", "trim the start of the path").field(1, "yOffset", "trim the end of the path");
    }

    @Override
    public void paint(@NonNull PaintContext context) {
        context.drawTweenPath(this.mPath1Id, this.mPath2Id, this.mOutTween, this.mOutStart, this.mOutStop);
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("path1Id", this.mPath1Id).add("path2Id", this.mPath2Id).add("tween", this.mTween, this.mOutTween).add("start", this.mStart, this.mOutStart).add("stop", this.mStop, this.mOutStop);
    }
}

