/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.PaintOperation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import java.util.List;

public class ColorAttribute
extends PaintOperation {
    private static final int OP_CODE = 180;
    private static final String CLASS_NAME = "ColorAttribute";
    public int mId;
    public int mColorId;
    public short mType;
    public static final short COLOR_HUE = 0;
    public static final short COLOR_SATURATION = 1;
    public static final short COLOR_BRIGHTNESS = 2;
    public static final short COLOR_RED = 3;
    public static final short COLOR_GREEN = 4;
    public static final short COLOR_BLUE = 5;
    public static final short COLOR_ALPHA = 6;
    @NonNull
    float[] mBounds = new float[4];

    public ColorAttribute(int id2, int colorId, short type) {
        this.mId = id2;
        this.mColorId = colorId;
        this.mType = type;
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        ColorAttribute.apply(buffer, this.mId, this.mColorId, this.mType);
    }

    @NonNull
    public String toString() {
        return "ColorAttribute[" + this.mId + "] = " + this.mColorId + " " + this.mType;
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 180;
    }

    public static void apply(@NonNull WireBuffer buffer, int id2, int textId, short type) {
        buffer.start(180);
        buffer.writeInt(id2);
        buffer.writeInt(textId);
        buffer.writeShort(type);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int id2 = buffer.readInt();
        int textId = buffer.readInt();
        short type = (short)buffer.readShort();
        operations.add(new ColorAttribute(id2, textId, type));
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Color Operations", 180, CLASS_NAME).description("Calculate Information about a Color").field(0, "id", "id to output").field(0, "longId", "id of color").field(9, "type", "the type information to extract");
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return indent + this.toString();
    }

    @Override
    public void paint(@NonNull PaintContext context) {
        int val = this.mType & 0xFF;
        RemoteContext ctx = context.getContext();
        int color2 = ctx.getColor(this.mColorId);
        switch (val) {
            case 0: {
                ctx.loadFloat(this.mId, Utils.getHue(color2));
                break;
            }
            case 1: {
                ctx.loadFloat(this.mId, Utils.getSaturation(color2));
                break;
            }
            case 2: {
                ctx.loadFloat(this.mId, Utils.getBrightness(color2));
                break;
            }
            case 3: {
                ctx.loadFloat(this.mId, (float)(color2 >> 16 & 0xFF) / 255.0f);
                break;
            }
            case 4: {
                ctx.loadFloat(this.mId, (float)(color2 >> 8 & 0xFF) / 255.0f);
                break;
            }
            case 5: {
                ctx.loadFloat(this.mId, (float)(color2 & 0xFF) / 255.0f);
                break;
            }
            case 6: {
                ctx.loadFloat(this.mId, (float)(color2 >> 24 & 0xFF) / 255.0f);
            }
        }
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("id", this.mId).add("timeId", this.mColorId).addType(this.getTypeString());
    }

    private String getTypeString() {
        int val = this.mType & 0xFF;
        switch (val) {
            case 0: {
                return "COLOR_HUE";
            }
            case 1: {
                return "COLOR_SATURATION";
            }
            case 2: {
                return "COLOR_BRIGHTNESS";
            }
            case 3: {
                return "COLOR_RED";
            }
            case 4: {
                return "COLOR_GREEN";
            }
            case 5: {
                return "COLOR_BLUE";
            }
            case 6: {
                return "COLOR_ALPHA";
            }
        }
        return "INVALID_TIME_TYPE";
    }
}

