/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.RemoteComposeOperation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.semantics.AccessibleComponent;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;
import java.util.List;

public class ClickArea
extends Operation
implements RemoteComposeOperation,
AccessibleComponent,
VariableSupport,
Serializable {
    private static final int OP_CODE = 64;
    private static final String CLASS_NAME = "ClickArea";
    int mId;
    int mContentDescription;
    float mLeft;
    float mTop;
    float mRight;
    float mBottom;
    float mOutLeft;
    float mOutTop;
    float mOutRight;
    float mOutBottom;
    int mMetadata;

    public ClickArea(int id2, int contentDescription, float left, float top, float right, float bottom, int metadata) {
        this.mId = id2;
        this.mContentDescription = contentDescription;
        this.mOutLeft = this.mLeft = left;
        this.mOutTop = this.mTop = top;
        this.mOutRight = this.mRight = right;
        this.mOutBottom = this.mBottom = bottom;
        this.mMetadata = metadata;
    }

    @Override
    public void registerListening(@NonNull RemoteContext context) {
        if (Float.isNaN(this.mLeft)) {
            context.listensTo(Utils.idFromNan(this.mLeft), this);
        }
        if (Float.isNaN(this.mTop)) {
            context.listensTo(Utils.idFromNan(this.mTop), this);
        }
        if (Float.isNaN(this.mRight)) {
            context.listensTo(Utils.idFromNan(this.mRight), this);
        }
        if (Float.isNaN(this.mBottom)) {
            context.listensTo(Utils.idFromNan(this.mBottom), this);
        }
    }

    @Override
    public void updateVariables(@NonNull RemoteContext context) {
        this.mOutLeft = Float.isNaN(this.mLeft) ? context.getFloat(Utils.idFromNan(this.mLeft)) : this.mLeft;
        this.mOutTop = Float.isNaN(this.mTop) ? context.getFloat(Utils.idFromNan(this.mTop)) : this.mTop;
        this.mRight = Float.isNaN(this.mRight) ? context.getFloat(Utils.idFromNan(this.mRight)) : this.mRight;
        this.mOutBottom = Float.isNaN(this.mBottom) ? context.getFloat(Utils.idFromNan(this.mBottom)) : this.mBottom;
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        ClickArea.apply(buffer, this.mId, this.mContentDescription, this.mLeft, this.mTop, this.mRight, this.mBottom, this.mMetadata);
    }

    @NonNull
    public String toString() {
        return "CLICK_AREA <" + this.mId + " <" + this.mContentDescription + "> <" + this.mMetadata + ">+" + this.mLeft + " " + this.mTop + " " + this.mRight + " " + this.mBottom + "+ (" + (this.mRight - this.mLeft) + " x " + (this.mBottom - this.mTop) + " }";
    }

    @Override
    public void apply(@NonNull RemoteContext context) {
        context.addClickArea(this.mId, this.mContentDescription, this.mOutLeft, this.mOutTop, this.mOutRight, this.mOutBottom, this.mMetadata);
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return indent + this.toString();
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 64;
    }

    @Override
    public Integer getContentDescriptionId() {
        return this.mContentDescription;
    }

    public static void apply(@NonNull WireBuffer buffer, int id2, int contentDescription, float left, float top, float right, float bottom, int metadata) {
        buffer.start(64);
        buffer.writeInt(id2);
        buffer.writeInt(contentDescription);
        buffer.writeFloat(left);
        buffer.writeFloat(top);
        buffer.writeFloat(right);
        buffer.writeFloat(bottom);
        buffer.writeInt(metadata);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int id2 = buffer.readInt();
        int contentDescription = buffer.readInt();
        float left = buffer.readFloat();
        float top = buffer.readFloat();
        float right = buffer.readFloat();
        float bottom = buffer.readFloat();
        int metadata = buffer.readInt();
        ClickArea clickArea = new ClickArea(id2, contentDescription, left, top, right, bottom, metadata);
        operations.add(clickArea);
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Canvas Operations", 64, CLASS_NAME).description("Define a region you can click on").field(1, "left", "The left side of the region").field(1, "top", "The top of the region").field(1, "right", "The right side of the region").field(1, "bottom", "The bottom of the region").field(1, "metadata", "user defined string accessible in callback");
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("id", this.mId).add("contentDescriptionId", this.mContentDescription).add("left", this.mLeft, this.mOutLeft).add("top", this.mTop, this.mOutTop).add("right", this.mRight, this.mOutRight).add("bottom", this.mBottom, this.mOutBottom).add("metadata", this.mMetadata);
    }
}

