/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintOperation;
import com.android.internal.widget.remotecompose.core.RemoteComposeBuffer;
import com.android.internal.widget.remotecompose.core.RemoteComposeState;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.SerializableToString;
import com.android.internal.widget.remotecompose.core.TimeVariables;
import com.android.internal.widget.remotecompose.core.TouchListener;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.operations.BitmapData;
import com.android.internal.widget.remotecompose.core.operations.ComponentValue;
import com.android.internal.widget.remotecompose.core.operations.DataListFloat;
import com.android.internal.widget.remotecompose.core.operations.DrawContent;
import com.android.internal.widget.remotecompose.core.operations.FloatConstant;
import com.android.internal.widget.remotecompose.core.operations.FloatExpression;
import com.android.internal.widget.remotecompose.core.operations.Header;
import com.android.internal.widget.remotecompose.core.operations.IntegerExpression;
import com.android.internal.widget.remotecompose.core.operations.NamedVariable;
import com.android.internal.widget.remotecompose.core.operations.ShaderData;
import com.android.internal.widget.remotecompose.core.operations.TextData;
import com.android.internal.widget.remotecompose.core.operations.Theme;
import com.android.internal.widget.remotecompose.core.operations.layout.CanvasOperations;
import com.android.internal.widget.remotecompose.core.operations.layout.Component;
import com.android.internal.widget.remotecompose.core.operations.layout.Container;
import com.android.internal.widget.remotecompose.core.operations.layout.ContainerEnd;
import com.android.internal.widget.remotecompose.core.operations.layout.LayoutComponent;
import com.android.internal.widget.remotecompose.core.operations.layout.LoopOperation;
import com.android.internal.widget.remotecompose.core.operations.layout.RootLayoutComponent;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.ComponentModifiers;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.ModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.utilities.IntMap;
import com.android.internal.widget.remotecompose.core.operations.utilities.StringSerializer;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;
import com.android.internal.widget.remotecompose.core.types.IntegerConstant;
import com.android.internal.widget.remotecompose.core.types.LongConstant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class CoreDocument
implements Serializable {
    private static final boolean DEBUG = false;
    public static final int MAJOR_VERSION = 1;
    public static final int MINOR_VERSION = 0;
    public static final int PATCH_VERSION = 0;
    public static final int DOCUMENT_API_LEVEL = 6;
    static final float BUILD = 0.0f;
    private static final boolean UPDATE_VARIABLES_BEFORE_LAYOUT = false;
    @NonNull
    ArrayList<Operation> mOperations = new ArrayList();
    @Nullable
    RootLayoutComponent mRootLayoutComponent = null;
    @NonNull
    RemoteComposeState mRemoteComposeState = new RemoteComposeState();
    @VisibleForTesting
    @NonNull
    public TimeVariables mTimeVariables = new TimeVariables();
    @NonNull
    Version mVersion = new Version(1, 0, 0);
    @Nullable
    String mContentDescription;
    long mRequiredCapabilities = 0L;
    int mWidth = 0;
    int mHeight = 0;
    int mContentScroll = 0;
    int mContentSizing = 0;
    int mContentMode = 0;
    int mContentAlignment = 34;
    @NonNull
    RemoteComposeBuffer mBuffer = new RemoteComposeBuffer(this.mRemoteComposeState);
    private final HashMap<Long, IntegerExpression> mIntegerExpressions = new HashMap();
    private final HashMap<Integer, FloatExpression> mFloatExpressions = new HashMap();
    private HashSet<Component> mAppliedTouchOperations = new HashSet();
    private int mLastId = 1;
    private IntMap<Object> mDocProperties;
    boolean mFirstPaint = true;
    private boolean mIsUpdateDoc = false;
    HapticEngine mHapticEngine;
    @NonNull
    HashSet<ActionCallback> mActionListeners = new HashSet();
    @NonNull
    HashSet<IdActionCallback> mIdActionListeners = new HashSet();
    @NonNull
    HashSet<TouchListener> mTouchListeners = new HashSet();
    @NonNull
    HashSet<ClickAreaRepresentation> mClickAreas = new HashSet();
    @NonNull
    private HashMap<Integer, Component> mComponentMap = new HashMap();
    private final float[] mScaleOutput = new float[2];
    private final float[] mTranslateOutput = new float[2];
    private int mRepaintNext = -1;
    private int mLastOpCount;

    public static int getDocumentApiLevel() {
        return 6;
    }

    @Nullable
    public String getContentDescription() {
        return this.mContentDescription;
    }

    public void setContentDescription(@Nullable String contentDescription) {
        this.mContentDescription = contentDescription;
    }

    public long getRequiredCapabilities() {
        return this.mRequiredCapabilities;
    }

    public void setRequiredCapabilities(long requiredCapabilities) {
        this.mRequiredCapabilities = requiredCapabilities;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public void setWidth(int width) {
        this.mWidth = width;
        this.mRemoteComposeState.setWindowWidth(width);
    }

    public int getHeight() {
        return this.mHeight;
    }

    public void setHeight(int height) {
        this.mHeight = height;
        this.mRemoteComposeState.setWindowHeight(height);
    }

    @NonNull
    public RemoteComposeBuffer getBuffer() {
        return this.mBuffer;
    }

    public void setBuffer(@NonNull RemoteComposeBuffer buffer) {
        this.mBuffer = buffer;
    }

    @NonNull
    public RemoteComposeState getRemoteComposeState() {
        return this.mRemoteComposeState;
    }

    public void setRemoteComposeState(@NonNull RemoteComposeState remoteComposeState) {
        this.mRemoteComposeState = remoteComposeState;
    }

    public int getContentScroll() {
        return this.mContentScroll;
    }

    public int getContentSizing() {
        return this.mContentSizing;
    }

    public int getContentMode() {
        return this.mContentMode;
    }

    public void setRootContentBehavior(int scroll, int alignment, int sizing, int mode) {
        this.mContentScroll = scroll;
        this.mContentAlignment = alignment;
        this.mContentSizing = sizing;
        this.mContentMode = mode;
    }

    public void computeScale(float w, float h, @NonNull float[] scaleOutput) {
        float contentScaleX = 1.0f;
        float contentScaleY = 1.0f;
        if (this.mContentSizing == 2) {
            float scaleX = 1.0f;
            float scaleY = 1.0f;
            float scale = 1.0f;
            switch (this.mContentMode) {
                case 1: {
                    scaleX = w / (float)this.mWidth;
                    scaleY = h / (float)this.mHeight;
                    contentScaleX = scale = Math.min(1.0f, Math.min(scaleX, scaleY));
                    contentScaleY = scale;
                    break;
                }
                case 4: {
                    scaleX = w / (float)this.mWidth;
                    scaleY = h / (float)this.mHeight;
                    contentScaleX = scale = Math.min(scaleX, scaleY);
                    contentScaleY = scale;
                    break;
                }
                case 2: {
                    contentScaleX = scale = w / (float)this.mWidth;
                    contentScaleY = scale;
                    break;
                }
                case 3: {
                    contentScaleX = scale = h / (float)this.mHeight;
                    contentScaleY = scale;
                    break;
                }
                case 5: {
                    scaleX = w / (float)this.mWidth;
                    scaleY = h / (float)this.mHeight;
                    contentScaleX = scale = Math.max(scaleX, scaleY);
                    contentScaleY = scale;
                    break;
                }
                case 6: {
                    scaleX = w / (float)this.mWidth;
                    scaleY = h / (float)this.mHeight;
                    contentScaleX = scaleX;
                    contentScaleY = scaleY;
                    break;
                }
            }
        }
        scaleOutput[0] = contentScaleX;
        scaleOutput[1] = contentScaleY;
    }

    private void computeTranslate(float w, float h, float contentScaleX, float contentScaleY, @NonNull float[] translateOutput) {
        int horizontalContentAlignment = this.mContentAlignment & 0xF0;
        int verticalContentAlignment = this.mContentAlignment & 0xF;
        float translateX = 0.0f;
        float translateY = 0.0f;
        float contentWidth = (float)this.mWidth * contentScaleX;
        float contentHeight = (float)this.mHeight * contentScaleY;
        switch (horizontalContentAlignment) {
            case 16: {
                break;
            }
            case 32: {
                translateX = (w - contentWidth) / 2.0f;
                break;
            }
            case 64: {
                translateX = w - contentWidth;
                break;
            }
        }
        switch (verticalContentAlignment) {
            case 1: {
                break;
            }
            case 2: {
                translateY = (h - contentHeight) / 2.0f;
                break;
            }
            case 4: {
                translateY = h - contentHeight;
                break;
            }
        }
        translateOutput[0] = translateX;
        translateOutput[1] = translateY;
    }

    @NonNull
    public Set<ClickAreaRepresentation> getClickAreas() {
        return this.mClickAreas;
    }

    @Nullable
    public RootLayoutComponent getRootLayoutComponent() {
        return this.mRootLayoutComponent;
    }

    public void invalidateMeasure() {
        if (this.mRootLayoutComponent != null) {
            this.mRootLayoutComponent.invalidateMeasure();
        }
    }

    @Nullable
    public Component getComponent(int id2) {
        if (this.mRootLayoutComponent != null) {
            return this.mRootLayoutComponent.getComponent(id2);
        }
        return null;
    }

    @NonNull
    public String displayHierarchy() {
        StringSerializer serializer = new StringSerializer();
        for (Operation op : this.mOperations) {
            if (op instanceof RootLayoutComponent) {
                ((RootLayoutComponent)op).displayHierarchy((Component)op, 0, serializer);
                continue;
            }
            if (!(op instanceof SerializableToString)) continue;
            ((SerializableToString)((Object)op)).serializeToString(0, serializer);
        }
        return serializer.toString();
    }

    public void evaluateIntExpression(long expressionId, int targetId, @NonNull RemoteContext context) {
        IntegerExpression expression = this.mIntegerExpressions.get(expressionId);
        if (expression != null) {
            int v = expression.evaluate(context);
            context.overrideInteger(targetId, v);
        }
    }

    public void evaluateFloatExpression(int expressionId, int targetId, @NonNull RemoteContext context) {
        FloatExpression expression = this.mFloatExpressions.get(expressionId);
        if (expression != null) {
            float v = expression.evaluate(context);
            context.overrideFloat(targetId, v);
        }
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType("CoreDocument").add("width", this.mWidth).add("height", this.mHeight).add("operations", this.mOperations);
    }

    public void setProperties(IntMap<Object> properties) {
        this.mDocProperties = properties;
    }

    public Object getProperty(short key) {
        if (this.mDocProperties == null) {
            return null;
        }
        return this.mDocProperties.get(key);
    }

    public void applyUpdate(CoreDocument delta) {
        HashMap txtData = new HashMap();
        HashMap imgData = new HashMap();
        HashMap fltData = new HashMap();
        HashMap intData = new HashMap();
        HashMap longData = new HashMap();
        HashMap floatListData = new HashMap();
        this.recursiveTraverse(this.mOperations, op -> {
            if (op instanceof TextData) {
                TextData d = (TextData)op;
                txtData.put(d.mTextId, d);
            } else if (op instanceof BitmapData) {
                BitmapData d = (BitmapData)op;
                imgData.put(d.mImageId, d);
            } else if (op instanceof FloatConstant) {
                FloatConstant d = (FloatConstant)op;
                fltData.put(d.mId, d);
            } else if (op instanceof IntegerConstant) {
                IntegerConstant d = (IntegerConstant)op;
                intData.put(d.mId, d);
            } else if (op instanceof LongConstant) {
                LongConstant d = (LongConstant)op;
                longData.put(d.mId, d);
            } else if (op instanceof DataListFloat) {
                DataListFloat d = (DataListFloat)op;
                floatListData.put(d.mId, d);
            }
        });
        this.recursiveTraverse(delta.mOperations, op -> {
            if (op instanceof TextData) {
                TextData t = (TextData)op;
                TextData txtInDoc = (TextData)txtData.get(t.mTextId);
                if (txtInDoc != null) {
                    txtInDoc.update(t);
                    txtInDoc.markDirty();
                }
            } else if (op instanceof BitmapData) {
                BitmapData b = (BitmapData)op;
                BitmapData imgInDoc = (BitmapData)imgData.get(b.mImageId);
                if (imgInDoc != null) {
                    imgInDoc.update(b);
                    imgInDoc.markDirty();
                }
            } else if (op instanceof FloatConstant) {
                FloatConstant f = (FloatConstant)op;
                FloatConstant fltInDoc = (FloatConstant)fltData.get(f.mId);
                if (fltInDoc != null) {
                    fltInDoc.update(f);
                    fltInDoc.markDirty();
                }
            } else if (op instanceof IntegerConstant) {
                IntegerConstant ic = (IntegerConstant)op;
                IntegerConstant intInDoc = (IntegerConstant)intData.get(ic.mId);
                if (intInDoc != null) {
                    intInDoc.update(ic);
                    intInDoc.markDirty();
                }
            } else if (op instanceof LongConstant) {
                LongConstant lc = (LongConstant)op;
                LongConstant longInDoc = (LongConstant)longData.get(lc.mId);
                if (longInDoc != null) {
                    longInDoc.update(lc);
                    longInDoc.markDirty();
                }
            } else if (op instanceof DataListFloat) {
                DataListFloat lc = (DataListFloat)op;
                DataListFloat longInDoc = (DataListFloat)floatListData.get(lc.mId);
                if (longInDoc != null) {
                    longInDoc.update(lc);
                    longInDoc.markDirty();
                }
            }
        });
    }

    private void recursiveTraverse(ArrayList<Operation> mOperations, Visitor visitor) {
        for (Operation op : mOperations) {
            if (op instanceof Container) {
                this.recursiveTraverse(((Container)((Object)op)).getList(), visitor);
            }
            visitor.visit(op);
        }
    }

    public void setHapticEngine(HapticEngine engine) {
        this.mHapticEngine = engine;
    }

    public void haptic(int type) {
        if (this.mHapticEngine != null) {
            this.mHapticEngine.haptic(type);
        }
    }

    public void appliedTouchOperation(Component component) {
        this.mAppliedTouchOperations.add(component);
    }

    public void runNamedAction(@NonNull String name, Object value) {
        for (ActionCallback callback : this.mActionListeners) {
            callback.onAction(name, value);
        }
    }

    public void addActionCallback(@NonNull ActionCallback callback) {
        this.mActionListeners.add(callback);
    }

    public void clearActionCallbacks() {
        this.mActionListeners.clear();
    }

    public void initFromBuffer(@NonNull RemoteComposeBuffer buffer) {
        this.mOperations = new ArrayList();
        buffer.inflateFromBuffer(this.mOperations);
        for (Operation op : this.mOperations) {
            Operation expression;
            if (op instanceof Header) {
                Header header = (Header)op;
                header.setVersion(this);
            }
            if (op instanceof IntegerExpression) {
                expression = (IntegerExpression)op;
                this.mIntegerExpressions.put(Long.valueOf(expression.mId), (IntegerExpression)expression);
            }
            if (!(op instanceof FloatExpression)) continue;
            expression = (FloatExpression)op;
            this.mFloatExpressions.put(((FloatExpression)expression).mId, (FloatExpression)expression);
        }
        this.mOperations = this.inflateComponents(this.mOperations);
        this.mBuffer = buffer;
        for (Operation op : this.mOperations) {
            if (!(op instanceof RootLayoutComponent)) continue;
            this.mRootLayoutComponent = (RootLayoutComponent)op;
            break;
        }
        if (this.mRootLayoutComponent != null) {
            this.mRootLayoutComponent.assignIds(this.mLastId);
        }
    }

    @NonNull
    private ArrayList<Operation> inflateComponents(@NonNull ArrayList<Operation> operations) {
        ArrayList<Operation> finalOperationsList;
        ArrayList<Operation> ops = finalOperationsList = new ArrayList<Operation>();
        ArrayList<Container> containers = new ArrayList<Container>();
        LayoutComponent lastLayoutComponent = null;
        this.mLastId = -1;
        for (Operation o : operations) {
            Container container;
            if (o instanceof Container) {
                container = (Container)((Object)o);
                if (container instanceof Component) {
                    Container parentContainer;
                    Component component = (Component)container;
                    if (!containers.isEmpty() && (parentContainer = (Container)containers.get(containers.size() - 1)) instanceof Component) {
                        component.setParent((Component)parentContainer);
                    }
                    if (component.getComponentId() < this.mLastId) {
                        this.mLastId = component.getComponentId();
                    }
                    if (component instanceof LayoutComponent) {
                        lastLayoutComponent = (LayoutComponent)component;
                    }
                }
                containers.add(container);
                ops = container.getList();
                continue;
            }
            if (o instanceof ContainerEnd) {
                container = null;
                if (!containers.isEmpty()) {
                    container = (Container)containers.remove(containers.size() - 1);
                }
                Container parentContainer = null;
                if (!containers.isEmpty()) {
                    parentContainer = (Container)containers.get(containers.size() - 1);
                }
                ops = parentContainer != null ? parentContainer.getList() : finalOperationsList;
                if (container != null) {
                    if (container instanceof Component) {
                        Component component = (Component)container;
                        component.inflate();
                    }
                    ops.add((Operation)((Object)container));
                }
                if (!(container instanceof CanvasOperations)) continue;
                ((CanvasOperations)container).setComponent(lastLayoutComponent);
                continue;
            }
            if (o instanceof DrawContent) {
                ((DrawContent)o).setComponent(lastLayoutComponent);
            }
            ops.add(o);
        }
        return ops;
    }

    private void registerVariables(@NonNull RemoteContext context, @NonNull ArrayList<Operation> list) {
        for (Operation op : list) {
            if (op instanceof VariableSupport) {
                ((VariableSupport)((Object)op)).registerListening(context);
            }
            if (op instanceof Component) {
                this.mComponentMap.put(((Component)op).getComponentId(), (Component)op);
                ((Component)op).registerVariables(context);
            }
            if (op instanceof Container) {
                this.registerVariables(context, ((Container)((Object)op)).getList());
            }
            if (op instanceof ComponentValue) {
                ComponentValue v = (ComponentValue)op;
                Component component = this.mComponentMap.get(v.getComponentId());
                if (component != null) {
                    component.addComponentValue(v);
                } else {
                    System.out.println("=> Component not found for id " + v.getComponentId());
                }
            }
            if (!(op instanceof ComponentModifiers)) continue;
            for (ModifierOperation modifier : ((ComponentModifiers)op).getList()) {
                if (!(modifier instanceof VariableSupport)) continue;
                ((VariableSupport)((Object)modifier)).registerListening(context);
            }
        }
    }

    private void applyOperations(@NonNull RemoteContext context, @NonNull ArrayList<Operation> list) {
        for (Operation op : list) {
            if (op instanceof VariableSupport) {
                ((VariableSupport)((Object)op)).updateVariables(context);
            }
            if (op instanceof Component) {
                ((Component)op).updateVariables(context);
            }
            op.markNotDirty();
            op.apply(context);
            context.incrementOpCount();
            if (!(op instanceof Container)) continue;
            this.applyOperations(context, ((Container)((Object)op)).getList());
        }
    }

    public void initializeContext(@NonNull RemoteContext context) {
        this.mRemoteComposeState.reset();
        this.mRemoteComposeState.setContext(context);
        this.mClickAreas.clear();
        this.mRemoteComposeState.setNextId(42);
        context.mDocument = this;
        context.mRemoteComposeState = this.mRemoteComposeState;
        context.mMode = RemoteContext.ContextMode.DATA;
        this.mTimeVariables.updateTime(context);
        this.registerVariables(context, this.mOperations);
        this.applyOperations(context, this.mOperations);
        context.mMode = RemoteContext.ContextMode.UNSET;
    }

    public boolean canBeDisplayed(int playerMajorVersion, int playerMinorVersion, long capabilities) {
        if (this.mVersion.major < playerMajorVersion) {
            return true;
        }
        if (this.mVersion.major > playerMajorVersion) {
            return false;
        }
        return this.mVersion.minor <= playerMinorVersion;
    }

    public void setVersion(int majorVersion, int minorVersion, int patch) {
        this.mVersion = new Version(majorVersion, minorVersion, patch);
    }

    public void addClickArea(int id2, @Nullable String contentDescription, float left, float top, float right, float bottom, @Nullable String metadata) {
        ClickAreaRepresentation car = new ClickAreaRepresentation(id2, contentDescription, left, top, right, bottom, metadata);
        boolean old = this.mClickAreas.remove(car);
        this.mClickAreas.add(car);
    }

    public void addTouchListener(TouchListener listener) {
        this.mTouchListeners.add(listener);
    }

    public void addIdActionListener(@NonNull IdActionCallback callback) {
        this.mIdActionListeners.add(callback);
    }

    @NonNull
    public HashSet<IdActionCallback> getIdActionListeners() {
        return this.mIdActionListeners;
    }

    public void onClick(@NonNull RemoteContext context, float x, float y) {
        for (ClickAreaRepresentation clickArea : this.mClickAreas) {
            if (!clickArea.contains(x, y)) continue;
            this.warnClickListeners(clickArea);
        }
        if (this.mRootLayoutComponent != null) {
            this.mRootLayoutComponent.onClick(context, this, x, y);
        }
    }

    public void performClick(@NonNull RemoteContext context, int id2, @NonNull String metadata) {
        for (ClickAreaRepresentation clickArea : this.mClickAreas) {
            if (clickArea.mId != id2) continue;
            this.warnClickListeners(clickArea);
            return;
        }
        for (IdActionCallback listener : this.mIdActionListeners) {
            listener.onAction(id2, metadata);
        }
        Component component = this.getComponent(id2);
        if (component != null) {
            component.onClick(context, this, -1.0f, -1.0f);
        }
    }

    private void warnClickListeners(@NonNull ClickAreaRepresentation clickArea) {
        for (IdActionCallback listener : this.mIdActionListeners) {
            listener.onAction(clickArea.mId, clickArea.mMetadata);
        }
    }

    public boolean hasTouchListener() {
        boolean hasComponentsTouchListeners = this.mRootLayoutComponent != null && this.mRootLayoutComponent.hasTouchListeners();
        return hasComponentsTouchListeners || !this.mTouchListeners.isEmpty();
    }

    public boolean touchDrag(RemoteContext context, float x, float y) {
        context.loadFloat(13, x);
        context.loadFloat(14, y);
        for (TouchListener clickArea : this.mTouchListeners) {
            clickArea.touchDrag(context, x, y);
        }
        if (this.mRootLayoutComponent != null) {
            for (Component component : this.mAppliedTouchOperations) {
                component.onTouchDrag(context, this, x, y, true);
            }
            if (!this.mAppliedTouchOperations.isEmpty()) {
                return true;
            }
        }
        return !this.mTouchListeners.isEmpty();
    }

    public void touchDown(RemoteContext context, float x, float y) {
        context.loadFloat(13, x);
        context.loadFloat(14, y);
        for (TouchListener clickArea : this.mTouchListeners) {
            clickArea.touchDown(context, x, y);
        }
        if (this.mRootLayoutComponent != null) {
            this.mRootLayoutComponent.onTouchDown(context, this, x, y);
        }
        this.mRepaintNext = 1;
    }

    public void touchUp(RemoteContext context, float x, float y, float dx, float dy) {
        context.loadFloat(13, x);
        context.loadFloat(14, y);
        for (TouchListener clickArea : this.mTouchListeners) {
            clickArea.touchUp(context, x, y, dx, dy);
        }
        if (this.mRootLayoutComponent != null) {
            for (Component component : this.mAppliedTouchOperations) {
                component.onTouchUp(context, this, x, y, dx, dy, true);
            }
            this.mAppliedTouchOperations.clear();
        }
        this.mRepaintNext = 1;
    }

    public void touchCancel(RemoteContext context, float x, float y, float dx, float dy) {
        if (this.mRootLayoutComponent != null) {
            for (Component component : this.mAppliedTouchOperations) {
                component.onTouchCancel(context, this, x, y, true);
            }
            this.mAppliedTouchOperations.clear();
        }
        this.mRepaintNext = 1;
    }

    @NonNull
    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Operation op : this.mOperations) {
            builder.append(op.toString());
            builder.append("\n");
        }
        return builder.toString();
    }

    @Nullable
    public String[] getNamedColors() {
        return this.getNamedVariables(2);
    }

    public String[] getNamedVariables(int type) {
        ArrayList<String> ret = new ArrayList<String>();
        this.getNamedVars(type, this.mOperations, ret);
        return ret.toArray(new String[0]);
    }

    private void getNamedVars(int type, ArrayList<Operation> ops, ArrayList<String> list) {
        for (Operation op : ops) {
            if (op instanceof NamedVariable) {
                NamedVariable n = (NamedVariable)op;
                if (n.mVarType == type) {
                    list.add(n.mVarName);
                }
            }
            if (!(op instanceof Container)) continue;
            this.getNamedVars(type, ((Container)((Object)op)).getList(), list);
        }
    }

    public int getOpsPerFrame() {
        return this.mLastOpCount;
    }

    public int needsRepaint() {
        return this.mRepaintNext;
    }

    private void updateVariables(@NonNull RemoteContext context, int theme, List<Operation> operations) {
        for (int i = 0; i < operations.size(); ++i) {
            Operation op = operations.get(i);
            if (op.isDirty() && op instanceof VariableSupport) {
                ((VariableSupport)((Object)op)).updateVariables(context);
                op.apply(context);
                op.markNotDirty();
            }
            if (!(op instanceof Container)) continue;
            this.updateVariables(context, theme, ((Container)((Object)op)).getList());
        }
    }

    public void paint(@NonNull RemoteContext context, int theme) {
        context.clearLastOpCount();
        context.getPaintContext().clearNeedsRepaint();
        context.loadFloat(27, context.getDensity());
        context.mMode = RemoteContext.ContextMode.UNSET;
        context.setTheme(-1);
        context.mRemoteComposeState = this.mRemoteComposeState;
        context.mRemoteComposeState.setContext(context);
        if (this.mContentSizing == 2) {
            this.computeScale(context.mWidth, context.mHeight, this.mScaleOutput);
            float sw = this.mScaleOutput[0];
            float sh = this.mScaleOutput[1];
            this.computeTranslate(context.mWidth, context.mHeight, sw, sh, this.mTranslateOutput);
            context.mPaintContext.translate(this.mTranslateOutput[0], this.mTranslateOutput[1]);
            context.mPaintContext.scale(sw, sh);
        } else {
            this.setWidth((int)context.mWidth);
            this.setHeight((int)context.mHeight);
        }
        this.mTimeVariables.updateTime(context);
        this.mRepaintNext = context.updateOps();
        if (this.mRootLayoutComponent != null) {
            if (context.mWidth != this.mRootLayoutComponent.getWidth() || context.mHeight != this.mRootLayoutComponent.getHeight()) {
                this.mRootLayoutComponent.invalidateMeasure();
            }
            if (this.mRootLayoutComponent.needsMeasure()) {
                this.mRootLayoutComponent.layout(context);
            }
            if (this.mRootLayoutComponent.needsBoundsAnimation()) {
                this.mRepaintNext = 1;
                this.mRootLayoutComponent.clearNeedsBoundsAnimation();
                this.mRootLayoutComponent.animatingBounds(context);
            }
            if (this.mRootLayoutComponent.doesNeedsRepaint()) {
                this.mRepaintNext = 1;
            }
        }
        context.mMode = RemoteContext.ContextMode.PAINT;
        for (int i = 0; i < this.mOperations.size(); ++i) {
            boolean opIsDirty;
            Operation op = this.mOperations.get(i);
            boolean apply = true;
            if (theme != -1) {
                int currentTheme = context.getTheme();
                boolean bl = apply = currentTheme == theme || currentTheme == -1 || op instanceof Theme;
            }
            if (!apply || !(opIsDirty = op.isDirty()) && !(op instanceof PaintOperation)) continue;
            if (opIsDirty && op instanceof VariableSupport) {
                op.markNotDirty();
                ((VariableSupport)((Object)op)).updateVariables(context);
            }
            context.incrementOpCount();
            op.apply(context);
        }
        if (context.getPaintContext().doesNeedsRepaint() || this.mRootLayoutComponent != null && this.mRootLayoutComponent.doesNeedsRepaint()) {
            this.mRepaintNext = 1;
        }
        context.mMode = RemoteContext.ContextMode.UNSET;
        this.mLastOpCount = context.getLastOpCount();
    }

    public int getNumberOfOps() {
        int count = this.mOperations.size();
        for (Operation mOperation : this.mOperations) {
            if (!(mOperation instanceof Component)) continue;
            count += this.getChildOps((Component)mOperation);
        }
        return count;
    }

    private int getChildOps(@NonNull Component base) {
        int count = base.mList.size();
        for (Operation mOperation : base.mList) {
            if (!(mOperation instanceof Component)) continue;
            int mult = 1;
            if (mOperation instanceof LoopOperation) {
                mult = ((LoopOperation)mOperation).estimateIterations();
            }
            count += mult * this.getChildOps((Component)mOperation);
        }
        return count;
    }

    @NonNull
    public String[] getStats() {
        ArrayList<String> ret = new ArrayList<String>();
        WireBuffer buffer = new WireBuffer();
        int count = this.mOperations.size();
        HashMap<String, int[]> map = new HashMap<String, int[]>();
        for (Operation mOperation : this.mOperations) {
            Container com;
            int[] values;
            Class<?> c = mOperation.getClass();
            if (map.containsKey(c.getSimpleName())) {
                values = (int[])map.get(c.getSimpleName());
            } else {
                values = new int[2];
                map.put(c.getSimpleName(), values);
            }
            values[0] = values[0] + 1;
            values[1] = values[1] + this.sizeOfComponent(mOperation, buffer);
            if (mOperation instanceof Container) {
                com = (Container)((Object)mOperation);
                count += this.addChildren(com, map, buffer);
                continue;
            }
            if (!(mOperation instanceof LoopOperation)) continue;
            com = (LoopOperation)mOperation;
            count += this.addChildren(com, map, buffer);
        }
        ret.add(0, "number of operations : " + count);
        for (String s : map.keySet()) {
            int[] v = (int[])map.get(s);
            ret.add(s + " : " + v[0] + ":" + v[1]);
        }
        return ret.toArray(new String[0]);
    }

    private int sizeOfComponent(@NonNull Operation com, @NonNull WireBuffer tmp) {
        tmp.reset(100);
        com.write(tmp);
        int size = tmp.getSize();
        tmp.reset(100);
        return size;
    }

    private int addChildren(@NonNull Container base, @NonNull HashMap<String, int[]> map, @NonNull WireBuffer tmp) {
        int count = base.getList().size();
        for (Operation mOperation : base.getList()) {
            int[] values;
            Class<?> c = mOperation.getClass();
            if (map.containsKey(c.getSimpleName())) {
                values = map.get(c.getSimpleName());
            } else {
                values = new int[2];
                map.put(c.getSimpleName(), values);
            }
            values[0] = values[0] + 1;
            values[1] = values[1] + this.sizeOfComponent(mOperation, tmp);
            if (!(mOperation instanceof Container)) continue;
            count += this.addChildren((Container)((Object)mOperation), map, tmp);
        }
        return count;
    }

    @NonNull
    public String toNestedString() {
        StringBuilder ret = new StringBuilder();
        for (Operation mOperation : this.mOperations) {
            ret.append(mOperation.toString());
            ret.append("\n");
            if (!(mOperation instanceof Container)) continue;
            this.toNestedString((Container)((Object)mOperation), ret, "  ");
        }
        return ret.toString();
    }

    private void toNestedString(@NonNull Container base, @NonNull StringBuilder ret, String indent) {
        for (Operation mOperation : base.getList()) {
            for (String line : mOperation.toString().split("\n")) {
                ret.append(indent);
                ret.append(line);
                ret.append("\n");
            }
            if (!(mOperation instanceof Container)) continue;
            this.toNestedString((Container)((Object)mOperation), ret, indent + "  ");
        }
    }

    @NonNull
    public List<Operation> getOperations() {
        return this.mOperations;
    }

    public void checkShaders(RemoteContext context, ShaderControl ctl) {
        this.checkShaders(context, ctl, this.mOperations);
    }

    private void checkShaders(RemoteContext context, ShaderControl ctl, List<Operation> operations) {
        for (Operation op : operations) {
            if (op instanceof TextData) {
                op.apply(context);
            }
            if (op instanceof Container) {
                this.checkShaders(context, ctl, ((Container)((Object)op)).getList());
            }
            if (!(op instanceof ShaderData)) continue;
            ShaderData sd = (ShaderData)op;
            int id2 = sd.getShaderTextId();
            String str = context.getText(id2);
            sd.enable(ctl.isShaderValid(str));
        }
    }

    public void setUpdateDoc(boolean isUpdateDoc) {
        this.mIsUpdateDoc = isUpdateDoc;
    }

    public boolean isUpdateDoc() {
        return this.mIsUpdateDoc;
    }

    static class Version {
        public final int major;
        public final int minor;
        public final int patchLevel;

        Version(int major, int minor, int patchLevel) {
            this.major = major;
            this.minor = minor;
            this.patchLevel = patchLevel;
        }

        public boolean supportsVersion(int major, int minor, int patch) {
            if (major > this.major) {
                return false;
            }
            if (major < this.major) {
                return true;
            }
            if (minor > this.minor) {
                return false;
            }
            if (minor < this.minor) {
                return true;
            }
            return patch <= this.patchLevel;
        }
    }

    private static interface Visitor {
        public void visit(Operation var1);
    }

    public static interface HapticEngine {
        public void haptic(int var1);
    }

    public static interface ActionCallback {
        public void onAction(@NonNull String var1, Object var2);
    }

    public static class ClickAreaRepresentation {
        int mId;
        @Nullable
        final String mContentDescription;
        float mLeft;
        float mTop;
        float mRight;
        float mBottom;
        @Nullable
        final String mMetadata;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClickAreaRepresentation)) {
                return false;
            }
            ClickAreaRepresentation that = (ClickAreaRepresentation)o;
            return this.mId == that.mId && Objects.equals(this.mContentDescription, that.mContentDescription) && Objects.equals(this.mMetadata, that.mMetadata);
        }

        public int hashCode() {
            return Objects.hash(this.mId, this.mContentDescription, this.mMetadata);
        }

        public ClickAreaRepresentation(int id2, @Nullable String contentDescription, float left, float top, float right, float bottom, @Nullable String metadata) {
            this.mId = id2;
            this.mContentDescription = contentDescription;
            this.mLeft = left;
            this.mTop = top;
            this.mRight = right;
            this.mBottom = bottom;
            this.mMetadata = metadata;
        }

        public boolean contains(float x, float y) {
            return x >= this.mLeft && x < this.mRight && y >= this.mTop && y < this.mBottom;
        }

        public float getLeft() {
            return this.mLeft;
        }

        public float getTop() {
            return this.mTop;
        }

        public float width() {
            return Math.max(0.0f, this.mRight - this.mLeft);
        }

        public float height() {
            return Math.max(0.0f, this.mBottom - this.mTop);
        }

        public int getId() {
            return this.mId;
        }

        @Nullable
        public String getContentDescription() {
            return this.mContentDescription;
        }

        @Nullable
        public String getMetadata() {
            return this.mMetadata;
        }
    }

    public static interface IdActionCallback {
        public void onAction(int var1, @Nullable String var2);
    }

    public static interface ShaderControl {
        public boolean isShaderValid(String var1);
    }
}

