/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.accessibility;

import android.graphics.Rect;
import android.view.View;
import android.view.accessibility.AccessibilityNodeInfo;
import com.android.internal.widget.remotecompose.accessibility.BaseSemanticNodeApplier;
import com.android.internal.widget.remotecompose.core.semantics.ScrollableComponent;
import java.util.List;

public class AndroidPlatformSemanticNodeApplier
extends BaseSemanticNodeApplier<AccessibilityNodeInfo> {
    private static final String ROLE_DESCRIPTION_KEY = "AccessibilityNodeInfo.roleDescription";
    private final View mPlayer;

    public AndroidPlatformSemanticNodeApplier(View player) {
        this.mPlayer = player;
    }

    @Override
    protected void setClickable(AccessibilityNodeInfo nodeInfo, boolean clickable) {
        nodeInfo.setClickable(clickable);
        if (clickable) {
            nodeInfo.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_CLICK);
        } else {
            nodeInfo.removeAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_CLICK);
        }
    }

    @Override
    protected void setEnabled(AccessibilityNodeInfo nodeInfo, boolean enabled) {
        nodeInfo.setEnabled(enabled);
    }

    @Override
    protected CharSequence getStateDescription(AccessibilityNodeInfo nodeInfo) {
        return nodeInfo.getStateDescription();
    }

    @Override
    protected void setStateDescription(AccessibilityNodeInfo nodeInfo, CharSequence description) {
        nodeInfo.setStateDescription(description);
    }

    @Override
    protected void setRoleDescription(AccessibilityNodeInfo nodeInfo, String description) {
        nodeInfo.getExtras().putCharSequence(ROLE_DESCRIPTION_KEY, description);
    }

    @Override
    protected CharSequence getText(AccessibilityNodeInfo nodeInfo) {
        return nodeInfo.getText();
    }

    @Override
    protected void setText(AccessibilityNodeInfo nodeInfo, CharSequence text) {
        nodeInfo.setText(text);
    }

    @Override
    protected CharSequence getContentDescription(AccessibilityNodeInfo nodeInfo) {
        return nodeInfo.getContentDescription();
    }

    @Override
    protected void setContentDescription(AccessibilityNodeInfo nodeInfo, CharSequence description) {
        nodeInfo.setContentDescription(description);
    }

    @Override
    protected void setBoundsInScreen(AccessibilityNodeInfo nodeInfo, Rect bounds) {
        nodeInfo.setBoundsInParent(new Rect(0, 0, 1, 1));
        nodeInfo.setBoundsInScreen(bounds);
    }

    @Override
    protected void setUniqueId(AccessibilityNodeInfo nodeInfo, String id2) {
        nodeInfo.setUniqueId(id2);
        nodeInfo.setSource(this.mPlayer, Integer.parseInt(id2));
    }

    @Override
    protected void applyScrollable(AccessibilityNodeInfo nodeInfo, ScrollableComponent.ScrollAxisRange scrollAxis, int scrollDirection) {
        nodeInfo.setScrollable(true);
        nodeInfo.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_TO_POSITION);
        nodeInfo.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SET_PROGRESS);
        nodeInfo.setGranularScrollingSupported(true);
        if (scrollAxis.canScrollForward()) {
            nodeInfo.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_FORWARD);
            if (scrollDirection == 2) {
                nodeInfo.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_DOWN);
                nodeInfo.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_PAGE_DOWN);
            } else if (scrollDirection == 1) {
                nodeInfo.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_RIGHT);
                nodeInfo.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_PAGE_RIGHT);
            }
        }
        if (scrollAxis.canScrollBackwards()) {
            nodeInfo.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_BACKWARD);
            if (scrollDirection == 2) {
                nodeInfo.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_UP);
                nodeInfo.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_PAGE_UP);
            } else if (scrollDirection == 1) {
                nodeInfo.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_LEFT);
                nodeInfo.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_PAGE_LEFT);
            }
        }
        if (scrollDirection == 1) {
            nodeInfo.setCollectionInfo(AccessibilityNodeInfo.CollectionInfo.obtain(1, -1, false));
            nodeInfo.setClassName("android.widget.HorizontalScrollView");
        } else {
            nodeInfo.setCollectionInfo(AccessibilityNodeInfo.CollectionInfo.obtain(-1, 1, false));
            nodeInfo.setClassName("android.widget.ScrollView");
        }
        if (scrollDirection == 1) {
            nodeInfo.setClassName("android.widget.HorizontalScrollView");
        } else {
            nodeInfo.setCollectionInfo(AccessibilityNodeInfo.CollectionInfo.obtain(-1, 1, false));
            nodeInfo.setClassName("android.widget.ScrollView");
        }
    }

    @Override
    protected void applyListItem(AccessibilityNodeInfo nodeInfo, int parentId) {
        nodeInfo.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SHOW_ON_SCREEN);
        nodeInfo.setScreenReaderFocusable(true);
        nodeInfo.setFocusable(true);
        nodeInfo.setParent(this.mPlayer, parentId);
        nodeInfo.setCollectionItemInfo(AccessibilityNodeInfo.CollectionItemInfo.obtain(1, 1, 0, 1, false));
    }

    @Override
    public void addChildren(AccessibilityNodeInfo nodeInfo, List<Integer> childIds) {
        for (int id2 : childIds) {
            nodeInfo.addChild(this.mPlayer, id2);
        }
    }
}

