/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Trace;
import android.os._Original_Build;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RemoteViews;
import com.android.internal.hidden_from_bootclasspath.android.widget.flags.Flags;
import java.util.ArrayList;
import java.util.List;

@RemoteViews.RemoteView
public class NotificationOptimizedLinearLayout
extends LinearLayout {
    private static final boolean DEBUG_LAYOUT = false;
    private static final boolean TRACE_ONMEASURE = _Original_Build.isDebuggable();
    private static final String TAG = "NotifOptimizedLinearLayout";
    private boolean mShouldUseOptimizedLayout = false;

    public NotificationOptimizedLinearLayout(Context context) {
        super(context);
    }

    public NotificationOptimizedLinearLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public NotificationOptimizedLinearLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public NotificationOptimizedLinearLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        View weightedChildView = this.getSingleWeightedChild();
        boolean bl = this.mShouldUseOptimizedLayout = this.isUseOptimizedLinearLayoutFlagEnabled() && weightedChildView != null && this.isOptimizationPossible(widthMeasureSpec, heightMeasureSpec);
        if (this.mShouldUseOptimizedLayout) {
            this.onMeasureOptimized(weightedChildView, widthMeasureSpec, heightMeasureSpec);
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    private boolean isUseOptimizedLinearLayoutFlagEnabled() {
        boolean enabled = Flags.notifLinearlayoutOptimized();
        if (!enabled) {
            this.logSkipOptimizedOnMeasure("enableNotifLinearlayoutOptimized flag is off.");
        }
        return enabled;
    }

    private boolean isOptimizationPossible(int widthMeasureSpec, int heightMeasureSpec) {
        boolean isHorizontal;
        boolean hasWeightSum;
        boolean bl = hasWeightSum = this.getWeightSum() > 0.0f;
        if (hasWeightSum) {
            this.logSkipOptimizedOnMeasure("Has weightSum.");
            return false;
        }
        if (this.requiresMatchParentRemeasureForVerticalLinearLayout(widthMeasureSpec)) {
            this.logSkipOptimizedOnMeasure("Vertical LinearLayout requires children width MATCH_PARENT remeasure ");
            return false;
        }
        boolean bl2 = isHorizontal = this.getOrientation() == 0;
        if (isHorizontal && View.MeasureSpec.getMode(widthMeasureSpec) != 0x40000000) {
            this.logSkipOptimizedOnMeasure("Horizontal LinearLayout's width should be measured EXACTLY");
            return false;
        }
        if (this.requiresBaselineAlignmentForHorizontalLinearLayout()) {
            this.logSkipOptimizedOnMeasure("Need to apply baseline.");
            return false;
        }
        if (this.requiresNegativeMarginHandlingForHorizontalLinearLayout()) {
            this.logSkipOptimizedOnMeasure("Need to handle negative margins.");
            return false;
        }
        return true;
    }

    private boolean requiresNegativeMarginHandlingForHorizontalLinearLayout() {
        if (this.getOrientation() == 1) {
            return false;
        }
        List<View> activeChildren = this.getActiveChildren();
        for (int i = 0; i < activeChildren.size(); ++i) {
            View child = activeChildren.get(i);
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
            if (lp.leftMargin >= 0 && lp.rightMargin >= 0) continue;
            return true;
        }
        return false;
    }

    private boolean requiresMatchParentRemeasureForVerticalLinearLayout(int widthMeasureSpec) {
        if (this.getOrientation() == 0) {
            return false;
        }
        boolean nonExactWidth = View.MeasureSpec.getMode(widthMeasureSpec) != 0x40000000;
        List<View> activeChildren = this.getActiveChildren();
        for (int i = 0; i < activeChildren.size(); ++i) {
            View child = activeChildren.get(i);
            ViewGroup.LayoutParams lp = child.getLayoutParams();
            if (!nonExactWidth || lp.width != -1) continue;
            return true;
        }
        return false;
    }

    private boolean requiresBaselineAlignmentForHorizontalLinearLayout() {
        if (this.getOrientation() == 1) {
            return false;
        }
        if (!this.isBaselineAligned()) {
            return false;
        }
        List<View> activeChildren = this.getActiveChildren();
        int minorGravity = this.getGravity() & 0x70;
        for (int i = 0; i < activeChildren.size(); ++i) {
            int result;
            View child = activeChildren.get(i);
            if (!(child.getLayoutParams() instanceof LinearLayout.LayoutParams)) continue;
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)child.getLayoutParams();
            int childBaseline = -1;
            if (lp.height != -1) {
                childBaseline = child.getBaseline();
            }
            if (childBaseline == -1) continue;
            int gravity = lp.gravity;
            if (gravity < 0) {
                gravity = minorGravity;
            }
            if ((result = gravity & 0x70) != 48 && result != 80) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private View getSingleWeightedChild() {
        boolean isVertical = this.getOrientation() == 1;
        List<View> activeChildren = this.getActiveChildren();
        View singleWeightedChild = null;
        for (int i = 0; i < activeChildren.size(); ++i) {
            View child = activeChildren.get(i);
            if (!(child.getLayoutParams() instanceof LinearLayout.LayoutParams)) continue;
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)child.getLayoutParams();
            if (!isVertical && lp.width == -1 || isVertical && lp.height == -1) {
                this.logSkipOptimizedOnMeasure("There is a match parent child in the related orientation.");
                return null;
            }
            if (lp.weight == 0.0f) continue;
            if (singleWeightedChild == null) {
                singleWeightedChild = child;
                continue;
            }
            this.logSkipOptimizedOnMeasure("There is more than one weighted child.");
            return null;
        }
        if (singleWeightedChild == null) {
            this.logSkipOptimizedOnMeasure("There is no weighted child in this layout.");
        } else {
            boolean isWidthWrapContentOrZero;
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)singleWeightedChild.getLayoutParams();
            boolean isHeightWrapContentOrZero = lp.height == -2 || lp.height == 0;
            boolean bl = isWidthWrapContentOrZero = lp.width == -2 || lp.width == 0;
            if (isVertical && !isHeightWrapContentOrZero || !isVertical && !isWidthWrapContentOrZero) {
                this.logSkipOptimizedOnMeasure("Single weighted child should be either WRAP_CONTENT or 0 in the related orientation");
                singleWeightedChild = null;
            }
        }
        return singleWeightedChild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMeasureOptimized(@NonNull View weightedChildView, int widthMeasureSpec, int heightMeasureSpec) {
        try {
            if (TRACE_ONMEASURE) {
                Trace.beginSection("NotifOptimizedLinearLayout#onMeasure");
            }
            if (this.getOrientation() == 0) {
                ViewGroup.LayoutParams lp = weightedChildView.getLayoutParams();
                int childWidth = lp.width;
                boolean isBaselineAligned = this.isBaselineAligned();
                lp.width = 0;
                this.setBaselineAligned(false);
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                lp.width = childWidth;
                this.setBaselineAligned(isBaselineAligned);
            } else {
                this.measureVerticalOptimized(weightedChildView, widthMeasureSpec, heightMeasureSpec);
            }
        }
        finally {
            if (TRACE_ONMEASURE) {
                this.trackShouldUseOptimizedLayout();
                Trace.endSection();
            }
        }
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.mShouldUseOptimizedLayout) {
            this.onLayoutOptimized(changed, l, t, r, b);
        } else {
            super.onLayout(changed, l, t, r, b);
        }
    }

    private void onLayoutOptimized(boolean changed, int l, int t, int r, int b) {
        if (this.getOrientation() == 0) {
            super.onLayout(changed, l, t, r, b);
        } else {
            this.layoutVerticalOptimized(l, t, r, b);
        }
    }

    private void measureVerticalOptimized(@NonNull View weightedChildView, int widthMeasureSpec, int heightMeasureSpec) {
        int childHeightMeasureSpec;
        int childHeightMeasureMode;
        int totalLength = 0;
        int maxWidth = 0;
        int availableHeight = View.MeasureSpec.getSize(heightMeasureSpec);
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (child == null || child.getVisibility() == 8) continue;
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
            if (child == weightedChildView) {
                if (lp.height != 0 || heightMode != 0x40000000) continue;
                totalLength = Math.max(totalLength, totalLength + lp.topMargin + lp.bottomMargin);
                continue;
            }
            this.measureChildWithMargins(child, widthMeasureSpec, 0, heightMeasureSpec, 0);
            totalLength = Math.max(totalLength, totalLength + child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin);
            maxWidth = Math.max(maxWidth, child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin);
        }
        totalLength += this.mPaddingTop + this.mPaddingBottom;
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)weightedChildView.getLayoutParams();
        int n = childHeightMeasureMode = heightMode == 0x40000000 ? 0x40000000 : Integer.MIN_VALUE;
        if (lp.height == 0 && heightMode == 0x40000000) {
            childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec(Math.max(0, availableHeight - totalLength), childHeightMeasureMode);
        } else {
            int usedHeight = lp.topMargin + lp.bottomMargin + totalLength;
            childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec(Math.max(0, availableHeight - usedHeight), childHeightMeasureMode);
        }
        int childWidthMeasureSpec = NotificationOptimizedLinearLayout.getChildMeasureSpec(widthMeasureSpec, this.mPaddingLeft + this.mPaddingRight + lp.leftMargin + lp.rightMargin, lp.width);
        weightedChildView.measure(childWidthMeasureSpec, childHeightMeasureSpec);
        totalLength = Math.max(totalLength, totalLength + weightedChildView.getMeasuredHeight() + lp.topMargin + lp.bottomMargin);
        maxWidth = Math.max(maxWidth, weightedChildView.getMeasuredWidth() + lp.leftMargin + lp.rightMargin);
        int finalWidth = NotificationOptimizedLinearLayout.resolveSizeAndState(Math.max(maxWidth += this.getPaddingLeft() + this.getPaddingRight(), this.getSuggestedMinimumWidth()), widthMeasureSpec, 0);
        int finalHeight = NotificationOptimizedLinearLayout.resolveSizeAndState(Math.max(totalLength, this.getSuggestedMinimumHeight()), heightMeasureSpec, 0);
        this.setMeasuredDimension(finalWidth, finalHeight);
    }

    @NonNull
    private List<View> getActiveChildren() {
        int childCount = this.getChildCount();
        ArrayList<View> activeChildren = new ArrayList<View>();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (child == null || child.getVisibility() == 8) continue;
            activeChildren.add(child);
        }
        return activeChildren;
    }

    private void layoutVerticalOptimized(int left, int top, int right, int bottom) {
        int childTop;
        int paddingLeft = this.mPaddingLeft;
        int mTotalLength = this.getMeasuredHeight();
        int width = right - left;
        int childRight = width - this.mPaddingRight;
        int childSpace = width - paddingLeft - this.mPaddingRight;
        int count = this.getChildCount();
        int majorGravity = this.getGravity() & 0x70;
        int minorGravity = this.getGravity() & 0x800007;
        switch (majorGravity) {
            case 80: {
                childTop = this.mPaddingTop + bottom - top - mTotalLength;
                break;
            }
            case 16: {
                childTop = this.mPaddingTop + (bottom - top - mTotalLength) / 2;
                break;
            }
            default: {
                childTop = this.mPaddingTop;
            }
        }
        int dividerHeight = this.getDividerHeight();
        for (int i = 0; i < count; ++i) {
            int childLeft;
            View child = this.getChildAt(i);
            if (child == null || child.getVisibility() == 8) continue;
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)child.getLayoutParams();
            int gravity = lp.gravity;
            if (gravity < 0) {
                gravity = minorGravity;
            }
            int layoutDirection = this.getLayoutDirection();
            int absoluteGravity = Gravity.getAbsoluteGravity(gravity, layoutDirection);
            switch (absoluteGravity & 7) {
                case 1: {
                    childLeft = paddingLeft + (childSpace - childWidth) / 2 + lp.leftMargin - lp.rightMargin;
                    break;
                }
                case 5: {
                    childLeft = childRight - childWidth - lp.rightMargin;
                    break;
                }
                default: {
                    childLeft = paddingLeft + lp.leftMargin;
                }
            }
            if (this.hasDividerBeforeChildAt(i)) {
                childTop += dividerHeight;
            }
            child.layout(childLeft, childTop += lp.topMargin, childLeft + childWidth, childTop + childHeight);
            childTop += childHeight + lp.bottomMargin;
        }
    }

    private int getDividerHeight() {
        Drawable dividerDrawable = this.getDividerDrawable();
        if (dividerDrawable == null) {
            return 0;
        }
        return dividerDrawable.getIntrinsicHeight();
    }

    private void trackShouldUseOptimizedLayout() {
        if (TRACE_ONMEASURE) {
            Trace.setCounter("NotifOptimizedLinearLayout#shouldUseOptimizedLayout", this.mShouldUseOptimizedLayout ? 1L : 0L);
        }
    }

    private void logSkipOptimizedOnMeasure(String reason) {
    }
}

