/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.annotation.NonNull;
import android.os.AsyncTask;
import android.os.Process;
import android.util.Log;
import com.android.internal.hidden_from_bootclasspath.com.android.internal.widget.flags.Flags;
import com.android.internal.widget.LockPatternUtils;
import com.android.internal.widget.LockscreenCredential;
import com.android.internal.widget.VerifyCredentialResponse;

public class LockPatternChecker {
    private static final String TAG = "LockPatternChecker";
    private static final int INVALID_PRIORITY = -21;

    public static AsyncTask<?, ?, ?> verifyCredential(final LockPatternUtils utils, LockscreenCredential credential, final int userId, final int flags, final OnVerifyCallback callback) {
        final LockscreenCredential credentialCopy = credential.duplicate();
        AsyncTask<Void, Void, VerifyCredentialResponse> task = new AsyncTask<Void, Void, VerifyCredentialResponse>(){

            protected VerifyCredentialResponse doInBackground(Void ... args) {
                return utils.verifyCredential(credentialCopy, userId, flags);
            }

            @Override
            protected void onPostExecute(@NonNull VerifyCredentialResponse result) {
                callback.onVerified(result, result.getTimeout());
                credentialCopy.zeroize();
            }

            @Override
            protected void onCancelled() {
                credentialCopy.zeroize();
            }
        };
        task.execute(new Void[0]);
        return task;
    }

    public static AsyncTask<?, ?, ?> checkCredential(final LockPatternUtils utils, LockscreenCredential credential, final int userId, final OnCheckCallback callback) {
        final LockscreenCredential credentialCopy = credential.duplicate();
        AsyncTask<Void, Void, Boolean> task = new AsyncTask<Void, Void, Boolean>(){
            private int mThrottleTimeout;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Boolean doInBackground(Void ... args) {
                int originalPriority = -21;
                try {
                    if (Flags.runCheckCredentialWithHigherPriority()) {
                        originalPriority = Process.getThreadPriority(Process.myTid());
                        try {
                            Process.setThreadPriority(-2);
                        }
                        catch (SecurityException e) {
                            Log.e(LockPatternChecker.TAG, "Failed to boost checkCredential thread priority to priority display", e);
                        }
                    }
                    Boolean e = utils.checkCredential(credentialCopy, userId, callback::onEarlyMatched);
                    return e;
                }
                catch (LockPatternUtils.RequestThrottledException ex) {
                    this.mThrottleTimeout = ex.getTimeoutMs();
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    if (Flags.runCheckCredentialWithHigherPriority() && originalPriority != -21) {
                        try {
                            Process.setThreadPriority(originalPriority);
                        }
                        catch (SecurityException e) {
                            Log.e(LockPatternChecker.TAG, "Failed to restore checkCredential thread priority to original priority", e);
                        }
                    }
                }
            }

            @Override
            protected void onPostExecute(Boolean result) {
                callback.onChecked(result, this.mThrottleTimeout);
                credentialCopy.zeroize();
            }

            @Override
            protected void onCancelled() {
                callback.onCancelled();
                credentialCopy.zeroize();
            }
        };
        task.execute(new Void[0]);
        return task;
    }

    public static AsyncTask<?, ?, ?> verifyTiedProfileChallenge(final LockPatternUtils utils, LockscreenCredential credential, final int userId, final int flags, final OnVerifyCallback callback) {
        final LockscreenCredential credentialCopy = credential.duplicate();
        AsyncTask<Void, Void, VerifyCredentialResponse> task = new AsyncTask<Void, Void, VerifyCredentialResponse>(){

            protected VerifyCredentialResponse doInBackground(Void ... args) {
                return utils.verifyTiedProfileChallenge(credentialCopy, userId, flags);
            }

            @Override
            protected void onPostExecute(@NonNull VerifyCredentialResponse response) {
                callback.onVerified(response, response.getTimeout());
                credentialCopy.zeroize();
            }

            @Override
            protected void onCancelled() {
                credentialCopy.zeroize();
            }
        };
        task.execute(new Void[0]);
        return task;
    }

    public static interface OnVerifyCallback {
        public void onVerified(@NonNull VerifyCredentialResponse var1, int var2);
    }

    public static interface OnCheckCallback {
        default public void onEarlyMatched() {
        }

        public void onChecked(boolean var1, int var2);

        default public void onCancelled() {
        }
    }
}

