/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.ActivityManager;
import android.content.Context;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.util.AttributeSet;
import android.util.Log;
import android.view.RemotableViewMethod;
import android.widget.ImageView;
import android.widget.RemoteViews;
import com.android.internal.hidden_from_bootclasspath.android.widget.flags.Flags;
import com.android.internal.widget.LocalImageResolver;
import com.android.internal.widget.NotificationDrawableConsumer;
import com.android.internal.widget.NotificationIconManager;

@RemoteViews.RemoteView
public class BigPictureNotificationImageView
extends ImageView
implements NotificationDrawableConsumer {
    private static final String TAG = BigPictureNotificationImageView.class.getSimpleName();
    private final int mMaximumDrawableWidth;
    private final int mMaximumDrawableHeight;
    private NotificationIconManager mIconManager;

    public BigPictureNotificationImageView(@NonNull Context context) {
        this(context, null, 0, 0);
    }

    public BigPictureNotificationImageView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 0);
    }

    public BigPictureNotificationImageView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public BigPictureNotificationImageView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        boolean isLowRam = ActivityManager.isLowRamDeviceStatic();
        this.mMaximumDrawableWidth = context.getResources().getDimensionPixelSize(isLowRam ? 17105571 : 17105570);
        this.mMaximumDrawableHeight = context.getResources().getDimensionPixelSize(isLowRam ? 17105569 : 17105568);
    }

    public void setIconManager(NotificationIconManager iconManager) {
        this.mIconManager = iconManager;
    }

    @Override
    @RemotableViewMethod(asyncImpl="setImageURIAsync")
    public void setImageURI(@Nullable Uri uri) {
        this.setImageDrawable(this.loadImage(uri));
    }

    @Override
    public Runnable setImageURIAsync(@Nullable Uri uri) {
        Drawable drawable2 = this.loadImage(uri);
        return () -> this.setImageDrawable(drawable2);
    }

    @Override
    @RemotableViewMethod(asyncImpl="setImageIconAsync")
    public void setImageIcon(@Nullable Icon icon) {
        if (this.mIconManager != null) {
            this.mIconManager.updateIcon(this, icon).run();
            return;
        }
        this.setImageDrawable(this.loadImage(icon));
    }

    @Override
    public Runnable setImageIconAsync(@Nullable Icon icon) {
        if (this.mIconManager != null) {
            return this.mIconManager.updateIcon(this, icon);
        }
        Drawable drawable2 = this.loadImage(icon);
        return () -> this.setImageDrawable(drawable2);
    }

    @Override
    public void setImageDrawable(@Nullable Drawable drawable2) {
        BitmapDrawable bitmapDrawable;
        if (drawable2 instanceof BitmapDrawable && (bitmapDrawable = (BitmapDrawable)drawable2).getBitmap() == null) {
            if (Flags.bigPictureStyleDiscardEmptyIconBitmapDrawables()) {
                Log.e(TAG, "discarding BitmapDrawable with null Bitmap (invalid image file?)");
                drawable2 = null;
            } else {
                Log.e(TAG, "setting BitmapDrawable with null Bitmap (invalid image file?)");
            }
        }
        super.setImageDrawable(drawable2);
    }

    private Drawable loadImage(Uri uri) {
        if (uri == null) {
            return null;
        }
        return LocalImageResolver.resolveImage(uri, this.mContext, this.mMaximumDrawableWidth, this.mMaximumDrawableHeight);
    }

    private Drawable loadImage(Icon icon) {
        if (icon == null) {
            return null;
        }
        Drawable drawable2 = LocalImageResolver.resolveImage(icon, this.mContext, this.mMaximumDrawableWidth, this.mMaximumDrawableHeight);
        if (drawable2 != null) {
            return drawable2;
        }
        drawable2 = icon.loadDrawable(this.mContext);
        if (drawable2 != null) {
            return drawable2;
        }
        Log.e(TAG, "Couldn't load drawable for icon: " + icon);
        return null;
    }
}

