/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.inline;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.SurfaceControlViewHost;

public interface IInlineContentCallback
extends IInterface {
    public static final String DESCRIPTOR = "com.android.internal.view.inline.IInlineContentCallback";

    public void onContent(SurfaceControlViewHost.SurfacePackage var1, int var2, int var3) throws RemoteException;

    public void onClick() throws RemoteException;

    public void onLongClick() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IInlineContentCallback {
        static final int TRANSACTION_onContent = 1;
        static final int TRANSACTION_onClick = 2;
        static final int TRANSACTION_onLongClick = 3;

        public Stub() {
            this.attachInterface(this, IInlineContentCallback.DESCRIPTOR);
        }

        public static IInlineContentCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IInlineContentCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IInlineContentCallback) {
                return (IInlineContentCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onContent";
                }
                case 2: {
                    return "onClick";
                }
                case 3: {
                    return "onLongClick";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IInlineContentCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    SurfaceControlViewHost.SurfacePackage _arg0 = data.readTypedObject(SurfaceControlViewHost.SurfacePackage.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onContent(_arg0, _arg1, _arg2);
                    break;
                }
                case 2: {
                    this.onClick();
                    break;
                }
                case 3: {
                    this.onLongClick();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 2;
        }

        private static class Proxy
        implements IInlineContentCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IInlineContentCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onContent(SurfaceControlViewHost.SurfacePackage content, int width, int height) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInlineContentCallback.DESCRIPTOR);
                    _data.writeTypedObject(content, 0);
                    _data.writeInt(width);
                    _data.writeInt(height);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onClick() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInlineContentCallback.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onLongClick() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInlineContentCallback.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IInlineContentCallback {
        @Override
        public void onContent(SurfaceControlViewHost.SurfacePackage content, int width, int height) throws RemoteException {
        }

        @Override
        public void onClick() throws RemoteException {
        }

        @Override
        public void onLongClick() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

