/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.vibrator.persistence;

import android.annotation.NonNull;
import android.os.VibrationEffect;
import android.util.IntArray;
import android.util.LongArray;
import com.android.internal.vibrator.persistence.SerializedAmplitudeStepWaveform;
import com.android.internal.vibrator.persistence.SerializedComposedEffect;
import com.android.internal.vibrator.persistence.XmlConstants;
import com.android.internal.vibrator.persistence.XmlParserException;
import com.android.modules.utils.TypedXmlPullParser;
import com.android.modules.utils.TypedXmlSerializer;
import java.io.IOException;
import java.util.Arrays;

class SerializedWaveformEffectEntries
implements SerializedComposedEffect.SerializedSegment {
    @NonNull
    private final long[] mTimings;
    @NonNull
    private final int[] mAmplitudes;

    private SerializedWaveformEffectEntries(@NonNull long[] timings, @NonNull int[] amplitudes) {
        this.mTimings = timings;
        this.mAmplitudes = amplitudes;
    }

    @Override
    public void deserializeIntoComposition(@NonNull VibrationEffect.Composition composition) {
        composition.addEffect(VibrationEffect.createWaveform(this.mTimings, this.mAmplitudes, -1));
    }

    @Override
    public void write(@NonNull TypedXmlSerializer serializer) throws IOException {
        for (int i = 0; i < this.mTimings.length; ++i) {
            serializer.startTag(XmlConstants.NAMESPACE, "waveform-entry");
            if (this.mAmplitudes[i] == -1) {
                serializer.attribute(XmlConstants.NAMESPACE, "amplitude", "default");
            } else {
                serializer.attributeInt(XmlConstants.NAMESPACE, "amplitude", this.mAmplitudes[i]);
            }
            serializer.attributeLong(XmlConstants.NAMESPACE, "durationMs", this.mTimings[i]);
            serializer.endTag(XmlConstants.NAMESPACE, "waveform-entry");
        }
    }

    public String toString() {
        return "SerializedWaveformEffectEntries{timings=" + Arrays.toString(this.mTimings) + ", amplitudes=" + Arrays.toString(this.mAmplitudes) + '}';
    }

    static class Parser {
        Parser() {
        }

        public static void parseWaveformEntry(TypedXmlPullParser parser, Builder waveformBuilder) throws XmlParserException, IOException {
            SerializedAmplitudeStepWaveform.Parser.parseWaveformEntry(parser, waveformBuilder::addDurationAndAmplitude);
        }
    }

    static class Builder {
        private final LongArray mTimings = new LongArray();
        private final IntArray mAmplitudes = new IntArray();

        Builder() {
        }

        void addDurationAndAmplitude(long durationMs, int amplitude) {
            this.mTimings.add(durationMs);
            this.mAmplitudes.add(amplitude);
        }

        boolean hasNonZeroDuration() {
            for (int i = 0; i < this.mTimings.size(); ++i) {
                if (this.mTimings.get(i) <= 0L) continue;
                return true;
            }
            return false;
        }

        SerializedWaveformEffectEntries build() {
            return new SerializedWaveformEffectEntries(this.mTimings.toArray(), this.mAmplitudes.toArray());
        }
    }
}

