/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.SystemClock;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ObservableServiceConnection;
import java.util.concurrent.Executor;

public class PersistentServiceConnection<T>
extends ObservableServiceConnection<T> {
    private final ObservableServiceConnection.Callback<T> mConnectionCallback = new ObservableServiceConnection.Callback<T>(){
        private long mConnectedTime;

        @Override
        public void onConnected(ObservableServiceConnection<T> connection, T service) {
            this.mConnectedTime = PersistentServiceConnection.this.mInjector.uptimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDisconnected(ObservableServiceConnection<T> connection, int reason) {
            if (reason == 4) {
                return;
            }
            Object object = PersistentServiceConnection.this.mLock;
            synchronized (object) {
                if (PersistentServiceConnection.this.mInjector.uptimeMillis() - this.mConnectedTime > (long)PersistentServiceConnection.this.mMinConnectionDurationMs) {
                    PersistentServiceConnection.this.mReconnectAttempts = 0;
                    PersistentServiceConnection.this.bindInternalLocked();
                } else {
                    PersistentServiceConnection.this.scheduleConnectionAttemptLocked();
                }
            }
        }
    };
    private final Object mLock = new Object();
    private final Injector mInjector;
    private final Handler mHandler;
    private final int mMinConnectionDurationMs;
    private final int mMaxReconnectAttempts;
    private final int mBaseReconnectDelayMs;
    @GuardedBy(value={"mLock"})
    private int mReconnectAttempts;
    @GuardedBy(value={"mLock"})
    private Object mCancelToken;
    private final Runnable mConnectRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = PersistentServiceConnection.this.mLock;
            synchronized (object) {
                PersistentServiceConnection.this.mCancelToken = null;
                PersistentServiceConnection.this.bindInternalLocked();
            }
        }
    };

    public PersistentServiceConnection(Context context, Executor executor, Handler handler, ObservableServiceConnection.ServiceTransformer<T> transformer, Intent serviceIntent, int flags, int minConnectionDurationMs, int maxReconnectAttempts, int baseReconnectDelayMs) {
        this(context, executor, handler, transformer, serviceIntent, flags, minConnectionDurationMs, maxReconnectAttempts, baseReconnectDelayMs, new Injector());
    }

    @VisibleForTesting
    public PersistentServiceConnection(Context context, Executor executor, Handler handler, ObservableServiceConnection.ServiceTransformer<T> transformer, Intent serviceIntent, int flags, int minConnectionDurationMs, int maxReconnectAttempts, int baseReconnectDelayMs, Injector injector) {
        super(context, executor, transformer, serviceIntent, flags);
        this.mHandler = handler;
        this.mMinConnectionDurationMs = minConnectionDurationMs;
        this.mMaxReconnectAttempts = maxReconnectAttempts;
        this.mBaseReconnectDelayMs = baseReconnectDelayMs;
        this.mInjector = injector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean bind() {
        Object object = this.mLock;
        synchronized (object) {
            this.addCallback(this.mConnectionCallback);
            this.mReconnectAttempts = 0;
            return this.bindInternalLocked();
        }
    }

    @GuardedBy(value={"mLock"})
    private boolean bindInternalLocked() {
        return super.bind();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbind() {
        Object object = this.mLock;
        synchronized (object) {
            this.removeCallback(this.mConnectionCallback);
            this.cancelPendingConnectionAttemptLocked();
            super.unbind();
        }
    }

    @GuardedBy(value={"mLock"})
    private void cancelPendingConnectionAttemptLocked() {
        if (this.mCancelToken != null) {
            this.mHandler.removeCallbacksAndMessages(this.mCancelToken);
            this.mCancelToken = null;
        }
    }

    @GuardedBy(value={"mLock"})
    private void scheduleConnectionAttemptLocked() {
        this.cancelPendingConnectionAttemptLocked();
        if (this.mReconnectAttempts >= this.mMaxReconnectAttempts) {
            return;
        }
        long reconnectDelayMs = (long)Math.scalb(this.mBaseReconnectDelayMs, this.mReconnectAttempts);
        this.mCancelToken = new Object();
        this.mHandler.postDelayed(this.mConnectRunnable, this.mCancelToken, reconnectDelayMs);
        ++this.mReconnectAttempts;
    }

    @VisibleForTesting
    public static class Injector {
        public long uptimeMillis() {
            return SystemClock.uptimeMillis();
        }
    }
}

