/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.util.Slog;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class GcUtils {
    private static final String TAG = GcUtils.class.getSimpleName();

    public static void runGcAndFinalizersSync() {
        Runtime.getRuntime().gc();
        Runtime.getRuntime().runFinalization();
        CountDownLatch fence = new CountDownLatch(1);
        GcUtils.createFinalizationObserver(fence);
        try {
            do {
                Runtime.getRuntime().gc();
                Runtime.getRuntime().runFinalization();
            } while (!fence.await(100L, TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        Slog.v(TAG, "Running gc and finalizers");
    }

    private static void createFinalizationObserver(final CountDownLatch fence) {
        new Object(){

            protected void finalize() throws Throwable {
                try {
                    fence.countDown();
                }
                finally {
                    super.finalize();
                }
            }
        };
    }

    private GcUtils() {
    }
}

