/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.euicc;

import android.app.PendingIntent;
import android.content.Intent;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.telephony.euicc.DownloadableSubscription;
import android.telephony.euicc.EuiccInfo;
import java.util.ArrayList;
import java.util.List;

public interface IEuiccController
extends IInterface {
    public static final String DESCRIPTOR = "com.android.internal.telephony.euicc.IEuiccController";

    public void continueOperation(int var1, Intent var2, Bundle var3) throws RemoteException;

    public void getDownloadableSubscriptionMetadata(int var1, DownloadableSubscription var2, String var3, PendingIntent var4) throws RemoteException;

    public void getDefaultDownloadableSubscriptionList(int var1, String var2, PendingIntent var3) throws RemoteException;

    public String getEid(int var1, String var2) throws RemoteException;

    public int getOtaStatus(int var1) throws RemoteException;

    public void downloadSubscription(int var1, DownloadableSubscription var2, boolean var3, String var4, Bundle var5, PendingIntent var6) throws RemoteException;

    public EuiccInfo getEuiccInfo(int var1) throws RemoteException;

    public void deleteSubscription(int var1, int var2, String var3, PendingIntent var4) throws RemoteException;

    public void switchToSubscription(int var1, int var2, String var3, PendingIntent var4) throws RemoteException;

    public void switchToSubscriptionWithPort(int var1, int var2, int var3, String var4, PendingIntent var5) throws RemoteException;

    public void updateSubscriptionNickname(int var1, int var2, String var3, String var4, PendingIntent var5) throws RemoteException;

    public void eraseSubscriptions(int var1, PendingIntent var2) throws RemoteException;

    public void eraseSubscriptionsWithOptions(int var1, int var2, PendingIntent var3) throws RemoteException;

    public void retainSubscriptionsForFactoryReset(int var1, PendingIntent var2) throws RemoteException;

    public void setSupportedCountries(boolean var1, List<String> var2) throws RemoteException;

    public List<String> getSupportedCountries(boolean var1) throws RemoteException;

    public boolean isSupportedCountry(String var1) throws RemoteException;

    public boolean isSimPortAvailable(int var1, int var2, String var3) throws RemoteException;

    public boolean hasCarrierPrivilegesForPackageOnAnyPhone(String var1) throws RemoteException;

    public boolean isCompatChangeEnabled(String var1, long var2) throws RemoteException;

    public void setPsimConversionSupportedCarriers(int[] var1) throws RemoteException;

    public boolean isPsimConversionSupported(int var1) throws RemoteException;

    public long getAvailableMemoryInBytes(int var1, String var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IEuiccController {
        static final int TRANSACTION_continueOperation = 1;
        static final int TRANSACTION_getDownloadableSubscriptionMetadata = 2;
        static final int TRANSACTION_getDefaultDownloadableSubscriptionList = 3;
        static final int TRANSACTION_getEid = 4;
        static final int TRANSACTION_getOtaStatus = 5;
        static final int TRANSACTION_downloadSubscription = 6;
        static final int TRANSACTION_getEuiccInfo = 7;
        static final int TRANSACTION_deleteSubscription = 8;
        static final int TRANSACTION_switchToSubscription = 9;
        static final int TRANSACTION_switchToSubscriptionWithPort = 10;
        static final int TRANSACTION_updateSubscriptionNickname = 11;
        static final int TRANSACTION_eraseSubscriptions = 12;
        static final int TRANSACTION_eraseSubscriptionsWithOptions = 13;
        static final int TRANSACTION_retainSubscriptionsForFactoryReset = 14;
        static final int TRANSACTION_setSupportedCountries = 15;
        static final int TRANSACTION_getSupportedCountries = 16;
        static final int TRANSACTION_isSupportedCountry = 17;
        static final int TRANSACTION_isSimPortAvailable = 18;
        static final int TRANSACTION_hasCarrierPrivilegesForPackageOnAnyPhone = 19;
        static final int TRANSACTION_isCompatChangeEnabled = 20;
        static final int TRANSACTION_setPsimConversionSupportedCarriers = 21;
        static final int TRANSACTION_isPsimConversionSupported = 22;
        static final int TRANSACTION_getAvailableMemoryInBytes = 23;

        public Stub() {
            this.attachInterface(this, IEuiccController.DESCRIPTOR);
        }

        public static IEuiccController asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IEuiccController.DESCRIPTOR);
            if (iin != null && iin instanceof IEuiccController) {
                return (IEuiccController)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "continueOperation";
                }
                case 2: {
                    return "getDownloadableSubscriptionMetadata";
                }
                case 3: {
                    return "getDefaultDownloadableSubscriptionList";
                }
                case 4: {
                    return "getEid";
                }
                case 5: {
                    return "getOtaStatus";
                }
                case 6: {
                    return "downloadSubscription";
                }
                case 7: {
                    return "getEuiccInfo";
                }
                case 8: {
                    return "deleteSubscription";
                }
                case 9: {
                    return "switchToSubscription";
                }
                case 10: {
                    return "switchToSubscriptionWithPort";
                }
                case 11: {
                    return "updateSubscriptionNickname";
                }
                case 12: {
                    return "eraseSubscriptions";
                }
                case 13: {
                    return "eraseSubscriptionsWithOptions";
                }
                case 14: {
                    return "retainSubscriptionsForFactoryReset";
                }
                case 15: {
                    return "setSupportedCountries";
                }
                case 16: {
                    return "getSupportedCountries";
                }
                case 17: {
                    return "isSupportedCountry";
                }
                case 18: {
                    return "isSimPortAvailable";
                }
                case 19: {
                    return "hasCarrierPrivilegesForPackageOnAnyPhone";
                }
                case 20: {
                    return "isCompatChangeEnabled";
                }
                case 21: {
                    return "setPsimConversionSupportedCarriers";
                }
                case 22: {
                    return "isPsimConversionSupported";
                }
                case 23: {
                    return "getAvailableMemoryInBytes";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IEuiccController.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    Intent _arg1 = data.readTypedObject(Intent.CREATOR);
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.continueOperation(_arg0, _arg1, _arg2);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    DownloadableSubscription _arg1 = data.readTypedObject(DownloadableSubscription.CREATOR);
                    String _arg2 = data.readString();
                    PendingIntent _arg3 = data.readTypedObject(PendingIntent.CREATOR);
                    data.enforceNoDataAvail();
                    this.getDownloadableSubscriptionMetadata(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    PendingIntent _arg2 = data.readTypedObject(PendingIntent.CREATOR);
                    data.enforceNoDataAvail();
                    this.getDefaultDownloadableSubscriptionList(_arg0, _arg1, _arg2);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    String _result = this.getEid(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getOtaStatus(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    DownloadableSubscription _arg1 = data.readTypedObject(DownloadableSubscription.CREATOR);
                    boolean _arg2 = data.readBoolean();
                    String _arg3 = data.readString();
                    Bundle _arg4 = data.readTypedObject(Bundle.CREATOR);
                    PendingIntent _arg5 = data.readTypedObject(PendingIntent.CREATOR);
                    data.enforceNoDataAvail();
                    this.downloadSubscription(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    EuiccInfo _result = this.getEuiccInfo(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    PendingIntent _arg3 = data.readTypedObject(PendingIntent.CREATOR);
                    data.enforceNoDataAvail();
                    this.deleteSubscription(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    PendingIntent _arg3 = data.readTypedObject(PendingIntent.CREATOR);
                    data.enforceNoDataAvail();
                    this.switchToSubscription(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    PendingIntent _arg4 = data.readTypedObject(PendingIntent.CREATOR);
                    data.enforceNoDataAvail();
                    this.switchToSubscriptionWithPort(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 11: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    PendingIntent _arg4 = data.readTypedObject(PendingIntent.CREATOR);
                    data.enforceNoDataAvail();
                    this.updateSubscriptionNickname(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    PendingIntent _arg1 = data.readTypedObject(PendingIntent.CREATOR);
                    data.enforceNoDataAvail();
                    this.eraseSubscriptions(_arg0, _arg1);
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    PendingIntent _arg2 = data.readTypedObject(PendingIntent.CREATOR);
                    data.enforceNoDataAvail();
                    this.eraseSubscriptionsWithOptions(_arg0, _arg1, _arg2);
                    break;
                }
                case 14: {
                    int _arg0 = data.readInt();
                    PendingIntent _arg1 = data.readTypedObject(PendingIntent.CREATOR);
                    data.enforceNoDataAvail();
                    this.retainSubscriptionsForFactoryReset(_arg0, _arg1);
                    break;
                }
                case 15: {
                    boolean _arg0 = data.readBoolean();
                    ArrayList<String> _arg1 = data.createStringArrayList();
                    data.enforceNoDataAvail();
                    this.setSupportedCountries(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    List<String> _result = this.getSupportedCountries(_arg0);
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    break;
                }
                case 17: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isSupportedCountry(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 18: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isSimPortAvailable(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 19: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.hasCarrierPrivilegesForPackageOnAnyPhone(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 20: {
                    String _arg0 = data.readString();
                    long _arg1 = data.readLong();
                    data.enforceNoDataAvail();
                    boolean _result = this.isCompatChangeEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 21: {
                    int[] _arg0 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.setPsimConversionSupportedCarriers(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 22: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isPsimConversionSupported(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 23: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    long _result = this.getAvailableMemoryInBytes(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 22;
        }

        private static class Proxy
        implements IEuiccController {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IEuiccController.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void continueOperation(int cardId, Intent resolutionIntent, Bundle resolutionExtras) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IEuiccController.DESCRIPTOR);
                    _data.writeInt(cardId);
                    _data.writeTypedObject(resolutionIntent, 0);
                    _data.writeTypedObject(resolutionExtras, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getDownloadableSubscriptionMetadata(int cardId, DownloadableSubscription subscription, String callingPackage, PendingIntent callbackIntent) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IEuiccController.DESCRIPTOR);
                    _data.writeInt(cardId);
                    _data.writeTypedObject(subscription, 0);
                    _data.writeString(callingPackage);
                    _data.writeTypedObject(callbackIntent, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getDefaultDownloadableSubscriptionList(int cardId, String callingPackage, PendingIntent callbackIntent) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IEuiccController.DESCRIPTOR);
                    _data.writeInt(cardId);
                    _data.writeString(callingPackage);
                    _data.writeTypedObject(callbackIntent, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getEid(int cardId, String callingPackage) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IEuiccController.DESCRIPTOR);
                    _data.writeInt(cardId);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getOtaStatus(int cardId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IEuiccController.DESCRIPTOR);
                    _data.writeInt(cardId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void downloadSubscription(int cardId, DownloadableSubscription subscription, boolean switchAfterDownload, String callingPackage, Bundle resolvedBundle, PendingIntent callbackIntent) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IEuiccController.DESCRIPTOR);
                    _data.writeInt(cardId);
                    _data.writeTypedObject(subscription, 0);
                    _data.writeBoolean(switchAfterDownload);
                    _data.writeString(callingPackage);
                    _data.writeTypedObject(resolvedBundle, 0);
                    _data.writeTypedObject(callbackIntent, 0);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EuiccInfo getEuiccInfo(int cardId) throws RemoteException {
                EuiccInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IEuiccController.DESCRIPTOR);
                    _data.writeInt(cardId);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(EuiccInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deleteSubscription(int cardId, int subscriptionId, String callingPackage, PendingIntent callbackIntent) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IEuiccController.DESCRIPTOR);
                    _data.writeInt(cardId);
                    _data.writeInt(subscriptionId);
                    _data.writeString(callingPackage);
                    _data.writeTypedObject(callbackIntent, 0);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void switchToSubscription(int cardId, int subscriptionId, String callingPackage, PendingIntent callbackIntent) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IEuiccController.DESCRIPTOR);
                    _data.writeInt(cardId);
                    _data.writeInt(subscriptionId);
                    _data.writeString(callingPackage);
                    _data.writeTypedObject(callbackIntent, 0);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void switchToSubscriptionWithPort(int cardId, int subscriptionId, int portIndex, String callingPackage, PendingIntent callbackIntent) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IEuiccController.DESCRIPTOR);
                    _data.writeInt(cardId);
                    _data.writeInt(subscriptionId);
                    _data.writeInt(portIndex);
                    _data.writeString(callingPackage);
                    _data.writeTypedObject(callbackIntent, 0);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateSubscriptionNickname(int cardId, int subscriptionId, String nickname, String callingPackage, PendingIntent callbackIntent) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IEuiccController.DESCRIPTOR);
                    _data.writeInt(cardId);
                    _data.writeInt(subscriptionId);
                    _data.writeString(nickname);
                    _data.writeString(callingPackage);
                    _data.writeTypedObject(callbackIntent, 0);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void eraseSubscriptions(int cardId, PendingIntent callbackIntent) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IEuiccController.DESCRIPTOR);
                    _data.writeInt(cardId);
                    _data.writeTypedObject(callbackIntent, 0);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void eraseSubscriptionsWithOptions(int cardId, int options, PendingIntent callbackIntent) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IEuiccController.DESCRIPTOR);
                    _data.writeInt(cardId);
                    _data.writeInt(options);
                    _data.writeTypedObject(callbackIntent, 0);
                    boolean bl = this.mRemote.transact(13, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void retainSubscriptionsForFactoryReset(int cardId, PendingIntent callbackIntent) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IEuiccController.DESCRIPTOR);
                    _data.writeInt(cardId);
                    _data.writeTypedObject(callbackIntent, 0);
                    boolean bl = this.mRemote.transact(14, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSupportedCountries(boolean isSupported, List<String> countriesList) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IEuiccController.DESCRIPTOR);
                    _data.writeBoolean(isSupported);
                    _data.writeStringList(countriesList);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getSupportedCountries(boolean isSupported) throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IEuiccController.DESCRIPTOR);
                    _data.writeBoolean(isSupported);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSupportedCountry(String countryIso) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IEuiccController.DESCRIPTOR);
                    _data.writeString(countryIso);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSimPortAvailable(int cardId, int portIndex, String callingPackage) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IEuiccController.DESCRIPTOR);
                    _data.writeInt(cardId);
                    _data.writeInt(portIndex);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasCarrierPrivilegesForPackageOnAnyPhone(String callingPackage) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IEuiccController.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isCompatChangeEnabled(String callingPackage, long changeId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IEuiccController.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeLong(changeId);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPsimConversionSupportedCarriers(int[] carrierIds) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IEuiccController.DESCRIPTOR);
                    _data.writeIntArray(carrierIds);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isPsimConversionSupported(int carrierId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IEuiccController.DESCRIPTOR);
                    _data.writeInt(carrierId);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getAvailableMemoryInBytes(int cardId, String callingPackage) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IEuiccController.DESCRIPTOR);
                    _data.writeInt(cardId);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IEuiccController {
        @Override
        public void continueOperation(int cardId, Intent resolutionIntent, Bundle resolutionExtras) throws RemoteException {
        }

        @Override
        public void getDownloadableSubscriptionMetadata(int cardId, DownloadableSubscription subscription, String callingPackage, PendingIntent callbackIntent) throws RemoteException {
        }

        @Override
        public void getDefaultDownloadableSubscriptionList(int cardId, String callingPackage, PendingIntent callbackIntent) throws RemoteException {
        }

        @Override
        public String getEid(int cardId, String callingPackage) throws RemoteException {
            return null;
        }

        @Override
        public int getOtaStatus(int cardId) throws RemoteException {
            return 0;
        }

        @Override
        public void downloadSubscription(int cardId, DownloadableSubscription subscription, boolean switchAfterDownload, String callingPackage, Bundle resolvedBundle, PendingIntent callbackIntent) throws RemoteException {
        }

        @Override
        public EuiccInfo getEuiccInfo(int cardId) throws RemoteException {
            return null;
        }

        @Override
        public void deleteSubscription(int cardId, int subscriptionId, String callingPackage, PendingIntent callbackIntent) throws RemoteException {
        }

        @Override
        public void switchToSubscription(int cardId, int subscriptionId, String callingPackage, PendingIntent callbackIntent) throws RemoteException {
        }

        @Override
        public void switchToSubscriptionWithPort(int cardId, int subscriptionId, int portIndex, String callingPackage, PendingIntent callbackIntent) throws RemoteException {
        }

        @Override
        public void updateSubscriptionNickname(int cardId, int subscriptionId, String nickname, String callingPackage, PendingIntent callbackIntent) throws RemoteException {
        }

        @Override
        public void eraseSubscriptions(int cardId, PendingIntent callbackIntent) throws RemoteException {
        }

        @Override
        public void eraseSubscriptionsWithOptions(int cardId, int options, PendingIntent callbackIntent) throws RemoteException {
        }

        @Override
        public void retainSubscriptionsForFactoryReset(int cardId, PendingIntent callbackIntent) throws RemoteException {
        }

        @Override
        public void setSupportedCountries(boolean isSupported, List<String> countriesList) throws RemoteException {
        }

        @Override
        public List<String> getSupportedCountries(boolean isSupported) throws RemoteException {
            return null;
        }

        @Override
        public boolean isSupportedCountry(String countryIso) throws RemoteException {
            return false;
        }

        @Override
        public boolean isSimPortAvailable(int cardId, int portIndex, String callingPackage) throws RemoteException {
            return false;
        }

        @Override
        public boolean hasCarrierPrivilegesForPackageOnAnyPhone(String callingPackage) throws RemoteException {
            return false;
        }

        @Override
        public boolean isCompatChangeEnabled(String callingPackage, long changeId) throws RemoteException {
            return false;
        }

        @Override
        public void setPsimConversionSupportedCarriers(int[] carrierIds) throws RemoteException {
        }

        @Override
        public boolean isPsimConversionSupported(int carrierId) throws RemoteException {
            return false;
        }

        @Override
        public long getAvailableMemoryInBytes(int cardId, String callingPackage) throws RemoteException {
            return 0L;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

