/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.annotation.EnforcePermission;
import android.app.ActivityThread;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.PermissionEnforcer;
import android.os.PersistableBundle;
import android.os.RemoteException;

public interface ICarrierConfigLoader
extends IInterface {
    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/telephony/java/com/android/internal/telephony/ICarrierConfigLoader.aidl:27:1:27:69")
    public PersistableBundle getConfigForSubId(int var1, String var2) throws RemoteException;

    public PersistableBundle getConfigForSubIdWithFeature(int var1, String var2, String var3) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_PHONE_STATE")
    public void overrideConfig(int var1, PersistableBundle var2, boolean var3) throws RemoteException;

    public void notifyConfigChangedForSubId(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_PHONE_STATE")
    public void updateConfigForPhoneId(int var1, String var2) throws RemoteException;

    @EnforcePermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public String getDefaultCarrierServicePackageName() throws RemoteException;

    public PersistableBundle getConfigSubsetForSubIdWithFeature(int var1, String var2, String var3, String[] var4) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ICarrierConfigLoader {
        private final PermissionEnforcer mEnforcer;
        public static final String DESCRIPTOR = "com.android.internal.telephony.ICarrierConfigLoader";
        static final int TRANSACTION_getConfigForSubId = 1;
        static final int TRANSACTION_getConfigForSubIdWithFeature = 2;
        static final int TRANSACTION_overrideConfig = 3;
        static final int TRANSACTION_notifyConfigChangedForSubId = 4;
        static final int TRANSACTION_updateConfigForPhoneId = 5;
        static final int TRANSACTION_getDefaultCarrierServicePackageName = 6;
        static final int TRANSACTION_getConfigSubsetForSubIdWithFeature = 7;

        public Stub(PermissionEnforcer enforcer) {
            this.attachInterface(this, DESCRIPTOR);
            if (enforcer == null) {
                throw new IllegalArgumentException("enforcer cannot be null");
            }
            this.mEnforcer = enforcer;
        }

        @Deprecated
        public Stub() {
            this(PermissionEnforcer.fromContext(ActivityThread.currentSystemContext()));
        }

        public static ICarrierConfigLoader asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ICarrierConfigLoader) {
                return (ICarrierConfigLoader)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getConfigForSubId";
                }
                case 2: {
                    return "getConfigForSubIdWithFeature";
                }
                case 3: {
                    return "overrideConfig";
                }
                case 4: {
                    return "notifyConfigChangedForSubId";
                }
                case 5: {
                    return "updateConfigForPhoneId";
                }
                case 6: {
                    return "getDefaultCarrierServicePackageName";
                }
                case 7: {
                    return "getConfigSubsetForSubIdWithFeature";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    PersistableBundle _result = this.getConfigForSubId(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    PersistableBundle _result = this.getConfigForSubIdWithFeature(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    PersistableBundle _arg1 = data.readTypedObject(PersistableBundle.CREATOR);
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.overrideConfig(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyConfigChangedForSubId(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.updateConfigForPhoneId(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    String _result = this.getDefaultCarrierServicePackageName();
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    String[] _arg3 = data.createStringArray();
                    data.enforceNoDataAvail();
                    PersistableBundle _result = this.getConfigSubsetForSubIdWithFeature(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        protected void overrideConfig_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_PHONE_STATE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void updateConfigForPhoneId_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_PHONE_STATE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getDefaultCarrierServicePackageName_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.READ_PRIVILEGED_PHONE_STATE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        @Override
        public int getMaxTransactionId() {
            return 6;
        }

        private static class Proxy
        implements ICarrierConfigLoader {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PersistableBundle getConfigForSubId(int subId, String callingPackage) throws RemoteException {
                PersistableBundle _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(PersistableBundle.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PersistableBundle getConfigForSubIdWithFeature(int subId, String callingPackage, String callingFeatureId) throws RemoteException {
                PersistableBundle _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(PersistableBundle.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void overrideConfig(int subId, PersistableBundle overrides, boolean persistent) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    _data.writeTypedObject(overrides, 0);
                    _data.writeBoolean(persistent);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyConfigChangedForSubId(int subId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateConfigForPhoneId(int phoneId, String simState) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(phoneId);
                    _data.writeString(simState);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getDefaultCarrierServicePackageName() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PersistableBundle getConfigSubsetForSubIdWithFeature(int subId, String callingPackage, String callingFeatureId, String[] carrierConfigs) throws RemoteException {
                PersistableBundle _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    _data.writeStringArray(carrierConfigs);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(PersistableBundle.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements ICarrierConfigLoader {
        @Override
        public PersistableBundle getConfigForSubId(int subId, String callingPackage) throws RemoteException {
            return null;
        }

        @Override
        public PersistableBundle getConfigForSubIdWithFeature(int subId, String callingPackage, String callingFeatureId) throws RemoteException {
            return null;
        }

        @Override
        public void overrideConfig(int subId, PersistableBundle overrides, boolean persistent) throws RemoteException {
        }

        @Override
        public void notifyConfigChangedForSubId(int subId) throws RemoteException {
        }

        @Override
        public void updateConfigForPhoneId(int phoneId, String simState) throws RemoteException {
        }

        @Override
        public String getDefaultCarrierServicePackageName() throws RemoteException {
            return null;
        }

        @Override
        public PersistableBundle getConfigSubsetForSubIdWithFeature(int subId, String callingPackage, String callingFeatureId, String[] carrierConfigs) throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

