/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.security;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os._Original_Build;
import android.os.incremental.V4Signature;
import android.system.Os;
import android.system.OsConstants;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.android.internal.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.android.internal.org.bouncycastle.cms.CMSException;
import com.android.internal.org.bouncycastle.cms.CMSProcessable;
import com.android.internal.org.bouncycastle.cms.CMSProcessableByteArray;
import com.android.internal.org.bouncycastle.cms.CMSSignedData;
import com.android.internal.org.bouncycastle.cms.SignerInformation;
import com.android.internal.org.bouncycastle.cms.SignerInformationVerifier;
import com.android.internal.org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import com.android.internal.org.bouncycastle.operator.OperatorCreationException;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public abstract class VerityUtils {
    private static final String TAG = "VerityUtils";
    private static final int HASH_SIZE_BYTES = 32;

    public static boolean isFsVeritySupported() {
        return _Original_Build.VERSION.DEVICE_INITIAL_SDK_INT >= 30;
    }

    public static void setUpFsverity(@NonNull String filePath) throws IOException {
        int errno = VerityUtils.enableFsverityNative(filePath);
        if (errno != 0) {
            throw new IOException("Failed to enable fs-verity on " + filePath + ": " + Os.strerror(errno));
        }
    }

    public static void setUpFsverity(int fd) throws IOException {
        int errno = VerityUtils.enableFsverityForFdNative(fd);
        if (errno != 0) {
            throw new IOException("Failed to enable fs-verity on FD(" + fd + "): " + Os.strerror(errno));
        }
    }

    public static boolean hasFsverity(@NonNull String filePath) {
        int retval = VerityUtils.statxForFsverityNative(filePath);
        if (retval < 0) {
            Slog.e(TAG, "Failed to check whether fs-verity is enabled, errno " + -retval + ": " + filePath);
            return false;
        }
        return retval == 1;
    }

    public static boolean verifyPkcs7DetachedSignature(@NonNull byte[] signatureBlock, @NonNull byte[] digest, @NonNull InputStream derCertInputStream) {
        if (digest.length != 32) {
            Slog.w(TAG, "Only sha256 is currently supported");
            return false;
        }
        try {
            CMSSignedData signedData = new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(VerityUtils.toFormattedDigest(digest)), signatureBlock);
            if (!signedData.isDetachedSignature()) {
                Slog.w(TAG, "Expect only detached siganture");
                return false;
            }
            if (!signedData.getCertificates().getMatches(null).isEmpty()) {
                Slog.w(TAG, "Expect no certificate in signature");
                return false;
            }
            if (!signedData.getCRLs().getMatches(null).isEmpty()) {
                Slog.w(TAG, "Expect no CRL in signature");
                return false;
            }
            X509Certificate trustedCert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(derCertInputStream);
            SignerInformationVerifier verifier = new JcaSimpleSignerInfoVerifierBuilder().build(trustedCert);
            for (SignerInformation si : signedData.getSignerInfos().getSigners()) {
                if (si.getSignedAttributes() != null && si.getSignedAttributes().size() > 0) {
                    Slog.w(TAG, "Unexpected signed attributes");
                    return false;
                }
                if (si.getUnsignedAttributes() != null && si.getUnsignedAttributes().size() > 0) {
                    Slog.w(TAG, "Unexpected unsigned attributes");
                    return false;
                }
                if (!NISTObjectIdentifiers.id_sha256.getId().equals(si.getDigestAlgOID())) {
                    Slog.w(TAG, "Unsupported digest algorithm OID: " + si.getDigestAlgOID());
                    return false;
                }
                if (!PKCSObjectIdentifiers.rsaEncryption.getId().equals(si.getEncryptionAlgOID())) {
                    Slog.w(TAG, "Unsupported encryption algorithm OID: " + si.getEncryptionAlgOID());
                    return false;
                }
                if (!si.verify(verifier)) continue;
                return true;
            }
            return false;
        }
        catch (CMSException | OperatorCreationException | CertificateException e) {
            Slog.w(TAG, "Error occurred during the PKCS#7 signature verification", e);
            return false;
        }
    }

    @Nullable
    public static byte[] getFsverityDigest(@NonNull String filePath) {
        byte[] result = new byte[32];
        int retval = VerityUtils.measureFsverityNative(filePath, result);
        if (retval < 0) {
            if (retval != -OsConstants.ENODATA) {
                Slog.e(TAG, "Failed to measure fs-verity, errno " + -retval + ": " + filePath);
            }
            return null;
        }
        return result;
    }

    @NonNull
    public static byte[] generateFsVerityDigest(long fileSize, @NonNull V4Signature.HashingInfo hashingInfo) throws DigestException, NoSuchAlgorithmException {
        if (hashingInfo.rawRootHash == null || hashingInfo.rawRootHash.length != 32) {
            throw new IllegalArgumentException("Expect a 32-byte rootHash for SHA256");
        }
        if (hashingInfo.log2BlockSize != 12) {
            throw new IllegalArgumentException("Unsupported log2BlockSize: " + hashingInfo.log2BlockSize);
        }
        ByteBuffer buffer = ByteBuffer.allocate(256);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)1);
        buffer.put((byte)1);
        buffer.put(hashingInfo.log2BlockSize);
        buffer.put((byte)0);
        buffer.putInt(0);
        buffer.putLong(fileSize);
        buffer.put(hashingInfo.rawRootHash);
        return MessageDigest.getInstance("SHA-256").digest(buffer.array());
    }

    @VisibleForTesting
    public static byte[] toFormattedDigest(byte[] digest) {
        ByteBuffer buffer = ByteBuffer.allocate(12 + digest.length);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put("FSVerity".getBytes(StandardCharsets.US_ASCII));
        buffer.putShort((short)1);
        buffer.putShort((short)digest.length);
        buffer.put(digest);
        return buffer.array();
    }

    private static int enableFsverityNative(@NonNull String string2) {
        return OverrideMethod.invokeI("com.android.internal.security.VerityUtils#enableFsverityNative(Ljava/lang/String;)I", true, null);
    }

    private static int enableFsverityForFdNative(int n) {
        return OverrideMethod.invokeI("com.android.internal.security.VerityUtils#enableFsverityForFdNative(I)I", true, null);
    }

    private static int measureFsverityNative(@NonNull String string2, @NonNull byte[] byArray) {
        return OverrideMethod.invokeI("com.android.internal.security.VerityUtils#measureFsverityNative(Ljava/lang/String;[B)I", true, null);
    }

    private static int statxForFsverityNative(@NonNull String string2) {
        return OverrideMethod.invokeI("com.android.internal.security.VerityUtils#statxForFsverityNative(Ljava/lang/String;)I", true, null);
    }
}

