/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy;

import android.app.KeyguardManager;
import android.app.SearchManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.media.AudioManager;
import android.media.session.MediaSessionManager;
import android.os.UserHandle;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.view.FallbackEventHandler;
import android.view.KeyEvent;
import android.view.View;

public class PhoneFallbackEventHandler
implements FallbackEventHandler {
    private static String TAG = "PhoneFallbackEventHandler";
    private static final boolean DEBUG = false;
    @UnsupportedAppUsage
    Context mContext;
    @UnsupportedAppUsage
    View mView;
    AudioManager mAudioManager;
    KeyguardManager mKeyguardManager;
    SearchManager mSearchManager;
    TelephonyManager mTelephonyManager;
    MediaSessionManager mMediaSessionManager;

    @UnsupportedAppUsage
    public PhoneFallbackEventHandler(Context context) {
        this.mContext = context;
    }

    @Override
    public void setView(View v) {
        this.mView = v;
    }

    @Override
    public void preDispatchKeyEvent(KeyEvent event) {
        this.getAudioManager().preDispatchKeyEvent(event, Integer.MIN_VALUE);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        int action = event.getAction();
        int keyCode = event.getKeyCode();
        if (action == 0) {
            return this.onKeyDown(keyCode, event);
        }
        return this.onKeyUp(keyCode, event);
    }

    @UnsupportedAppUsage
    boolean onKeyDown(int keyCode, KeyEvent event) {
        KeyEvent.DispatcherState dispatcher = this.mView.getKeyDispatcherState();
        switch (keyCode) {
            case 24: 
            case 25: 
            case 164: {
                this.handleVolumeKeyEvent(event);
                return true;
            }
            case 79: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 126: 
            case 127: 
            case 130: 
            case 222: {
                this.handleMediaKeyEvent(event);
                return true;
            }
            case 5: {
                if (this.isNotInstantAppAndKeyguardRestricted(dispatcher)) break;
                if (event.getRepeatCount() == 0) {
                    dispatcher.startTracking(event, this);
                } else if (event.isLongPress() && dispatcher.isTracking(event)) {
                    dispatcher.performedLongPress(event);
                    if (this.isUserSetupComplete()) {
                        this.mView.performHapticFeedback(0);
                        Intent intent = new Intent("android.intent.action.VOICE_COMMAND");
                        intent.setFlags(0x10000000);
                        try {
                            this.mContext.startActivity(intent);
                        }
                        catch (ActivityNotFoundException e) {
                            this.startCallActivity();
                        }
                    } else {
                        Log.i(TAG, "Not starting call activity because user setup is in progress.");
                    }
                }
                return true;
            }
            case 27: {
                if (this.isNotInstantAppAndKeyguardRestricted(dispatcher)) break;
                if (event.getRepeatCount() == 0) {
                    dispatcher.startTracking(event, this);
                } else if (event.isLongPress() && dispatcher.isTracking(event)) {
                    dispatcher.performedLongPress(event);
                    if (this.isUserSetupComplete()) {
                        this.mView.performHapticFeedback(0);
                        Intent intent = new Intent("android.intent.action.CAMERA_BUTTON", null);
                        intent.addFlags(0x10000000);
                        intent.putExtra("android.intent.extra.KEY_EVENT", event);
                        this.mContext.sendOrderedBroadcastAsUser(intent, UserHandle.CURRENT_OR_SELF, null, null, null, 0, null, null);
                    } else {
                        Log.i(TAG, "Not dispatching CAMERA long press because user setup is in progress.");
                    }
                }
                return true;
            }
            case 84: {
                if (this.isNotInstantAppAndKeyguardRestricted(dispatcher)) break;
                if (event.getRepeatCount() == 0) {
                    dispatcher.startTracking(event, this);
                    break;
                }
                if (!event.isLongPress() || !dispatcher.isTracking(event)) break;
                Configuration config = this.mContext.getResources().getConfiguration();
                if (config.keyboard != 1 && config.hardKeyboardHidden != 2) break;
                if (this.isUserSetupComplete()) {
                    Intent intent = new Intent("android.intent.action.SEARCH_LONG_PRESS");
                    intent.setFlags(0x10000000);
                    try {
                        this.mView.performHapticFeedback(0);
                        this.getSearchManager().stopSearch();
                        this.mContext.startActivity(intent);
                        dispatcher.performedLongPress(event);
                        return true;
                    }
                    catch (ActivityNotFoundException activityNotFoundException) {
                        break;
                    }
                }
                Log.i(TAG, "Not dispatching SEARCH long press because user setup is in progress.");
            }
        }
        return false;
    }

    private boolean isNotInstantAppAndKeyguardRestricted(KeyEvent.DispatcherState dispatcher) {
        return !this.mContext.getPackageManager().isInstantApp() && (this.getKeyguardManager().inKeyguardRestrictedInputMode() || dispatcher == null);
    }

    @UnsupportedAppUsage
    boolean onKeyUp(int keyCode, KeyEvent event) {
        KeyEvent.DispatcherState dispatcher = this.mView.getKeyDispatcherState();
        if (dispatcher != null) {
            dispatcher.handleUpEvent(event);
        }
        switch (keyCode) {
            case 24: 
            case 25: 
            case 164: {
                if (!event.isCanceled()) {
                    this.handleVolumeKeyEvent(event);
                }
                return true;
            }
            case 79: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 126: 
            case 127: 
            case 130: 
            case 222: {
                this.handleMediaKeyEvent(event);
                return true;
            }
            case 27: {
                if (this.isNotInstantAppAndKeyguardRestricted(dispatcher)) break;
                if (!event.isTracking() || !event.isCanceled()) {
                    // empty if block
                }
                return true;
            }
            case 5: {
                if (this.isNotInstantAppAndKeyguardRestricted(dispatcher)) break;
                if (event.isTracking() && !event.isCanceled()) {
                    if (this.isUserSetupComplete()) {
                        this.startCallActivity();
                    } else {
                        Log.i(TAG, "Not starting call activity because user setup is in progress.");
                    }
                }
                return true;
            }
        }
        return false;
    }

    @UnsupportedAppUsage
    void startCallActivity() {
        Intent intent = new Intent("android.intent.action.CALL_BUTTON");
        intent.setFlags(0x10000000);
        try {
            this.mContext.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            Log.w(TAG, "No activity found for android.intent.action.CALL_BUTTON.");
        }
    }

    SearchManager getSearchManager() {
        if (this.mSearchManager == null) {
            this.mSearchManager = (SearchManager)this.mContext.getSystemService("search");
        }
        return this.mSearchManager;
    }

    TelephonyManager getTelephonyManager() {
        if (this.mTelephonyManager == null) {
            this.mTelephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        }
        return this.mTelephonyManager;
    }

    KeyguardManager getKeyguardManager() {
        if (this.mKeyguardManager == null) {
            this.mKeyguardManager = (KeyguardManager)this.mContext.getSystemService("keyguard");
        }
        return this.mKeyguardManager;
    }

    AudioManager getAudioManager() {
        if (this.mAudioManager == null) {
            this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
        }
        return this.mAudioManager;
    }

    MediaSessionManager getMediaSessionManager() {
        if (this.mMediaSessionManager == null) {
            this.mMediaSessionManager = (MediaSessionManager)this.mContext.getSystemService("media_session");
        }
        return this.mMediaSessionManager;
    }

    private void handleVolumeKeyEvent(KeyEvent keyEvent) {
        this.getMediaSessionManager().dispatchVolumeKeyEventAsSystemService(keyEvent, Integer.MIN_VALUE);
    }

    private void handleMediaKeyEvent(KeyEvent keyEvent) {
        this.getMediaSessionManager().dispatchMediaKeyEventAsSystemService(keyEvent);
    }

    private boolean isUserSetupComplete() {
        return Settings.Secure.getInt(this.mContext.getContentResolver(), "user_setup_complete", 0) != 0;
    }
}

