/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.pm.pkg.component;

import android.annotation.NonNull;
import android.content.pm.PermissionInfo;
import android.content.pm.parsing.result.ParseInput;
import android.content.pm.parsing.result.ParseResult;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os._Original_Build;
import android.util.ArrayMap;
import android.util.EventLog;
import android.util.Slog;
import com.android.internal.R;
import com.android.internal.hidden_from_bootclasspath.android.permission.flags.Flags;
import com.android.internal.pm.pkg.component.ComponentParseUtils;
import com.android.internal.pm.pkg.component.ParsedComponentUtils;
import com.android.internal.pm.pkg.component.ParsedPermission;
import com.android.internal.pm.pkg.component.ParsedPermissionGroup;
import com.android.internal.pm.pkg.component.ParsedPermissionGroupImpl;
import com.android.internal.pm.pkg.component.ParsedPermissionImpl;
import com.android.internal.pm.pkg.parsing.ParsingPackage;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.xmlpull.v1.XmlPullParserException;

public class ParsedPermissionUtils {
    private static final String TAG = "PackageParsing";

    @NonNull
    public static ParseResult<ParsedPermission> parsePermission(ParsingPackage pkg, Resources res, XmlResourceParser parser, boolean useRoundIcon, ParseInput input, int flags) throws IOException, XmlPullParserException {
        ParseResult<ParsedPermissionImpl> result;
        String packageName = pkg.getPackageName();
        ParsedPermissionImpl permission2 = new ParsedPermissionImpl();
        String tag = "<" + parser.getName() + ">";
        try (TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestPermission);){
            result = ParsedComponentUtils.parseComponent(permission2, tag, pkg, sa, useRoundIcon, input, 9, 5, 1, 0, 7, 2, 10);
            if (result.isError()) {
                ParseResult<ParsedPermission> parseResult = input.error(result);
                return parseResult;
            }
            int maxSdkVersion = sa.getInt(6, -1);
            if (maxSdkVersion != -1 && maxSdkVersion < _Original_Build.VERSION.SDK_INT) {
                ParseResult<Object> parseResult = input.success(null);
                return parseResult;
            }
            if (sa.hasValue(12)) {
                boolean canUseBackgroundPermissionAttr;
                boolean isApkInApex = (flags & 0x200) != 0;
                boolean bl = canUseBackgroundPermissionAttr = "android".equals(packageName) || Flags.replaceBodySensorPermissionEnabled() && isApkInApex;
                if (canUseBackgroundPermissionAttr) {
                    permission2.setBackgroundPermission(sa.getNonResourceString(12));
                } else {
                    String allowedPackages = "'android'" + (Flags.replaceBodySensorPermissionEnabled() ? " and APK_IN_APEX" : "");
                    Slog.w(TAG, packageName + " defines a background permission. Only the " + allowedPackages + " packages can do that.");
                }
            }
            permission2.setGroup(sa.getNonResourceString(4)).setRequestRes(sa.getResourceId(13, 0)).setProtectionLevel(sa.getInt(3, 0)).setFlags(sa.getInt(8, 0));
            int knownCertsResource = sa.getResourceId(11, 0);
            if (knownCertsResource != 0) {
                String resourceType = res.getResourceTypeName(knownCertsResource);
                if (resourceType.equals("array")) {
                    String[] knownCerts = res.getStringArray(knownCertsResource);
                    if (knownCerts != null) {
                        permission2.setKnownCerts(knownCerts);
                    }
                } else {
                    String knownCert = res.getString(knownCertsResource);
                    if (knownCert != null) {
                        permission2.setKnownCert(knownCert);
                    }
                }
                if (permission2.getKnownCerts().isEmpty()) {
                    Slog.w(TAG, packageName + " defines a knownSigner permission but the provided knownCerts resource is null");
                }
            } else {
                String knownCert = sa.getString(11);
                if (knownCert != null) {
                    permission2.setKnownCert(knownCert);
                }
            }
            boolean isPlatform = "android".equals(permission2.getPackageName());
            if (Flags.purposeDeclarationEnabled() && isPlatform) {
                boolean requiresPurpose = sa.getBoolean(14, false);
                permission2.setPurposeRequired(requiresPurpose);
            }
            if (!ParsedPermissionUtils.isRuntime(permission2) || !isPlatform) {
                permission2.setFlags(permission2.getFlags() & 0xFFFFFFFB);
                permission2.setFlags(permission2.getFlags() & 0xFFFFFFF7);
            } else if ((permission2.getFlags() & 4) != 0 && (permission2.getFlags() & 8) != 0) {
                throw new IllegalStateException("Permission cannot be both soft and hard restricted: " + permission2.getName());
            }
        }
        permission2.setProtectionLevel(PermissionInfo.fixProtectionLevel(permission2.getProtectionLevel()));
        int otherProtectionFlags = ParsedPermissionUtils.getProtectionFlags(permission2) & 0xFFFFCFBF;
        if (otherProtectionFlags != 0 && ParsedPermissionUtils.getProtection(permission2) != 2 && ParsedPermissionUtils.getProtection(permission2) != 4) {
            return input.error("<permission> protectionLevel specifies a non-instant, non-appop, non-runtimeOnly flag but is not based on signature or internal type");
        }
        result = ComponentParseUtils.parseAllMetaData(pkg, res, parser, tag, permission2, input);
        if (result.isError()) {
            return input.error(result);
        }
        return input.success((ParsedPermission)result.getResult());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static ParseResult<ParsedPermission> parsePermissionTree(ParsingPackage pkg, Resources res, XmlResourceParser parser, boolean useRoundIcon, ParseInput input) throws IOException, XmlPullParserException {
        ParseResult<ParsedPermissionImpl> result;
        ParsedPermissionImpl permission2 = new ParsedPermissionImpl();
        String tag = "<" + parser.getName() + ">";
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestPermissionTree);
        try {
            result = ParsedComponentUtils.parseComponent(permission2, tag, pkg, sa, useRoundIcon, input, 4, -1, 1, 0, 3, 2, 5);
            if (result.isError()) {
                ParseResult<ParsedPermission> parseResult = input.error(result);
                return parseResult;
            }
        }
        finally {
            sa.recycle();
        }
        int index = permission2.getName().indexOf(46);
        if (index > 0) {
            index = permission2.getName().indexOf(46, index + 1);
        }
        if (index < 0) {
            return input.error("<permission-tree> name has less than three segments: " + permission2.getName());
        }
        permission2.setProtectionLevel(0).setTree(true);
        result = ComponentParseUtils.parseAllMetaData(pkg, res, parser, tag, permission2, input);
        if (result.isError()) {
            return input.error(result);
        }
        return input.success((ParsedPermission)result.getResult());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static ParseResult<ParsedPermissionGroup> parsePermissionGroup(ParsingPackage pkg, Resources res, XmlResourceParser parser, boolean useRoundIcon, ParseInput input) throws IOException, XmlPullParserException {
        ParseResult<ParsedPermissionGroupImpl> result;
        ParsedPermissionGroupImpl permissionGroup = new ParsedPermissionGroupImpl();
        String tag = "<" + parser.getName() + ">";
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestPermissionGroup);
        try {
            result = ParsedComponentUtils.parseComponent(permissionGroup, tag, pkg, sa, useRoundIcon, input, 7, 4, 1, 0, 5, 2, 8);
            if (result.isError()) {
                ParseResult<ParsedPermissionGroup> parseResult = input.error(result);
                return parseResult;
            }
            permissionGroup.setRequestDetailRes(sa.getResourceId(12, 0)).setBackgroundRequestRes(sa.getResourceId(9, 0)).setBackgroundRequestDetailRes(sa.getResourceId(10, 0)).setRequestRes(sa.getResourceId(11, 0)).setPriority(sa.getInt(3, 0)).setFlags(sa.getInt(6, 0));
        }
        finally {
            sa.recycle();
        }
        result = ComponentParseUtils.parseAllMetaData(pkg, res, parser, tag, permissionGroup, input);
        if (result.isError()) {
            return input.error(result);
        }
        return input.success((ParsedPermissionGroup)result.getResult());
    }

    public static boolean isRuntime(@NonNull ParsedPermission permission2) {
        return ParsedPermissionUtils.getProtection(permission2) == 1;
    }

    public static boolean isAppOp(@NonNull ParsedPermission permission2) {
        return (permission2.getProtectionLevel() & 0x40) != 0;
    }

    public static int getProtection(@NonNull ParsedPermission permission2) {
        return permission2.getProtectionLevel() & 0xF;
    }

    public static int getProtectionFlags(@NonNull ParsedPermission permission2) {
        return permission2.getProtectionLevel() & 0xFFFFFFF0;
    }

    public static int calculateFootprint(@NonNull ParsedPermission permission2) {
        int size = permission2.getName().length();
        CharSequence nonLocalizedLabel = permission2.getNonLocalizedLabel();
        if (nonLocalizedLabel != null) {
            size += nonLocalizedLabel.length();
        }
        return size;
    }

    private static boolean isMalformedDuplicate(ParsedPermission p1, ParsedPermission p2) {
        if (p1 == null || p2 == null || p1.isTree() || p2.isTree()) {
            return false;
        }
        if (p1.getProtectionLevel() != p2.getProtectionLevel()) {
            return true;
        }
        return !Objects.equals(p1.getGroup(), p2.getGroup());
    }

    public static boolean declareDuplicatePermission(@NonNull ParsingPackage pkg) {
        List<ParsedPermission> permissions = pkg.getPermissions();
        int size = permissions.size();
        if (size > 0) {
            ArrayMap<String, ParsedPermission> checkDuplicatePerm = new ArrayMap<String, ParsedPermission>(size);
            for (int i = 0; i < size; ++i) {
                String name;
                ParsedPermission perm;
                ParsedPermission parsedPermission = permissions.get(i);
                if (ParsedPermissionUtils.isMalformedDuplicate(parsedPermission, perm = (ParsedPermission)checkDuplicatePerm.get(name = parsedPermission.getName()))) {
                    EventLog.writeEvent(1397638484, "213323615");
                    return true;
                }
                checkDuplicatePerm.put(name, parsedPermission);
            }
        }
        return false;
    }
}

