/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os.logging;

import android.os.Process;
import com.android.internal.hidden_from_bootclasspath.com.android.libcore.readonly.Flags;
import com.android.internal.os.ProcfsMemoryUtil;
import com.android.internal.util.FrameworkStatsLog;
import java.util.Collection;
import libcore.util.NativeAllocationRegistry;

public class MetricsLoggerWrapper {
    public static void logAppOverlayEnter(int uid, String packageName, boolean changed, int type, boolean usingAlertWindow) {
        if (changed) {
            if (type != 2038) {
                FrameworkStatsLog.write(59, uid, packageName, true, 1);
            } else if (!usingAlertWindow) {
                FrameworkStatsLog.write(59, uid, packageName, false, 1);
            }
        }
    }

    public static void logAppOverlayExit(int uid, String packageName, boolean changed, int type, boolean usingAlertWindow) {
        if (changed) {
            if (type != 2038) {
                FrameworkStatsLog.write(59, uid, packageName, true, 2);
            } else if (!usingAlertWindow) {
                FrameworkStatsLog.write(59, uid, packageName, false, 2);
            }
        }
    }

    public static void logPostGcMemorySnapshot() {
        if (!Flags.nativeMetrics()) {
            return;
        }
        int pid = Process.myPid();
        String processName = Process.myProcessName();
        Collection<NativeAllocationRegistry.Metrics> metrics = NativeAllocationRegistry.getMetrics();
        int nMetrics = metrics.size();
        String[] classNames = new String[nMetrics];
        long[] mallocedCount = new long[nMetrics];
        long[] mallocedBytes = new long[nMetrics];
        long[] nonmallocedCount = new long[nMetrics];
        long[] nonmallocedBytes = new long[nMetrics];
        int i = 0;
        for (NativeAllocationRegistry.Metrics m : metrics) {
            classNames[i] = m.getClassName();
            mallocedCount[i] = m.getMallocedCount();
            mallocedBytes[i] = m.getMallocedBytes();
            nonmallocedCount[i] = m.getNonmallocedCount();
            nonmallocedBytes[i] = m.getNonmallocedBytes();
            ++i;
        }
        ProcfsMemoryUtil.MemorySnapshot m = ProcfsMemoryUtil.readMemorySnapshotFromProcfs();
        int oom_score_adj = ProcfsMemoryUtil.readOomScoreAdjFromProcfs();
        Runtime runtime = Runtime.getRuntime();
        FrameworkStatsLog.write(924, m.uid, processName, pid, oom_score_adj, m.rssInKilobytes, m.anonRssInKilobytes, m.swapInKilobytes, m.anonRssInKilobytes + m.swapInKilobytes, classNames, mallocedCount, mallocedBytes, nonmallocedCount, nonmallocedBytes, runtime.freeMemory(), runtime.totalMemory(), runtime.maxMemory());
    }
}

