/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import com.android.internal.os.ZygoteCommandBuffer;
import java.io.EOFException;
import java.util.ArrayList;

class ZygoteArguments {
    int mUid = 0;
    boolean mUidSpecified;
    int mGid = 0;
    boolean mGidSpecified;
    int[] mGids;
    int mRuntimeFlags;
    int mMountExternal = 0;
    private boolean mTargetSdkVersionSpecified;
    int mTargetSdkVersion;
    String mNiceName;
    private boolean mCapabilitiesSpecified;
    long mPermittedCapabilities;
    long mEffectiveCapabilities;
    private boolean mSeInfoSpecified;
    String mSeInfo;
    boolean mUsapPoolEnabled;
    boolean mUsapPoolStatusSpecified = false;
    ArrayList<int[]> mRLimits;
    String mInvokeWith;
    String mPackageName;
    String[] mRemainingArgs;
    boolean mAbiListQuery;
    String mInstructionSet;
    String mAppDataDir;
    String mPreloadApp;
    boolean mPreloadDefault;
    boolean mStartChildZygote;
    boolean mPidQuery;
    boolean mBootCompleted;
    String[] mApiDenylistExemptions;
    int mHiddenApiAccessLogSampleRate = -1;
    int mHiddenApiAccessStatslogSampleRate = -1;
    boolean mIsTopApp;
    long[] mDisabledCompatChanges = null;
    String[] mPkgDataInfoList;
    String[] mAllowlistedDataInfoList;
    boolean mBindMountAppStorageDirs;
    boolean mBindMountAppDataDirs;
    boolean mBindMountSyspropOverrides;

    private ZygoteArguments(ZygoteCommandBuffer args, int argCount) throws IllegalArgumentException, EOFException {
        this.parseArgs(args, argCount);
    }

    public static ZygoteArguments getInstance(ZygoteCommandBuffer args) throws IllegalArgumentException, EOFException {
        int argCount = args.getCount();
        return argCount == 0 ? null : new ZygoteArguments(args, argCount);
    }

    private void parseArgs(ZygoteCommandBuffer args, int argCount) throws IllegalArgumentException, EOFException {
        int curArg;
        String unprocessedArg = null;
        boolean seenRuntimeArgs = false;
        boolean expectRuntimeArgs = true;
        for (curArg = 0; curArg < argCount; ++curArg) {
            int i;
            String arg = args.nextArg();
            if (arg.equals("--")) {
                ++curArg;
                break;
            }
            if (arg.startsWith("--setuid=")) {
                if (this.mUidSpecified) {
                    throw new IllegalArgumentException("Duplicate arg specified");
                }
                this.mUidSpecified = true;
                this.mUid = Integer.parseInt(ZygoteArguments.getAssignmentValue(arg));
                continue;
            }
            if (arg.startsWith("--setgid=")) {
                if (this.mGidSpecified) {
                    throw new IllegalArgumentException("Duplicate arg specified");
                }
                this.mGidSpecified = true;
                this.mGid = Integer.parseInt(ZygoteArguments.getAssignmentValue(arg));
                continue;
            }
            if (arg.startsWith("--target-sdk-version=")) {
                if (this.mTargetSdkVersionSpecified) {
                    throw new IllegalArgumentException("Duplicate target-sdk-version specified");
                }
                this.mTargetSdkVersionSpecified = true;
                this.mTargetSdkVersion = Integer.parseInt(ZygoteArguments.getAssignmentValue(arg));
                continue;
            }
            if (arg.equals("--runtime-args")) {
                seenRuntimeArgs = true;
                continue;
            }
            if (arg.startsWith("--runtime-flags=")) {
                this.mRuntimeFlags = Integer.parseInt(ZygoteArguments.getAssignmentValue(arg));
                continue;
            }
            if (arg.startsWith("--seinfo=")) {
                if (this.mSeInfoSpecified) {
                    throw new IllegalArgumentException("Duplicate arg specified");
                }
                this.mSeInfoSpecified = true;
                this.mSeInfo = ZygoteArguments.getAssignmentValue(arg);
                continue;
            }
            if (arg.startsWith("--capabilities=")) {
                if (this.mCapabilitiesSpecified) {
                    throw new IllegalArgumentException("Duplicate arg specified");
                }
                this.mCapabilitiesSpecified = true;
                String capString = ZygoteArguments.getAssignmentValue(arg);
                String[] capStrings = capString.split(",", 2);
                if (capStrings.length == 1) {
                    this.mPermittedCapabilities = this.mEffectiveCapabilities = Long.decode(capStrings[0]).longValue();
                    continue;
                }
                this.mPermittedCapabilities = Long.decode(capStrings[0]);
                this.mEffectiveCapabilities = Long.decode(capStrings[1]);
                continue;
            }
            if (arg.startsWith("--rlimit=")) {
                String[] limitStrings = ZygoteArguments.getAssignmentList(arg);
                if (limitStrings.length != 3) {
                    throw new IllegalArgumentException("--rlimit= should have 3 comma-delimited ints");
                }
                int[] rlimitTuple = new int[limitStrings.length];
                for (i = 0; i < limitStrings.length; ++i) {
                    rlimitTuple[i] = Integer.parseInt(limitStrings[i]);
                }
                if (this.mRLimits == null) {
                    this.mRLimits = new ArrayList();
                }
                this.mRLimits.add(rlimitTuple);
                continue;
            }
            if (arg.startsWith("--setgroups=")) {
                if (this.mGids != null) {
                    throw new IllegalArgumentException("Duplicate arg specified");
                }
                String[] params = ZygoteArguments.getAssignmentList(arg);
                this.mGids = new int[params.length];
                for (int i2 = params.length - 1; i2 >= 0; --i2) {
                    this.mGids[i2] = Integer.parseInt(params[i2]);
                }
                continue;
            }
            if (arg.equals("--invoke-with")) {
                if (this.mInvokeWith != null) {
                    throw new IllegalArgumentException("Duplicate arg specified");
                }
                try {
                    ++curArg;
                    this.mInvokeWith = args.nextArg();
                    continue;
                }
                catch (IndexOutOfBoundsException ex) {
                    throw new IllegalArgumentException("--invoke-with requires argument");
                }
            }
            if (arg.startsWith("--nice-name=")) {
                if (this.mNiceName != null) {
                    throw new IllegalArgumentException("Duplicate arg specified");
                }
                this.mNiceName = ZygoteArguments.getAssignmentValue(arg);
                continue;
            }
            if (arg.equals("--mount-external-default")) {
                this.mMountExternal = 1;
                continue;
            }
            if (arg.equals("--mount-external-installer")) {
                this.mMountExternal = 2;
                continue;
            }
            if (arg.equals("--mount-external-pass-through")) {
                this.mMountExternal = 3;
                continue;
            }
            if (arg.equals("--mount-external-android-writable")) {
                this.mMountExternal = 4;
                continue;
            }
            if (arg.equals("--query-abi-list")) {
                this.mAbiListQuery = true;
                continue;
            }
            if (arg.equals("--get-pid")) {
                this.mPidQuery = true;
                continue;
            }
            if (arg.equals("--boot-completed")) {
                this.mBootCompleted = true;
                continue;
            }
            if (arg.startsWith("--instruction-set=")) {
                this.mInstructionSet = ZygoteArguments.getAssignmentValue(arg);
                continue;
            }
            if (arg.startsWith("--app-data-dir=")) {
                this.mAppDataDir = ZygoteArguments.getAssignmentValue(arg);
                continue;
            }
            if (arg.equals("--preload-app")) {
                ++curArg;
                this.mPreloadApp = args.nextArg();
                continue;
            }
            if (arg.equals("--preload-default")) {
                this.mPreloadDefault = true;
                expectRuntimeArgs = false;
                continue;
            }
            if (arg.equals("--start-child-zygote")) {
                this.mStartChildZygote = true;
                continue;
            }
            if (arg.equals("--set-api-denylist-exemptions")) {
                this.mApiDenylistExemptions = new String[argCount - curArg - 1];
                ++curArg;
                int i3 = 0;
                while (curArg < argCount) {
                    this.mApiDenylistExemptions[i3] = args.nextArg();
                    ++curArg;
                    ++i3;
                }
                expectRuntimeArgs = false;
                continue;
            }
            if (arg.startsWith("--hidden-api-log-sampling-rate=")) {
                String rateStr = ZygoteArguments.getAssignmentValue(arg);
                try {
                    this.mHiddenApiAccessLogSampleRate = Integer.parseInt(rateStr);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Invalid log sampling rate: " + rateStr, nfe);
                }
                expectRuntimeArgs = false;
                continue;
            }
            if (arg.startsWith("--hidden-api-statslog-sampling-rate=")) {
                String rateStr = ZygoteArguments.getAssignmentValue(arg);
                try {
                    this.mHiddenApiAccessStatslogSampleRate = Integer.parseInt(rateStr);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Invalid statslog sampling rate: " + rateStr, nfe);
                }
                expectRuntimeArgs = false;
                continue;
            }
            if (arg.startsWith("--package-name=")) {
                if (this.mPackageName != null) {
                    throw new IllegalArgumentException("Duplicate arg specified");
                }
                this.mPackageName = ZygoteArguments.getAssignmentValue(arg);
                continue;
            }
            if (arg.startsWith("--usap-pool-enabled=")) {
                this.mUsapPoolStatusSpecified = true;
                this.mUsapPoolEnabled = Boolean.parseBoolean(ZygoteArguments.getAssignmentValue(arg));
                expectRuntimeArgs = false;
                continue;
            }
            if (arg.startsWith("--is-top-app")) {
                this.mIsTopApp = true;
                continue;
            }
            if (arg.startsWith("--disabled-compat-changes=")) {
                if (this.mDisabledCompatChanges != null) {
                    throw new IllegalArgumentException("Duplicate arg specified");
                }
                String[] params = ZygoteArguments.getAssignmentList(arg);
                int length = params.length;
                this.mDisabledCompatChanges = new long[length];
                for (i = 0; i < length; ++i) {
                    this.mDisabledCompatChanges[i] = Long.parseLong(params[i]);
                }
                continue;
            }
            if (arg.startsWith("--pkg-data-info-map")) {
                this.mPkgDataInfoList = ZygoteArguments.getAssignmentList(arg);
                continue;
            }
            if (arg.startsWith("--allowlisted-data-info-map")) {
                this.mAllowlistedDataInfoList = ZygoteArguments.getAssignmentList(arg);
                continue;
            }
            if (arg.equals("--bind-mount-storage-dirs")) {
                this.mBindMountAppStorageDirs = true;
                continue;
            }
            if (arg.equals("--bind-mount-data-dirs")) {
                this.mBindMountAppDataDirs = true;
                continue;
            }
            if (arg.equals("--bind-mount-sysprop-overrides")) {
                this.mBindMountSyspropOverrides = true;
                continue;
            }
            unprocessedArg = arg;
            break;
        }
        if (this.mBootCompleted) {
            if (argCount > curArg) {
                throw new IllegalArgumentException("Unexpected arguments after --boot-completed");
            }
        } else if (this.mAbiListQuery || this.mPidQuery) {
            if (argCount > curArg) {
                throw new IllegalArgumentException("Unexpected arguments after --query-abi-list.");
            }
        } else if (this.mPreloadApp != null) {
            if (argCount > curArg) {
                throw new IllegalArgumentException("Unexpected arguments after --preload-app.");
            }
        } else if (expectRuntimeArgs) {
            if (!seenRuntimeArgs) {
                throw new IllegalArgumentException("Unexpected argument : " + (unprocessedArg == null ? args.nextArg() : unprocessedArg));
            }
            this.mRemainingArgs = new String[argCount - curArg];
            int i = 0;
            if (unprocessedArg != null) {
                this.mRemainingArgs[0] = unprocessedArg;
                ++i;
            }
            while (i < argCount - curArg) {
                this.mRemainingArgs[i] = args.nextArg();
                ++i;
            }
        }
        if (this.mStartChildZygote) {
            boolean seenChildSocketArg = false;
            for (String arg : this.mRemainingArgs) {
                if (!arg.startsWith("--zygote-socket=")) continue;
                seenChildSocketArg = true;
                break;
            }
            if (!seenChildSocketArg) {
                throw new IllegalArgumentException("--start-child-zygote specified without --zygote-socket=");
            }
        }
    }

    private static String getAssignmentValue(String arg) {
        return arg.substring(arg.indexOf(61) + 1);
    }

    private static String[] getAssignmentList(String arg) {
        return ZygoteArguments.getAssignmentValue(arg).split(",");
    }
}

