/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.BatteryConsumer;
import android.os.BatteryStats;
import android.os.Bundle;
import android.os.Parcel;
import android.os.PersistableBundle;
import android.os.UserHandle;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.util.IndentingPrintWriter;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.os.BatteryStatsHistory;
import com.android.modules.utils.TypedXmlPullParser;
import com.android.modules.utils.TypedXmlSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xmlpull.v1.XmlPullParserException;

@RavenwoodKeepWholeClass
public class PowerStats {
    private static final String TAG = "PowerStats";
    private static final BatteryStatsHistory.VarintParceler VARINT_PARCELER = new BatteryStatsHistory.VarintParceler();
    private static final byte PARCEL_FORMAT_VERSION = 2;
    private static final int PARCEL_FORMAT_VERSION_MASK = 255;
    private static final int PARCEL_FORMAT_VERSION_SHIFT = Integer.numberOfTrailingZeros(255);
    private static final int STATS_ARRAY_LENGTH_MASK = 65280;
    private static final int STATS_ARRAY_LENGTH_SHIFT = Integer.numberOfTrailingZeros(65280);
    public static final int MAX_STATS_ARRAY_LENGTH = (1 << Integer.bitCount(65280)) - 1;
    private static final int STATE_STATS_ARRAY_LENGTH_MASK = 0xFF0000;
    private static final int STATE_STATS_ARRAY_LENGTH_SHIFT = Integer.numberOfTrailingZeros(0xFF0000);
    public static final int MAX_STATE_STATS_ARRAY_LENGTH = (1 << Integer.bitCount(0xFF0000)) - 1;
    private static final int UID_STATS_ARRAY_LENGTH_MASK = -16777216;
    private static final int UID_STATS_ARRAY_LENGTH_SHIFT = Integer.numberOfTrailingZeros(-16777216);
    public static final int MAX_UID_STATS_ARRAY_LENGTH = (1 << Integer.bitCount(-16777216)) - 1;
    public final Descriptor descriptor;
    public long durationMs;
    public long[] stats;
    public final SparseArray<long[]> stateStats = new SparseArray();
    public final SparseArray<long[]> uidStats = new SparseArray();

    public PowerStats(Descriptor descriptor) {
        this.descriptor = descriptor;
        this.stats = new long[descriptor.statsArrayLength];
    }

    public void writeToParcel(Parcel parcel) {
        int i;
        int lengthPos = parcel.dataPosition();
        parcel.writeInt(0);
        int startPos = parcel.dataPosition();
        parcel.writeInt(this.descriptor.powerComponentId);
        parcel.writeLong(this.durationMs);
        VARINT_PARCELER.writeLongArray(parcel, this.stats);
        if (this.descriptor.stateStatsArrayLength != 0) {
            parcel.writeInt(this.stateStats.size());
            for (i = 0; i < this.stateStats.size(); ++i) {
                parcel.writeInt(this.stateStats.keyAt(i));
                VARINT_PARCELER.writeLongArray(parcel, this.stateStats.valueAt(i));
            }
        }
        parcel.writeInt(this.uidStats.size());
        for (i = 0; i < this.uidStats.size(); ++i) {
            parcel.writeInt(this.uidStats.keyAt(i));
            VARINT_PARCELER.writeLongArray(parcel, this.uidStats.valueAt(i));
        }
        int endPos = parcel.dataPosition();
        parcel.setDataPosition(lengthPos);
        parcel.writeInt(endPos - startPos);
        parcel.setDataPosition(endPos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static PowerStats readFromParcel(Parcel parcel, DescriptorRegistry registry) {
        int length = parcel.readInt();
        int startPos = parcel.dataPosition();
        int endPos = startPos + length;
        try {
            int i;
            int powerComponentId = parcel.readInt();
            Descriptor descriptor = registry.get(powerComponentId);
            if (descriptor == null) {
                Slog.e(TAG, "Unsupported PowerStats for power component ID: " + powerComponentId);
                PowerStats powerStats = null;
                return powerStats;
            }
            PowerStats stats = new PowerStats(descriptor);
            stats.durationMs = parcel.readLong();
            stats.stats = new long[descriptor.statsArrayLength];
            VARINT_PARCELER.readLongArray(parcel, stats.stats);
            if (descriptor.stateStatsArrayLength != 0) {
                int count = parcel.readInt();
                for (i = 0; i < count; ++i) {
                    int state = parcel.readInt();
                    long[] stateStats = new long[descriptor.stateStatsArrayLength];
                    VARINT_PARCELER.readLongArray(parcel, stateStats);
                    stats.stateStats.put(state, stateStats);
                }
            }
            int uidCount = parcel.readInt();
            for (i = 0; i < uidCount; ++i) {
                int uid = parcel.readInt();
                long[] uidStats = new long[descriptor.uidStatsArrayLength];
                VARINT_PARCELER.readLongArray(parcel, uidStats);
                stats.uidStats.put(uid, uidStats);
            }
            if (parcel.dataPosition() != endPos) {
                Slog.e(TAG, "Corrupted PowerStats parcel. Expected length: " + length + ", actual length: " + (parcel.dataPosition() - startPos));
                PowerStats powerStats = null;
                return powerStats;
            }
            PowerStats powerStats = stats;
            return powerStats;
        }
        finally {
            if (endPos > parcel.dataPosition()) {
                if (endPos >= parcel.dataSize()) {
                    throw new IndexOutOfBoundsException("PowerStats end position: " + endPos + " is outside the parcel bounds: " + parcel.dataSize());
                }
                parcel.setDataPosition(endPos);
            }
        }
    }

    public String formatForBatteryHistory(String uidPrefix) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("duration=").append(this.durationMs).append(" ").append(this.descriptor.name);
        if (this.stats.length > 0) {
            sb.append("=").append(this.descriptor.getDeviceStatsFormatter().format(this.stats));
        }
        if (this.descriptor.stateStatsArrayLength != 0) {
            PowerStatsFormatter formatter = this.descriptor.getStateStatsFormatter();
            for (i = 0; i < this.stateStats.size(); ++i) {
                sb.append(" (");
                sb.append(this.descriptor.getStateLabel(this.stateStats.keyAt(i)));
                sb.append(") ");
                sb.append(formatter.format(this.stateStats.valueAt(i)));
            }
        }
        PowerStatsFormatter uidStatsFormatter = this.descriptor.getUidStatsFormatter();
        for (i = 0; i < this.uidStats.size(); ++i) {
            sb.append(uidPrefix).append(UserHandle.formatUid(this.uidStats.keyAt(i))).append(": ").append(uidStatsFormatter.format(this.uidStats.valueAt(i)));
        }
        return sb.toString();
    }

    public void dump(IndentingPrintWriter pw) {
        int i;
        pw.println(this.descriptor.name + " (" + this.descriptor.powerComponentId + ')');
        pw.increaseIndent();
        pw.print("duration", this.durationMs).println();
        if (this.descriptor.statsArrayLength != 0) {
            pw.println(this.descriptor.getDeviceStatsFormatter().format(this.stats));
        }
        if (this.descriptor.stateStatsArrayLength != 0) {
            PowerStatsFormatter formatter = this.descriptor.getStateStatsFormatter();
            for (i = 0; i < this.stateStats.size(); ++i) {
                pw.print(" (");
                pw.print(this.descriptor.getStateLabel(this.stateStats.keyAt(i)));
                pw.print(") ");
                pw.print(formatter.format(this.stateStats.valueAt(i)));
                pw.println();
            }
        }
        PowerStatsFormatter uidStatsFormatter = this.descriptor.getUidStatsFormatter();
        for (i = 0; i < this.uidStats.size(); ++i) {
            String formattedStats = uidStatsFormatter.format(this.uidStats.valueAt(i));
            if (formattedStats.isBlank()) continue;
            pw.print("UID ");
            pw.print(UserHandle.formatUid(this.uidStats.keyAt(i)));
            pw.print(": ");
            pw.print(formattedStats);
            pw.println();
        }
        pw.decreaseIndent();
    }

    public String toString() {
        return "PowerStats: " + this.formatForBatteryHistory(" UID ");
    }

    @RavenwoodKeepWholeClass
    public static class Descriptor {
        public static final String EXTRA_DEVICE_STATS_FORMAT = "format-device";
        public static final String EXTRA_STATE_STATS_FORMAT = "format-state";
        public static final String EXTRA_UID_STATS_FORMAT = "format-uid";
        public static final String XML_TAG_DESCRIPTOR = "descriptor";
        private static final String XML_ATTR_ID = "id";
        private static final String XML_ATTR_NAME = "name";
        private static final String XML_ATTR_STATS_ARRAY_LENGTH = "stats-array-length";
        private static final String XML_TAG_STATE = "state";
        private static final String XML_ATTR_STATE_KEY = "key";
        private static final String XML_ATTR_STATE_LABEL = "label";
        private static final String XML_ATTR_STATE_STATS_ARRAY_LENGTH = "state-stats-array-length";
        private static final String XML_ATTR_UID_STATS_ARRAY_LENGTH = "uid-stats-array-length";
        private static final String XML_TAG_EXTRAS = "extras";
        public final int powerComponentId;
        public final String name;
        public final int statsArrayLength;
        public final SparseArray<String> stateLabels;
        public final int stateStatsArrayLength;
        public final int uidStatsArrayLength;
        @NonNull
        public final PersistableBundle extras;
        private PowerStatsFormatter mDeviceStatsFormatter;
        private PowerStatsFormatter mStateStatsFormatter;
        private PowerStatsFormatter mUidStatsFormatter;

        public Descriptor(int powerComponentId, int statsArrayLength, @Nullable SparseArray<String> stateLabels, int stateStatsArrayLength, int uidStatsArrayLength, @NonNull PersistableBundle extras) {
            this(powerComponentId, BatteryConsumer.powerComponentIdToString(powerComponentId), statsArrayLength, stateLabels, stateStatsArrayLength, uidStatsArrayLength, extras);
        }

        public Descriptor(int powerComponentId, String name, int statsArrayLength, @Nullable SparseArray<String> stateLabels, int stateStatsArrayLength, int uidStatsArrayLength, @NonNull PersistableBundle extras) {
            if (statsArrayLength > MAX_STATS_ARRAY_LENGTH) {
                throw new IllegalArgumentException("statsArrayLength is too high. Max = " + MAX_STATS_ARRAY_LENGTH);
            }
            if (stateStatsArrayLength > MAX_STATE_STATS_ARRAY_LENGTH) {
                throw new IllegalArgumentException("stateStatsArrayLength is too high. Max = " + MAX_STATE_STATS_ARRAY_LENGTH);
            }
            if (uidStatsArrayLength > MAX_UID_STATS_ARRAY_LENGTH) {
                throw new IllegalArgumentException("uidStatsArrayLength is too high. Max = " + MAX_UID_STATS_ARRAY_LENGTH);
            }
            this.powerComponentId = powerComponentId;
            this.name = name;
            this.statsArrayLength = statsArrayLength;
            this.stateLabels = stateLabels != null ? stateLabels : new SparseArray();
            this.stateStatsArrayLength = stateStatsArrayLength;
            this.uidStatsArrayLength = uidStatsArrayLength;
            this.extras = extras;
        }

        public PowerStatsFormatter getDeviceStatsFormatter() {
            if (this.mDeviceStatsFormatter == null) {
                this.mDeviceStatsFormatter = new PowerStatsFormatter(this.extras.getString(EXTRA_DEVICE_STATS_FORMAT));
            }
            return this.mDeviceStatsFormatter;
        }

        public PowerStatsFormatter getStateStatsFormatter() {
            if (this.mStateStatsFormatter == null) {
                this.mStateStatsFormatter = new PowerStatsFormatter(this.extras.getString(EXTRA_STATE_STATS_FORMAT));
            }
            return this.mStateStatsFormatter;
        }

        public PowerStatsFormatter getUidStatsFormatter() {
            if (this.mUidStatsFormatter == null) {
                this.mUidStatsFormatter = new PowerStatsFormatter(this.extras.getString(EXTRA_UID_STATS_FORMAT));
            }
            return this.mUidStatsFormatter;
        }

        public String getStateLabel(int key) {
            String label = this.stateLabels.get(key);
            if (label != null) {
                return label;
            }
            return this.name + "-" + Integer.toHexString(key);
        }

        public void writeSummaryToParcel(Parcel parcel) {
            int firstWord = 2 << PARCEL_FORMAT_VERSION_SHIFT & 0xFF | this.statsArrayLength << STATS_ARRAY_LENGTH_SHIFT & 0xFF00 | this.stateStatsArrayLength << STATE_STATS_ARRAY_LENGTH_SHIFT & 0xFF0000 | this.uidStatsArrayLength << UID_STATS_ARRAY_LENGTH_SHIFT & 0xFF000000;
            parcel.writeInt(firstWord);
            parcel.writeInt(this.powerComponentId);
            parcel.writeString(this.name);
            parcel.writeInt(this.stateLabels.size());
            int size = this.stateLabels.size();
            for (int i = 0; i < size; ++i) {
                parcel.writeInt(this.stateLabels.keyAt(i));
                parcel.writeString(this.stateLabels.valueAt(i));
            }
            this.extras.writeToParcel(parcel, 0);
        }

        @Nullable
        public static Descriptor readSummaryFromParcel(Parcel parcel) {
            int firstWord = parcel.readInt();
            int version = (firstWord & 0xFF) >>> PARCEL_FORMAT_VERSION_SHIFT;
            if (version != 2) {
                Slog.w(PowerStats.TAG, "Cannot read PowerStats from Parcel - the parcel format version has changed from " + version + " to " + 2);
                return null;
            }
            int statsArrayLength = (firstWord & 0xFF00) >>> STATS_ARRAY_LENGTH_SHIFT;
            int stateStatsArrayLength = (firstWord & 0xFF0000) >>> STATE_STATS_ARRAY_LENGTH_SHIFT;
            int uidStatsArrayLength = (firstWord & 0xFF000000) >>> UID_STATS_ARRAY_LENGTH_SHIFT;
            int powerComponentId = parcel.readInt();
            String name = parcel.readString();
            int stateLabelCount = parcel.readInt();
            SparseArray<String> stateLabels = new SparseArray<String>(stateLabelCount);
            for (int i = stateLabelCount; i > 0; --i) {
                int key = parcel.readInt();
                String label = parcel.readString();
                stateLabels.put(key, label);
            }
            PersistableBundle extras = parcel.readPersistableBundle();
            return new Descriptor(powerComponentId, name, statsArrayLength, stateLabels, stateStatsArrayLength, uidStatsArrayLength, extras);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Descriptor)) {
                return false;
            }
            Descriptor that = (Descriptor)o;
            if (this.powerComponentId != that.powerComponentId || this.statsArrayLength != that.statsArrayLength || !this.stateLabels.contentEquals(that.stateLabels) || this.stateStatsArrayLength != that.stateStatsArrayLength || this.uidStatsArrayLength != that.uidStatsArrayLength || !Objects.equals(this.name, that.name)) {
                return false;
            }
            if (this.extras.size() != that.extras.size()) {
                return false;
            }
            if (Bundle.kindofEquals(this.extras, that.extras)) {
                return true;
            }
            for (String key : this.extras.keySet()) {
                if (Objects.deepEquals(this.extras.get(key), that.extras.get(key))) continue;
                return false;
            }
            return true;
        }

        public void writeXml(TypedXmlSerializer serializer) throws IOException {
            serializer.startTag(null, XML_TAG_DESCRIPTOR);
            serializer.attributeInt(null, XML_ATTR_ID, this.powerComponentId);
            serializer.attribute(null, XML_ATTR_NAME, this.name);
            serializer.attributeInt(null, XML_ATTR_STATS_ARRAY_LENGTH, this.statsArrayLength);
            serializer.attributeInt(null, XML_ATTR_STATE_STATS_ARRAY_LENGTH, this.stateStatsArrayLength);
            serializer.attributeInt(null, XML_ATTR_UID_STATS_ARRAY_LENGTH, this.uidStatsArrayLength);
            for (int i = this.stateLabels.size() - 1; i >= 0; --i) {
                serializer.startTag(null, XML_TAG_STATE);
                serializer.attributeInt(null, XML_ATTR_STATE_KEY, this.stateLabels.keyAt(i));
                serializer.attribute(null, XML_ATTR_STATE_LABEL, this.stateLabels.valueAt(i));
                serializer.endTag(null, XML_TAG_STATE);
            }
            try {
                serializer.startTag(null, XML_TAG_EXTRAS);
                this.extras.saveToXml(serializer);
                serializer.endTag(null, XML_TAG_EXTRAS);
            }
            catch (XmlPullParserException e) {
                throw new IOException(e);
            }
            serializer.endTag(null, XML_TAG_DESCRIPTOR);
        }

        public static Descriptor createFromXml(TypedXmlPullParser parser) throws XmlPullParserException, IOException {
            int powerComponentId = -1;
            String name = null;
            int statsArrayLength = 0;
            SparseArray<String> stateLabels = new SparseArray<String>();
            int stateStatsArrayLength = 0;
            int uidStatsArrayLength = 0;
            PersistableBundle extras = null;
            int eventType = parser.getEventType();
            while (!(eventType == 1 || eventType == 3 && parser.getName().equals(XML_TAG_DESCRIPTOR))) {
                if (eventType == 2) {
                    switch (parser.getName()) {
                        case "descriptor": {
                            powerComponentId = parser.getAttributeInt(null, XML_ATTR_ID);
                            name = parser.getAttributeValue(null, XML_ATTR_NAME);
                            statsArrayLength = parser.getAttributeInt(null, XML_ATTR_STATS_ARRAY_LENGTH);
                            stateStatsArrayLength = parser.getAttributeInt(null, XML_ATTR_STATE_STATS_ARRAY_LENGTH);
                            uidStatsArrayLength = parser.getAttributeInt(null, XML_ATTR_UID_STATS_ARRAY_LENGTH);
                            break;
                        }
                        case "state": {
                            int value = parser.getAttributeInt(null, XML_ATTR_STATE_KEY);
                            String label = parser.getAttributeValue(null, XML_ATTR_STATE_LABEL);
                            stateLabels.put(value, label);
                            break;
                        }
                        case "extras": {
                            extras = PersistableBundle.restoreFromXml(parser);
                        }
                    }
                }
                eventType = parser.next();
            }
            if (powerComponentId == -1) {
                return null;
            }
            if (powerComponentId >= 1000) {
                return new Descriptor(powerComponentId, name, statsArrayLength, stateLabels, stateStatsArrayLength, uidStatsArrayLength, extras);
            }
            if (powerComponentId < 19) {
                return new Descriptor(powerComponentId, statsArrayLength, stateLabels, stateStatsArrayLength, uidStatsArrayLength, extras);
            }
            Slog.e(PowerStats.TAG, "Unrecognized power component: " + powerComponentId);
            return null;
        }

        public int hashCode() {
            return Objects.hash(this.powerComponentId);
        }

        public String toString() {
            if (this.extras != null) {
                this.extras.size();
            }
            return "PowerStats.Descriptor{powerComponentId=" + this.powerComponentId + ", name='" + this.name + '\'' + ", statsArrayLength=" + this.statsArrayLength + ", stateStatsArrayLength=" + this.stateStatsArrayLength + ", stateLabels=" + this.stateLabels + ", uidStatsArrayLength=" + this.uidStatsArrayLength + ", extras=" + this.extras + '}';
        }
    }

    public static class DescriptorRegistry {
        private final SparseArray<Descriptor> mDescriptors = new SparseArray();

        public void register(Descriptor descriptor) {
            this.mDescriptors.put(descriptor.powerComponentId, descriptor);
        }

        public Descriptor get(int powerComponentId) {
            return this.mDescriptors.get(powerComponentId);
        }
    }

    public static class PowerStatsFormatter {
        private static final double NANO_TO_MILLI_MULTIPLIER = 1.0E-6;
        private static final Pattern SECTION_PATTERN = Pattern.compile("([^:]+):(\\d+)(\\[(?<L>\\d+)])?(?<F>\\S*)\\s*");
        private final List<Section> mSections;

        public PowerStatsFormatter(String format) {
            this.mSections = this.parseFormat(format);
        }

        public String format(long[] stats) {
            return this.format(this.mSections, stats);
        }

        private List<Section> parseFormat(String format) {
            if (format == null || format.isBlank()) {
                return null;
            }
            ArrayList<Section> sections = new ArrayList<Section>();
            Matcher matcher = SECTION_PATTERN.matcher(format);
            int position = 0;
            while (position < format.length()) {
                if (!matcher.find() || matcher.start() != position) {
                    Slog.wtf(PowerStats.TAG, "Bad power stats format '" + format + "'");
                    return null;
                }
                Section section = new Section();
                section.label = matcher.group(1);
                section.position = Integer.parseUnsignedInt(matcher.group(2));
                String length = matcher.group("L");
                section.length = length != null ? Integer.parseUnsignedInt(length) : 1;
                String flags = matcher.group("F");
                if (flags != null) {
                    block5: for (int i = 0; i < flags.length(); ++i) {
                        char flag = flags.charAt(i);
                        switch (flag) {
                            case '?': {
                                section.optional = true;
                                continue block5;
                            }
                            case 'p': {
                                section.typePower = true;
                                continue block5;
                            }
                            default: {
                                Slog.e(PowerStats.TAG, "Unsupported format option '" + flag + "' in " + format);
                            }
                        }
                    }
                }
                sections.add(section);
                position = matcher.end();
            }
            return sections;
        }

        private String format(List<Section> sections, long[] stats) {
            if (sections == null) {
                return Arrays.toString(stats);
            }
            StringBuilder sb = new StringBuilder();
            int count = sections.size();
            for (int i = 0; i < count; ++i) {
                Section section = sections.get(i);
                if (section.length == 0) continue;
                if (section.optional) {
                    boolean nonZero = false;
                    for (int offset = 0; offset < section.length; ++offset) {
                        if (stats[section.position + offset] == 0L) continue;
                        nonZero = true;
                        break;
                    }
                    if (!nonZero) continue;
                }
                if (!sb.isEmpty()) {
                    sb.append(' ');
                }
                sb.append(section.label).append(": ");
                if (section.length != 1) {
                    sb.append('[');
                }
                for (int offset = 0; offset < section.length; ++offset) {
                    if (offset != 0) {
                        sb.append(", ");
                    }
                    if (section.typePower) {
                        sb.append(BatteryStats.formatCharge((double)stats[section.position + offset] * 1.0E-6));
                        continue;
                    }
                    sb.append(stats[section.position + offset]);
                }
                if (section.length == 1) continue;
                sb.append(']');
            }
            return sb.toString();
        }

        private static class Section {
            public String label;
            public int position;
            public int length;
            public boolean optional;
            public boolean typePower;

            private Section() {
            }
        }
    }
}

