/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Intent;
import android.content.pm.ServiceInfo;
import com.android.internal.annotations.VisibleForTesting;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class DebugStore {
    private static final boolean DEBUG_EVENTS = false;
    private static final String TAG = "DebugStore";
    private static DebugStoreNative sDebugStoreNative = new DebugStoreNativeImpl();

    @UnsupportedAppUsage
    @VisibleForTesting
    public static void setDebugStoreNative(DebugStoreNative nativeImpl) {
        sDebugStoreNative = nativeImpl;
    }

    @UnsupportedAppUsage
    public static void recordScheduleServiceStart(int msgId, @Nullable Intent intent) {
        sDebugStoreNative.recordEvent("SchSvcStart", List.of("tname", Thread.currentThread().getName(), "tid", String.valueOf(Thread.currentThread().getId()), "act", DebugStore.intentAct(intent), "cmp", DebugStore.intentCmp(intent), "mid", Integer.toHexString(msgId)));
    }

    @UnsupportedAppUsage
    public static long recordServiceStart(int msgId) {
        return sDebugStoreNative.beginEvent("SvcStart", List.of("mid", Integer.toHexString(msgId)));
    }

    @UnsupportedAppUsage
    public static void recordScheduleServiceCreate(int msgId, @Nullable ServiceInfo serviceInfo) {
        sDebugStoreNative.recordEvent("SchSvcCreate", List.of("tname", Thread.currentThread().getName(), "tid", String.valueOf(Thread.currentThread().getId()), "name", Objects.toString(serviceInfo != null ? serviceInfo.name : null), "mid", Integer.toHexString(msgId)));
    }

    @UnsupportedAppUsage
    public static long recordServiceCreate(int msgId) {
        return sDebugStoreNative.beginEvent("SvcCreate", List.of("mid", Integer.toHexString(msgId)));
    }

    @UnsupportedAppUsage
    public static void recordScheduleServiceBind(int msgId, @Nullable Intent intent) {
        sDebugStoreNative.recordEvent("SchSvcBind", List.of("tname", Thread.currentThread().getName(), "tid", String.valueOf(Thread.currentThread().getId()), "act", DebugStore.intentAct(intent), "cmp", DebugStore.intentCmp(intent), "mid", Integer.toHexString(msgId)));
    }

    @UnsupportedAppUsage
    public static long recordServiceBind(int msgId) {
        return sDebugStoreNative.beginEvent("SvcBind", List.of("mid", Integer.toHexString(msgId)));
    }

    @UnsupportedAppUsage
    public static void recordScheduleBroadcastReceive(int pendingResultId, @Nullable Intent intent) {
        sDebugStoreNative.recordEvent("SchRcv", List.of("tname", Thread.currentThread().getName(), "tid", String.valueOf(Thread.currentThread().getId()), "act", Objects.toString(intent != null ? intent.getAction() : null), "cmp", DebugStore.intentCmp(intent), "prid", Integer.toHexString(pendingResultId)));
    }

    @UnsupportedAppUsage
    public static long recordBroadcastReceive(int pendingResultId, String receiverClass) {
        return sDebugStoreNative.beginEvent("Rcv", List.of("tname", Thread.currentThread().getName(), "tid", String.valueOf(Thread.currentThread().getId()), "cls", Objects.toString(receiverClass), "prid", Integer.toHexString(pendingResultId)));
    }

    @UnsupportedAppUsage
    public static void recordScheduleBroadcastReceiveReg(int pendingResultId, @Nullable Intent intent) {
        sDebugStoreNative.recordEvent("SchRcvReg", List.of("tname", Thread.currentThread().getName(), "tid", String.valueOf(Thread.currentThread().getId()), "act", DebugStore.intentAct(intent), "cmp", DebugStore.intentCmp(intent), "prid", Integer.toHexString(pendingResultId)));
    }

    @UnsupportedAppUsage
    public static long recordBroadcastReceiveReg(int pendingResultId, String receiverClass) {
        return sDebugStoreNative.beginEvent("RcvReg", List.of("tname", Thread.currentThread().getName(), "tid", String.valueOf(Thread.currentThread().getId()), "cls", Objects.toString(receiverClass), "prid", Integer.toHexString(pendingResultId)));
    }

    @UnsupportedAppUsage
    public static void recordGoAsync(int pendingResultId) {
        sDebugStoreNative.recordEvent("GoAsync", List.of("tname", Thread.currentThread().getName(), "tid", String.valueOf(Thread.currentThread().getId()), "prid", Integer.toHexString(pendingResultId)));
    }

    @UnsupportedAppUsage
    public static void recordFinish(int pendingResultId) {
        sDebugStoreNative.recordEvent("Finish", List.of("tname", Thread.currentThread().getName(), "tid", String.valueOf(Thread.currentThread().getId()), "prid", Integer.toHexString(pendingResultId)));
    }

    @UnsupportedAppUsage
    public static void recordScheduleBindApplication() {
        sDebugStoreNative.recordEvent("SchBindApp", List.of());
    }

    @UnsupportedAppUsage
    public static long recordBindApplication() {
        return sDebugStoreNative.beginEvent("BindApp", List.of());
    }

    @UnsupportedAppUsage
    public static void recordScheduleStartJob(int msgId, int jobId, @Nullable String jobNamespace) {
        sDebugStoreNative.recordEvent("SchJobStart", List.of("tname", Thread.currentThread().getName(), "tid", String.valueOf(Thread.currentThread().getId()), "jobid", String.valueOf(jobId), "jobns", String.valueOf(jobNamespace), "mid", Integer.toHexString(msgId)));
    }

    @UnsupportedAppUsage
    public static long recordStartJob(int msgId) {
        return sDebugStoreNative.beginEvent("JobStart", List.of("mid", Integer.toHexString(msgId)));
    }

    @UnsupportedAppUsage
    public static void recordScheduleStopJob(int msgId, int jobId, @Nullable String jobNamespace) {
        sDebugStoreNative.recordEvent("SchJobStop", List.of("tname", Thread.currentThread().getName(), "tid", String.valueOf(Thread.currentThread().getId()), "jobid", String.valueOf(jobId), "jobns", String.valueOf(jobNamespace), "mid", Integer.toHexString(msgId)));
    }

    @UnsupportedAppUsage
    public static long recordStopJob(int msgId) {
        return sDebugStoreNative.beginEvent("JobStop", List.of("mid", Integer.toHexString(msgId)));
    }

    @UnsupportedAppUsage
    public static void recordLongLooperMessage(int messageCode, String targetClass, long elapsedTimeMs) {
        sDebugStoreNative.recordEvent("LooperMsg", List.of("code", String.valueOf(messageCode), "trgt", Objects.toString(targetClass), "elapsed", String.valueOf(elapsedTimeMs)));
    }

    @UnsupportedAppUsage
    public static void recordEventEnd(long id2) {
        sDebugStoreNative.endEvent(id2, Collections.emptyList());
    }

    private static String intentAct(@Nullable Intent intent) {
        return Objects.toString(intent != null ? intent.getAction() : null);
    }

    private static String intentCmp(@Nullable Intent intent) {
        return Objects.toString(intent != null && intent.getComponent() != null ? intent.getComponent().flattenToShortString() : null);
    }

    private static long beginEventNative(String string2, List<String> list) {
        return OverrideMethod.invokeL("com.android.internal.os.DebugStore#beginEventNative(Ljava/lang/String;Ljava/util/List;)J", true, null);
    }

    private static void endEventNative(long l, List<String> list) {
        OverrideMethod.invokeV("com.android.internal.os.DebugStore#endEventNative(JLjava/util/List;)V", true, null);
    }

    private static void recordEventNative(String string2, List<String> list) {
        OverrideMethod.invokeV("com.android.internal.os.DebugStore#recordEventNative(Ljava/lang/String;Ljava/util/List;)V", true, null);
    }

    @VisibleForTesting
    public static interface DebugStoreNative {
        public long beginEvent(String var1, List<String> var2);

        public void endEvent(long var1, List<String> var3);

        public void recordEvent(String var1, List<String> var2);
    }

    private static class DebugStoreNativeImpl
    implements DebugStoreNative {
        private DebugStoreNativeImpl() {
        }

        @Override
        public long beginEvent(String eventName, List<String> attributes) {
            long id2 = DebugStore.beginEventNative(eventName, attributes);
            return id2;
        }

        @Override
        public void endEvent(long id2, List<String> attributes) {
            DebugStore.endEventNative(id2, attributes);
        }

        @Override
        public void recordEvent(String eventName, List<String> attributes) {
            DebugStore.recordEventNative(eventName, attributes);
        }

        private String attributeString(List<String> attributes) {
            StringBuilder sb = new StringBuilder().append("[");
            for (int i = 0; i < attributes.size(); ++i) {
                sb.append(attributes.get(i));
                if (i % 2 == 0) {
                    sb.append("=");
                    continue;
                }
                if (i >= attributes.size() - 1) continue;
                sb.append(", ");
            }
            return sb.append("]").toString();
        }
    }
}

