/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.annotation.NonNull;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.util.SparseArray;
import java.util.Arrays;
import libcore.util.EmptyArray;

@RavenwoodKeepWholeClass
public class CpuScalingPolicies {
    private final SparseArray<int[]> mCpusByPolicy;
    private final SparseArray<int[]> mFreqsByPolicy;
    private final int[] mPolicies;
    private final int mScalingStepCount;

    public CpuScalingPolicies(@NonNull SparseArray<int[]> cpusByPolicy, @NonNull SparseArray<int[]> freqsByPolicy) {
        this.mCpusByPolicy = cpusByPolicy;
        this.mFreqsByPolicy = freqsByPolicy;
        this.mPolicies = new int[cpusByPolicy.size()];
        for (int i = 0; i < this.mPolicies.length; ++i) {
            this.mPolicies[i] = cpusByPolicy.keyAt(i);
        }
        Arrays.sort(this.mPolicies);
        int count = 0;
        for (int i = freqsByPolicy.size() - 1; i >= 0; --i) {
            count += freqsByPolicy.valueAt(i).length;
        }
        this.mScalingStepCount = count;
    }

    @NonNull
    public int[] getPolicies() {
        return this.mPolicies;
    }

    @NonNull
    public int[] getRelatedCpus(int policy) {
        return this.mCpusByPolicy.get(policy, EmptyArray.INT);
    }

    @NonNull
    public int[] getFrequencies(int policy) {
        return this.mFreqsByPolicy.get(policy, EmptyArray.INT);
    }

    public int getScalingStepCount() {
        return this.mScalingStepCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int policy : this.mPolicies) {
            sb.append("policy").append(policy).append("\n CPUs: ").append(Arrays.toString(this.mCpusByPolicy.get(policy))).append("\n freqs: ").append(Arrays.toString(this.mFreqsByPolicy.get(policy))).append("\n");
        }
        return sb.toString();
    }
}

