/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import java.util.Arrays;

@RavenwoodKeepWholeClass
public class BinderLatencyBuckets {
    private static final String TAG = "BinderLatencyBuckets";
    private final int[] mBuckets;

    public BinderLatencyBuckets(int bucketCount, int firstBucketSize, float scaleFactor) {
        int[] buffer = new int[bucketCount - 1];
        buffer[0] = firstBucketSize;
        double lastTarget = firstBucketSize;
        for (int i = 1; i < bucketCount - 1; ++i) {
            double nextTarget = lastTarget * (double)scaleFactor;
            if (nextTarget > 2.147483647E9) {
                Slog.w(TAG, "Attempted to create a bucket larger than maxint");
                this.mBuckets = Arrays.copyOfRange(buffer, 0, i);
                return;
            }
            buffer[i] = (int)nextTarget > buffer[i - 1] ? (int)nextTarget : buffer[i - 1] + 1;
            lastTarget = nextTarget;
        }
        this.mBuckets = buffer;
    }

    public int sampleToBucket(int sample) {
        if (sample >= this.mBuckets[this.mBuckets.length - 1]) {
            return this.mBuckets.length;
        }
        int searchResult = Arrays.binarySearch(this.mBuckets, sample);
        return searchResult < 0 ? -(1 + searchResult) : searchResult + 1;
    }

    @VisibleForTesting
    public int[] getBuckets() {
        return this.mBuckets;
    }
}

