/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.net.ipsec.ike.message;

import android.net.ipsec.ike.exceptions.IkeProtocolException;
import android.net.ipsec.ike.exceptions.InvalidMajorVersionException;
import android.net.ipsec.ike.exceptions.InvalidSyntaxException;
import android.util.SparseArray;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;

public class IkeHeader {
    private static final byte IKE_HEADER_VERSION_INFO = 32;
    private static final byte IKE_HEADER_FLAG_IS_RESP_MSG = 32;
    private static final byte IKE_HEADER_FLAG_FROM_IKE_INITIATOR = 8;
    private static final SparseArray<String> EXCHANGE_TYPE_TO_STRING = new SparseArray();
    public static final int IKE_HEADER_LENGTH = 28;
    public static final int EXCHANGE_TYPE_IKE_SA_INIT = 34;
    public static final int EXCHANGE_TYPE_IKE_AUTH = 35;
    public static final int EXCHANGE_TYPE_CREATE_CHILD_SA = 36;
    public static final int EXCHANGE_TYPE_INFORMATIONAL = 37;
    public final long ikeInitiatorSpi;
    public final long ikeResponderSpi;
    public final int nextPayloadType;
    public final byte majorVersion;
    public final byte minorVersion;
    public final int exchangeType;
    public final boolean isResponseMsg;
    public final boolean fromIkeInitiator;
    public final int messageId;
    private static final int ENCODED_MESSAGE_LEN_UNAVAILABLE = -1;
    private final int mEncodedMessageLength;

    public IkeHeader(long iSpi, long rSpi, int nextPType, int eType, boolean isResp, boolean fromInit, int msgId) {
        this.ikeInitiatorSpi = iSpi;
        this.ikeResponderSpi = rSpi;
        this.nextPayloadType = nextPType;
        this.exchangeType = eType;
        this.isResponseMsg = isResp;
        this.fromIkeInitiator = fromInit;
        this.messageId = msgId;
        this.mEncodedMessageLength = -1;
        this.majorVersion = (byte)2;
        this.minorVersion = 0;
    }

    public IkeHeader(byte[] packet) throws IkeProtocolException {
        if (packet.length <= 28) {
            throw new InvalidSyntaxException("IKE message is too short to contain a header");
        }
        ByteBuffer buffer = ByteBuffer.wrap(packet);
        this.ikeInitiatorSpi = buffer.getLong();
        this.ikeResponderSpi = buffer.getLong();
        this.nextPayloadType = Byte.toUnsignedInt(buffer.get());
        byte versionByte = buffer.get();
        this.majorVersion = (byte)(versionByte >> 4 & 0xF);
        this.minorVersion = (byte)(versionByte & 0xF);
        this.exchangeType = Byte.toUnsignedInt(buffer.get());
        byte flagsByte = buffer.get();
        this.isResponseMsg = (flagsByte & 0x20) != 0;
        this.fromIkeInitiator = (flagsByte & 8) != 0;
        this.messageId = buffer.getInt();
        this.mEncodedMessageLength = buffer.getInt();
    }

    IkeHeader makeSkfHeaderFromSkHeader() {
        if (this.nextPayloadType != 46) {
            throw new IllegalArgumentException("Next payload type is not SK.");
        }
        return new IkeHeader(this.ikeInitiatorSpi, this.ikeResponderSpi, 53, this.exchangeType, this.isResponseMsg, this.fromIkeInitiator, this.messageId);
    }

    @VisibleForTesting
    int getInboundMessageLength() {
        if (this.mEncodedMessageLength == -1) {
            throw new UnsupportedOperationException("It is not supported to get encoded message length from an outbound message.");
        }
        return this.mEncodedMessageLength;
    }

    public void validateMajorVersion() throws IkeProtocolException {
        if (this.majorVersion > 2) {
            throw new InvalidMajorVersionException(this.majorVersion);
        }
        if (this.majorVersion < 2) {
            throw new InvalidSyntaxException("Major version is smaller than 2.");
        }
    }

    public void validateInboundHeader(int packetLength) throws IkeProtocolException {
        if (this.exchangeType < 34 || this.exchangeType > 37) {
            throw new InvalidSyntaxException("Invalid IKE Exchange Type.");
        }
        if (this.mEncodedMessageLength != packetLength) {
            throw new InvalidSyntaxException("Invalid IKE Message Length.");
        }
    }

    public void encodeToByteBuffer(ByteBuffer byteBuffer, int encodedMessageBodyLen) {
        byteBuffer.putLong(this.ikeInitiatorSpi).putLong(this.ikeResponderSpi).put((byte)this.nextPayloadType).put((byte)32).put((byte)this.exchangeType);
        byte flag = 0;
        if (this.isResponseMsg) {
            flag = (byte)(flag | 0x20);
        }
        if (this.fromIkeInitiator) {
            flag = (byte)(flag | 8);
        }
        byteBuffer.put(flag).putInt(this.messageId).putInt(28 + encodedMessageBodyLen);
    }

    public String getBasicInfoString() {
        String exchangeStr = EXCHANGE_TYPE_TO_STRING.get(this.exchangeType);
        if (exchangeStr == null) {
            exchangeStr = "Unknown exchange (" + this.exchangeType + ")";
        }
        String reqOrResp = this.isResponseMsg ? "response" : "request";
        return exchangeStr + " " + reqOrResp + " " + this.messageId;
    }

    static {
        EXCHANGE_TYPE_TO_STRING.put(34, "IKE INIT");
        EXCHANGE_TYPE_TO_STRING.put(35, "IKE AUTH");
        EXCHANGE_TYPE_TO_STRING.put(36, "Create Child");
        EXCHANGE_TYPE_TO_STRING.put(37, "Informational");
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ExchangeType {
    }
}

